/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.io.read.CyTableReader;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListMultipleSelection;
import org.cytoscape.work.util.ListSingleSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinTablesTask
extends AbstractTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String NO_NETWORKS = "No Networks Found";
    private boolean byReader;
    private CyTableReader reader;
    private CyTable globalTable;
    private CyRootNetworkManager rootNetworkManager;
    private CyNetworkManager networkManager;
    private Map<String, CyNetwork> name2NetworkMap;
    private Map<String, CyRootNetwork> name2RootMap;
    private Map<String, String> source2targetColumnMap;
    public ListSingleSelection<TableType> dataTypeOptions;
    public ListSingleSelection<String> rootNetworkList;
    public ListSingleSelection<String> columnList;
    public boolean selectedNetworksOnly = false;
    public ListMultipleSelection<String> networkList;

    @Tunable(description="Import Data as:")
    public ListSingleSelection<TableType> getDataTypeOptions() {
        return this.dataTypeOptions;
    }

    public void setDataTypeOptions(ListSingleSelection<TableType> options) {
        ListSingleSelection<String> tempList = this.getColumns((CyNetwork)this.name2RootMap.get(this.rootNetworkList.getSelectedValue()), (TableType)((Object)this.dataTypeOptions.getSelectedValue()), "SHARED_ATTRS");
        if (!this.columnList.getPossibleValues().containsAll(tempList.getPossibleValues()) || this.columnList.getPossibleValues().size() != tempList.getPossibleValues().size()) {
            this.columnList = tempList;
        }
    }

    @Tunable(description="Network Collection", groups={"Select a Network Collection"}, dependsOn="SelectedNetworksOnly=false", params="displayState=uncollapsed")
    public ListSingleSelection<String> getRootNetworkList() {
        return this.rootNetworkList;
    }

    public void setRootNetworkList(ListSingleSelection<String> roots) {
        ListSingleSelection<String> tempList = this.getColumns((CyNetwork)this.name2RootMap.get(this.rootNetworkList.getSelectedValue()), (TableType)((Object)this.dataTypeOptions.getSelectedValue()), "SHARED_ATTRS");
        if (!this.columnList.getPossibleValues().containsAll(tempList.getPossibleValues()) || this.columnList.getPossibleValues().size() != tempList.getPossibleValues().size()) {
            this.columnList = tempList;
        }
    }

    @Tunable(description="Key Column for Network:", groups={"Select a Network Collection"}, listenForChange={"DataTypeOptions", "RootNetworkList"}, dependsOn="SelectedNetworksOnly=false", params="displayState=uncollapsed")
    public ListSingleSelection<String> getColumnList() {
        return this.columnList;
    }

    public void setColumnList(ListSingleSelection<String> colList) {
        this.columnList = colList;
    }

    @Tunable(description="Or apply to selected networks only")
    public boolean getSelectedNetworksOnly() {
        return this.selectedNetworksOnly;
    }

    public void setSelectedNetworksOnly(boolean selectedOnly) {
        this.selectedNetworksOnly = selectedOnly;
    }

    @Tunable(description="Network List", groups={"Select Networks"}, dependsOn="SelectedNetworksOnly=true", params="displayState=collapsed")
    public ListMultipleSelection<String> getNetworkList() {
        return this.networkList;
    }

    public void setNetworkList(ListMultipleSelection<String> list) {
        this.networkList = list;
    }

    @ProvidesTitle
    public String getTitle() {
        return "Import Data ";
    }

    public JoinTablesTask(CyTableReader reader, CyRootNetworkManager rootNetworkManeger, CyNetworkManager networkManager) {
        this.reader = reader;
        this.byReader = true;
        this.globalTable = null;
        this.init(rootNetworkManeger, networkManager);
    }

    public JoinTablesTask(CyTable globalTable, CyRootNetworkManager rootNetworkManeger, CyNetworkManager networkManager) {
        this.reader = null;
        this.byReader = false;
        this.globalTable = globalTable;
        this.init(rootNetworkManeger, networkManager);
    }

    private final void init(CyRootNetworkManager rootNetworkManeger, CyNetworkManager networkManager) {
        this.rootNetworkManager = rootNetworkManeger;
        this.networkManager = networkManager;
        this.name2NetworkMap = new HashMap<String, CyNetwork>();
        this.name2RootMap = new HashMap<String, CyRootNetwork>();
        this.source2targetColumnMap = new HashMap<String, String>();
        this.initTunable(networkManager);
    }

    private final void initTunable(CyNetworkManager networkManage) {
        this.selectedNetworksOnly = false;
        ArrayList<TableType> options = new ArrayList<TableType>();
        for (TableType type : TableType.values()) {
            options.add(type);
        }
        this.dataTypeOptions = new ListSingleSelection(options);
        this.dataTypeOptions.setSelectedValue((Object)TableType.NODE_ATTR);
        for (CyNetwork net : networkManage.getNetworkSet()) {
            String netName = (String)net.getRow((CyIdentifiable)net).get("name", String.class);
            this.name2NetworkMap.put(netName, net);
        }
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.name2NetworkMap.keySet());
        this.networkList = names.isEmpty() ? new ListMultipleSelection((Object[])new String[]{NO_NETWORKS}) : new ListMultipleSelection(names);
        for (CyNetwork net : this.networkManager.getNetworkSet()) {
            CyRootNetwork rootNet = this.rootNetworkManager.getRootNetwork(net);
            if (this.name2RootMap.containsValue(rootNet)) continue;
            this.name2RootMap.put((String)rootNet.getRow((CyIdentifiable)rootNet).get("name", String.class), rootNet);
        }
        ArrayList<String> rootNames = new ArrayList<String>();
        rootNames.addAll(this.name2RootMap.keySet());
        this.rootNetworkList = new ListSingleSelection(rootNames);
        this.rootNetworkList.setSelectedValue((Object)((String)rootNames.get(0)));
        this.columnList = this.getColumns((CyNetwork)this.name2RootMap.get(this.rootNetworkList.getSelectedValue()), (TableType)((Object)this.dataTypeOptions.getSelectedValue()), "SHARED_ATTRS");
    }

    public ListSingleSelection<String> getColumns(CyNetwork network, TableType tableType, String namespace) {
        CyTable selectedTable = this.getTable(network, tableType, "SHARED_ATTRS");
        ArrayList<String> colNames = new ArrayList<String>();
        for (CyColumn col : selectedTable.getColumns()) {
            colNames.add(col.getName());
        }
        ListSingleSelection columns = new ListSingleSelection(colNames);
        columns.setSelectedValue((Object)"shared name");
        return columns;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        TableType tableType = (TableType)((Object)this.dataTypeOptions.getSelectedValue());
        if (!this.checkKeys()) {
            throw new IllegalArgumentException("Types of keys selected for tables are not matching.");
        }
        if (!this.selectedNetworksOnly) {
            this.mapTableToDefaultAttrs(tableType);
        } else {
            this.mapTableToLocalAttrs(tableType);
        }
    }

    private void mapTableToLocalAttrs(TableType tableType) {
        ArrayList<CyNetwork> networks = new ArrayList<CyNetwork>();
        if (this.networkList.getSelectedValues().isEmpty()) {
            return;
        }
        if (!((String)this.networkList.getSelectedValues().get(0)).equals(NO_NETWORKS)) {
            for (String netName : this.networkList.getSelectedValues()) {
                networks.add(this.name2NetworkMap.get(netName));
            }
        }
        for (CyNetwork network : networks) {
            CyTable targetTable = this.getTable(network, tableType, "LOCAL_ATTRS");
            if (targetTable == null) continue;
            this.applyMapping(targetTable);
        }
    }

    private void mapTableToDefaultAttrs(TableType tableType) {
        CyTable targetTable = this.getTable((CyNetwork)this.name2RootMap.get(this.rootNetworkList.getSelectedValue()), tableType, "SHARED_DEFAULT_ATTRS");
        if (targetTable != null) {
            this.applyMapping(targetTable);
        }
    }

    private CyTable getTable(CyNetwork network, TableType tableType, String namespace) {
        if (tableType == TableType.NODE_ATTR) {
            return network.getTable(CyNode.class, namespace);
        }
        if (tableType == TableType.EDGE_ATTR) {
            return network.getTable(CyEdge.class, namespace);
        }
        if (tableType == TableType.NETWORK_ATTR) {
            return network.getTable(CyNetwork.class, namespace);
        }
        logger.warn("The selected table type is not valie. \nTable needs to be one of these types: " + TableType.NODE_ATTR + ", " + TableType.EDGE_ATTR + ", " + TableType.NETWORK_ATTR + ".");
        return null;
    }

    private void applyMapping(CyTable targetTable) {
        if (this.byReader) {
            if (this.reader.getTables() != null && this.reader.getTables().length > 0) {
                for (CyTable sourceTable : this.reader.getTables()) {
                    this.copyColumns(sourceTable, targetTable);
                    this.copyRows(sourceTable, targetTable);
                }
            }
        } else {
            this.copyColumns(this.globalTable, targetTable);
            this.copyRows(this.globalTable, targetTable);
        }
    }

    private CyColumn getJoinTargetColumn(CyTable targetTable) {
        String joinKeyName = "name";
        if (!this.selectedNetworksOnly) {
            joinKeyName = (String)this.columnList.getSelectedValue();
        }
        return targetTable.getColumn(joinKeyName);
    }

    private void copyRows(CyTable sourceTable, CyTable targetTable) {
        CyColumn targetKeyColumn = this.getJoinTargetColumn(targetTable);
        for (CyRow targetRow : targetTable.getAllRows()) {
            CyRow sourceRow;
            Object key = targetRow.get(targetKeyColumn.getName(), targetKeyColumn.getType());
            if (!sourceTable.rowExists(key) || (sourceRow = sourceTable.getRow(key)) == null) continue;
            for (CyColumn col : sourceTable.getColumns()) {
                if (col == sourceTable.getPrimaryKey() || !this.source2targetColumnMap.containsKey(col.getName())) continue;
                String targetColName = this.source2targetColumnMap.get(col.getName());
                if (col.getType() == List.class) {
                    targetRow.set(targetColName, (Object)sourceRow.getList(col.getName(), col.getListElementType()));
                    continue;
                }
                targetRow.set(targetColName, sourceRow.get(col.getName(), col.getType()));
            }
        }
    }

    private void copyColumns(CyTable sourceTable, CyTable targetTable) {
        for (CyColumn col : sourceTable.getColumns()) {
            if (col == sourceTable.getPrimaryKey()) continue;
            String targetColName = col.getName();
            if (targetTable.getColumn(targetColName) == null) {
                if (col.getType() == List.class) {
                    targetTable.createListColumn(targetColName, col.getListElementType(), col.isImmutable());
                } else {
                    targetTable.createColumn(targetColName, col.getType(), col.isImmutable(), col.getDefaultValue());
                }
            } else {
                CyColumn targetCol = targetTable.getColumn(targetColName);
                if (targetCol.getType() != col.getType() || col.getType() == List.class && targetCol.getListElementType() != col.getListElementType()) {
                    logger.error("Column '" + targetColName + "' has a different type in the target table -- skipping column");
                    continue;
                }
            }
            this.source2targetColumnMap.put(col.getName(), targetColName);
        }
    }

    private String getUniqueColumnName(CyTable table, String preferredName) {
        String newUniqueName;
        if (table.getColumn(preferredName) == null) {
            return preferredName;
        }
        int i = 0;
        while (table.getColumn(newUniqueName = preferredName + "-" + ++i) != null) {
        }
        return newUniqueName;
    }

    public boolean checkKeys() {
        Class joinTargetColumnType = String.class;
        if (!this.selectedNetworksOnly) {
            joinTargetColumnType = this.getJoinTargetColumn(this.getTable((CyNetwork)this.name2RootMap.get(this.rootNetworkList.getSelectedValue()), (TableType)((Object)this.dataTypeOptions.getSelectedValue()), "USER")).getType();
        }
        if (this.byReader) {
            for (CyTable readerTable : this.reader.getTables()) {
                if (readerTable.getPrimaryKey().getType() == joinTargetColumnType) continue;
                return false;
            }
        } else if (this.globalTable.getPrimaryKey().getType() != joinTargetColumnType) {
            return false;
        }
        return true;
    }

    static enum TableType {
        NODE_ATTR("Node Table Columns", CyNode.class),
        EDGE_ATTR("Edge Table Columns", CyEdge.class),
        NETWORK_ATTR("Network Table Columns", CyNetwork.class);

        private final String name;
        private final Class<? extends CyIdentifiable> type;

        private TableType(String name, Class<? extends CyIdentifiable> type) {
            this.name = name;
            this.type = type;
        }

        public Class<? extends CyIdentifiable> getType() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }
    }
}

