/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.ColumnListTunable;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.task.internal.utils.EdgeTunable;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class GetEdgeAttributeTask
extends AbstractTableDataTask
implements ObservableTask {
    private Map<CyIdentifiable, Map<String, Object>> edgeDataMap;
    @ContainsTunables
    public EdgeTunable edgeTunable;
    @ContainsTunables
    public ColumnListTunable columnTunable;
    private CyTable edgeTable;

    public GetEdgeAttributeTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.edgeTunable = new EdgeTunable(serviceRegistrar);
        this.columnTunable = new ColumnListTunable();
    }

    public void run(TaskMonitor tm) {
        CyNetwork network = this.edgeTunable.getNetwork();
        this.edgeTable = this.getNetworkTable(network, CyEdge.class, this.columnTunable.getNamespace());
        this.edgeDataMap = new HashMap<CyIdentifiable, Map<String, Object>>();
        for (CyEdge edge : this.edgeTunable.getEdgeList()) {
            Map<String, Object> edgeData = this.getCyIdentifierData(this.edgeTable, (CyIdentifiable)edge, this.columnTunable.getColumnNames(this.edgeTable));
            if (edgeData == null || edgeData.size() == 0) continue;
            this.edgeDataMap.put((CyIdentifiable)edge, edgeData);
            tm.showMessage(TaskMonitor.Level.INFO, "   Edge table values for edge " + DataUtils.getEdgeName(this.edgeTable, edge) + ":");
            for (String column : edgeData.keySet()) {
                if (edgeData.get(column) == null) continue;
                tm.showMessage(TaskMonitor.Level.INFO, "        " + column + "=" + DataUtils.convertData(edgeData.get(column)));
            }
        }
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(String.class)) {
            return DataUtils.convertMapToString(this.edgeDataMap);
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.edgeDataMap == null) {
                    return "[]";
                }
                StringBuilder output = new StringBuilder("[");
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                List<CyColumn> cyColumn = this.columnTunable.getColumnList(this.edgeTable);
                CyColumn[] cyColumnArray = cyColumn.size() > 0 ? cyColumn.toArray(new CyColumn[0]) : new CyColumn[]{};
                int count = this.edgeDataMap.size();
                for (CyIdentifiable edge : this.edgeDataMap.keySet()) {
                    CyRow row = this.edgeTable.getRow((Object)edge.getSUID());
                    output.append(" " + cyJSONUtil.toJson(row, cyColumnArray));
                    if (count > 1) {
                        output.append(",\n");
                    }
                    --count;
                }
                output.append("\n]");
                return output.toString();
            };
            return res;
        }
        return this.edgeDataMap;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(Map.class, String.class, JSONResult.class);
    }
}

