/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.work.undo.AbstractCyEdit;

final class DeleteTableEdit
extends AbstractCyEdit {
    private CyTable table;
    private final CyTableManager tableManager;
    private final CyTableFactory tableFactory;

    DeleteTableEdit(CyTable table, CyTableManager tableManager, CyTableFactory tableFactory) {
        super("Delete Table");
        this.table = tableFactory.createTable(table.getTitle(), table.getPrimaryKey().getName(), table.getPrimaryKey().getType(), false, true);
        this.table.swap(table);
        this.tableManager = tableManager;
        this.tableFactory = tableFactory;
    }

    public void redo() {
        CyTable newTable = this.tableFactory.createTable(this.table.getTitle(), this.table.getPrimaryKey().getName(), this.table.getPrimaryKey().getType(), false, true);
        this.table.swap(newTable);
        this.tableManager.deleteTable(this.table.getSUID().longValue());
        this.table = newTable;
    }

    public void undo() {
        CyTable newTable = this.tableFactory.createTable(this.table.getTitle(), this.table.getPrimaryKey().getName(), this.table.getPrimaryKey().getType(), false, true);
        this.table.swap(newTable);
        this.tableManager.addTable(this.table);
        this.table = newTable;
    }
}

