/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.TableTunable;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class DeleteColumnCommandTask
extends AbstractTableDataTask
implements ObservableTask {
    private CyTable table;
    @ContainsTunables
    public TableTunable tableTunable;
    @Tunable(description="Name of column to delete", longDescription="Specifies the name of a column in the table", exampleStringValue="Property", context="nogui")
    public String column = null;

    public DeleteColumnCommandTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.tableTunable = new TableTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        this.table = this.tableTunable.getTable();
        if (this.table == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to find table '" + this.tableTunable.getTableString() + "'");
            return;
        }
        if (this.column == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Column name must be specified");
            return;
        }
        CyColumn col = this.table.getColumn(this.column);
        if (col == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Can't find a '" + this.column + "' column in table: " + this.table.toString());
            return;
        }
        if (col.isPrimaryKey()) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Can't delete primary key column");
            return;
        }
        this.table.deleteColumn(this.column);
        tm.showMessage(TaskMonitor.Level.INFO, "Deleted column: " + this.column);
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(CyColumn.class, String.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(String.class)) {
            return this.column == null ? "" : this.column;
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.table == null || this.column == null) {
                    return "{}";
                }
                return "{\"table\":" + this.table.getSUID() + ",\"column\":\"" + this.column + "\"}";
            };
            return res;
        }
        return null;
    }
}

