/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.ColumnTunable;
import org.cytoscape.task.internal.utils.ColumnTypeTunable;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class CreateNetworkAttributeTask
extends AbstractTableDataTask
implements ObservableTask {
    @Tunable(description="Network", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current", context="nogui")
    public CyNetwork network;
    @ContainsTunables
    public ColumnTunable columnTunable = new ColumnTunable();
    @ContainsTunables
    public ColumnTypeTunable columnTypeTunable = new ColumnTypeTunable();

    public CreateNetworkAttributeTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        if (this.network == null) {
            this.network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
            if (this.network == null) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
                throw new RuntimeException("Network must be specified");
            }
        }
        CyTable networkTable = this.getNetworkTable(this.network, CyNetwork.class, this.columnTunable.getNamespace());
        try {
            this.createColumn(networkTable, this.columnTunable.getColumnName(), this.columnTypeTunable.getColumnType(), this.columnTypeTunable.getListElementType());
            this.success = true;
            if (this.columnTypeTunable.getColumnType() == "list") {
                tm.showMessage(TaskMonitor.Level.INFO, "Created new " + this.columnTypeTunable.getListElementType() + " list column: " + this.columnTunable.getColumnName());
            } else {
                tm.showMessage(TaskMonitor.Level.INFO, "Created new " + this.columnTypeTunable.getColumnType() + " column: " + this.columnTunable.getColumnName());
            }
        }
        catch (Exception e) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to create new column: " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public Object getResults(Class type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.success) {
                    return "{\"columnName\": \"" + this.columnTunable.getColumnName() + "\"}";
                }
                return "{}";
            };
            return res;
        }
        if (type.equals(String.class)) {
            if (this.columnTypeTunable.getColumnType() == "list") {
                return "Created new " + this.columnTypeTunable.getListElementType() + " list column: " + this.columnTunable.getColumnName();
            }
            return "Created new " + this.columnTypeTunable.getColumnType() + " column: " + this.columnTunable.getColumnName();
        }
        return null;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(JSONResult.class, String.class);
    }
}

