/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.task.internal.utils.TableTunable;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class AddRowTask
extends AbstractTableDataTask
implements ObservableTask {
    private CyRow row;
    @ContainsTunables
    public TableTunable tableTunable;
    @Tunable(description="Key value for new row", context="nogui", longDescription="Specifies the primary key of a value in the row of a table  Note that network, node, and edge tables ``must`` have Long values as keys", exampleStringValue="BRCA")
    public String keyValue;

    public AddRowTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.tableTunable = new TableTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        CyTable table = this.tableTunable.getTable();
        if (table == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to find table '" + this.tableTunable.getTableString() + "'");
            return;
        }
        if (this.keyValue == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Key of new row must be specified");
            return;
        }
        CyColumn primaryKColumn = table.getPrimaryKey();
        Class keyType = primaryKColumn.getType();
        Object key = null;
        try {
            key = DataUtils.convertString(this.keyValue, keyType);
        }
        catch (NumberFormatException nfe) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to convert " + this.keyValue + " to a " + keyType.getName() + ": " + nfe.getMessage());
            return;
        }
        if (key == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to convert " + this.keyValue + " to a " + keyType.getName());
            return;
        }
        if (table.rowExists(key)) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Row " + this.keyValue + " already exists");
            return;
        }
        this.row = table.getRow(key);
        tm.showMessage(TaskMonitor.Level.INFO, "Created new row '" + this.keyValue + "'");
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(CyRow.class, String.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(CyRow.class)) {
            return this.row;
        }
        if (requestedType.equals(String.class)) {
            return this.row == null ? null : this.row.toString();
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.row == null) {
                    return "{}";
                }
                return "{\"table\":" + this.tableTunable.getTable().getSUID() + ", \"row\":\"" + this.keyValue + "\"}";
            };
            return res;
        }
        return null;
    }
}

