/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.equations.Equation;
import org.cytoscape.equations.EquationCompiler;
import org.cytoscape.equations.EquationUtil;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.work.AbstractTask;

public abstract class AbstractTableDataTask
extends AbstractTask {
    protected boolean success;
    protected final CyServiceRegistrar serviceRegistrar;
    protected final EquationCompiler compiler;

    AbstractTableDataTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.compiler = (EquationCompiler)serviceRegistrar.getService(EquationCompiler.class);
    }

    public Map<String, Object> getCyIdentifierData(CyTable table, CyIdentifiable id, List<String> columnList) {
        if (id == null) {
            return null;
        }
        if (columnList == null) {
            columnList = new ArrayList<String>(CyTableUtil.getColumnNames((CyTable)table));
        }
        return this.getDataFromTable(table, id.getSUID(), columnList);
    }

    public CyTable getNetworkTable(CyNetwork network, Class<? extends CyIdentifiable> type, String namespace) {
        return network.getTable(type, this.getNamespace(namespace));
    }

    public int setCyIdentifierData(CyTable table, CyIdentifiable id, Map<CyColumn, Object> valueMap) {
        if (id == null || valueMap.size() == 0) {
            return 0;
        }
        HashMap<String, Class> variableNameToTypeMap = new HashMap<String, Class>();
        for (CyColumn column : table.getColumns()) {
            variableNameToTypeMap.put(column.getName(), column.getType());
        }
        int count = 0;
        CyRow row = table.getRow((Object)id.getSUID());
        for (CyColumn column : valueMap.keySet()) {
            Class type = column.getType();
            Class listElementType = column.getListElementType();
            String name = column.getName();
            Object value = valueMap.get(column);
            if (value == null) continue;
            if (value instanceof String && ((String)value).startsWith("=")) {
                Class expectedType = (Class)variableNameToTypeMap.remove(name);
                try {
                    Equation equation;
                    if (this.compiler.compile((String)value, variableNameToTypeMap)) {
                        Class eqnType = this.compiler.getEquation().getType();
                        if (EquationUtil.eqnTypeIsCompatible((Class)type, (Class)listElementType, (Class)eqnType)) {
                            equation = this.compiler.getEquation();
                        } else {
                            String errorMsg = "Equation result type is " + EquationUtil.getUnqualifiedName((Class)eqnType) + ", column type is " + EquationUtil.getUnqualifiedName((Class)type) + ".";
                            equation = this.compiler.getErrorEquation((String)value, expectedType, errorMsg);
                        }
                    } else {
                        equation = this.compiler.getErrorEquation((String)value, expectedType, this.compiler.getLastErrorMsg());
                    }
                    row.set(name, (Object)equation);
                    ++count;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e.getCause());
                }
                variableNameToTypeMap.put(name, expectedType);
                continue;
            }
            row.set(name, type.cast(value));
            ++count;
        }
        return count;
    }

    public void createColumn(CyTable table, String name, String typeName, String elementTypeName) {
        Class type = DataUtils.getType(typeName);
        Class elementType = DataUtils.getType(elementTypeName);
        if (name == null) {
            throw new IllegalArgumentException("Column name must be specified");
        }
        if ((name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("Column name must not be blank");
        }
        if (table.getColumn(name) != null) {
            throw new IllegalArgumentException("A column named '" + name + "' already exists");
        }
        if (type.equals(List.class)) {
            table.createListColumn(name, elementType, false);
        } else {
            table.createColumn(name, type, false);
        }
    }

    public CyTable getUnattachedTable(String tableName) {
        Set tables = ((CyTableManager)this.serviceRegistrar.getService(CyTableManager.class)).getAllTables(false);
        for (CyTable table : tables) {
            if (!tableName.equalsIgnoreCase(table.getTitle())) continue;
            return table;
        }
        return null;
    }

    public Map<String, Object> getDataFromTable(CyTable table, Object key, List<String> columnList) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (table.rowExists(key)) {
            CyRow row = table.getRow(key);
            for (String column : columnList) {
                result.put(column, row.getRaw(column));
            }
        }
        return result;
    }

    public String getNamespace(String namespace) {
        if (namespace == null || namespace.equalsIgnoreCase("USER") || namespace.equalsIgnoreCase("default")) {
            return "USER";
        }
        if (namespace.equalsIgnoreCase("hidden") || namespace.equalsIgnoreCase("HIDDEN")) {
            return "HIDDEN";
        }
        if (namespace.equalsIgnoreCase("local") || namespace.equalsIgnoreCase("LOCAL_ATTRS")) {
            return "LOCAL_ATTRS";
        }
        if (namespace.equalsIgnoreCase("shared") || namespace.equalsIgnoreCase("SHARED_ATTRS")) {
            return "SHARED_ATTRS";
        }
        return namespace;
    }
}

