/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.session;

import java.io.File;
import java.util.HashMap;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.io.read.CySessionReaderManager;
import org.cytoscape.io.util.RecentlyOpenedTracker;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CySession;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.session.events.SessionAboutToBeLoadedEvent;
import org.cytoscape.task.internal.session.AbstractOpenSessionTask;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableSetter;

public class OpenSessionTask
extends AbstractOpenSessionTask {
    private final File sessionFile;

    @ProvidesTitle
    public String getTitle() {
        return "Open Session";
    }

    public OpenSessionTask(CyServiceRegistrar serviceRegistrar) {
        this(null, serviceRegistrar);
    }

    public OpenSessionTask(File sessionFile, CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.sessionFile = sessionFile;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        CyNetworkManager netManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        CyTableManager tableManager = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class);
        if (netManager.getNetworkSet().isEmpty() && tableManager.getAllTables(false).isEmpty()) {
            this.loadSession(this);
        } else {
            this.insertTasksAfterCurrentTask(new Task[]{new OpenSessionWithWarningTask()});
        }
    }

    private void loadSession(AbstractTask currentTask) {
        if (this.sessionFile == null) {
            this.getTaskIterator().insertTasksAfter((Task)currentTask, new Task[]{new OpenSessionWithoutWarningTask()});
        } else {
            HashMap<String, File> m = new HashMap<String, File>();
            m.put("file", this.sessionFile);
            TunableSetter tunableSetter = (TunableSetter)this.serviceRegistrar.getService(TunableSetter.class);
            this.getTaskIterator().insertTasksAfter((Task)currentTask, tunableSetter.createTaskIterator(new TaskIterator(new Task[]{new OpenSessionWithoutWarningTask()}), m));
        }
    }

    public final class OpenSessionWithWarningTask
    extends AbstractTask {
        @Tunable(description="<html>Current session (all networks and tables) will be lost.<br />Do you want to continue?</html>", params="ForceSetDirectly=true;ForceSetTitle=Open Session", context="gui")
        public boolean loadSession;

        public void run(TaskMonitor taskMonitor) throws Exception {
            if (this.loadSession) {
                OpenSessionTask.this.loadSession(this);
            }
        }
    }

    public final class OpenSessionWithoutWarningTask
    extends AbstractTask {
        @Tunable(description="Session file to load:", params="fileCategory=session;input=true", context="gui")
        public File file;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(TaskMonitor tm) throws Exception {
            CyEventHelper eventHelper = (CyEventHelper)OpenSessionTask.this.serviceRegistrar.getService(CyEventHelper.class);
            CySessionManager sessionManager = (CySessionManager)OpenSessionTask.this.serviceRegistrar.getService(CySessionManager.class);
            try {
                try {
                    tm.setStatusMessage("Opening Session File.\n\nIt may take a while.\nPlease wait...");
                    tm.setProgress(0.0);
                    if (this.file == null) {
                        throw new NullPointerException("No file specified.");
                    }
                    OpenSessionTask.this.reader = ((CySessionReaderManager)OpenSessionTask.this.serviceRegistrar.getService(CySessionReaderManager.class)).getReader(this.file.toURI(), this.file.getName());
                    if (OpenSessionTask.this.reader == null) {
                        throw new NullPointerException("Failed to find appropriate reader for file: " + this.file);
                    }
                    eventHelper.fireEvent((CyEvent)new SessionAboutToBeLoadedEvent((Object)this));
                    tm.setProgress(0.1);
                    sessionManager.disposeCurrentSession();
                    tm.setProgress(0.2);
                    if (!this.cancelled) {
                        OpenSessionTask.this.reader.run(tm);
                    }
                    tm.setProgress(0.8);
                }
                catch (Exception e) {
                    OpenSessionTask.this.disposeCancelledSession(e, sessionManager);
                    throw e;
                }
                if (this.cancelled) {
                    OpenSessionTask.this.disposeCancelledSession(null, sessionManager);
                } else {
                    this.changeCurrentSession(sessionManager, tm);
                }
            }
            finally {
                OpenSessionTask.this.reader = null;
            }
        }

        private void changeCurrentSession(CySessionManager sessionManager, TaskMonitor tm) throws Exception {
            CySession newSession = OpenSessionTask.this.reader.getSession();
            if (newSession == null) {
                throw new NullPointerException("Session could not be read for file: " + this.file);
            }
            sessionManager.setCurrentSession(newSession, this.file.getAbsolutePath());
            tm.setProgress(1.0);
            tm.setStatusMessage("Session file " + this.file + " successfully loaded.");
            ((RecentlyOpenedTracker)OpenSessionTask.this.serviceRegistrar.getService(RecentlyOpenedTracker.class)).add(this.file.toURI().toURL());
        }
    }
}

