/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.session;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.write.CySessionWriterManager;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CySession;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CySessionWriter
extends AbstractTask
implements CyWriter {
    private final CySession session;
    private CyWriter writer;
    private File outputFile;
    private File tmpFile;
    private final CyServiceRegistrar serviceRegistrar;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public CySessionWriter(CySession session, File outputFile, CyServiceRegistrar serviceRegistrar) {
        if (session == null) {
            throw new NullPointerException("Session Manager is null");
        }
        if (outputFile == null) {
            throw new NullPointerException("Output File is null");
        }
        this.session = session;
        this.outputFile = outputFile;
        this.serviceRegistrar = serviceRegistrar;
    }

    public final void run(TaskMonitor tm) throws Exception {
        Object filepath;
        File dir;
        CySessionWriterManager writerMgr = (CySessionWriterManager)this.serviceRegistrar.getService(CySessionWriterManager.class);
        List filters = writerMgr.getAvailableWriterFilters();
        if (filters == null || filters.size() < 1) {
            throw new NullPointerException("No Session file filters found");
        }
        if (filters.size() > 1) {
            throw new IllegalArgumentException("Found too many session filters.");
        }
        File file = dir = this.outputFile.isDirectory() ? this.outputFile : this.outputFile.getParentFile();
        if (dir == null) {
            this.outputFile = new File(System.getProperty("user.home") + System.getProperty("file.separator") + this.outputFile.toString());
        }
        if (!((String)(filepath = this.outputFile.getAbsolutePath())).toLowerCase().endsWith(".cys")) {
            filepath = (String)filepath + ".cys";
            this.outputFile = new File((String)filepath);
        }
        if (!this.canWrite(this.outputFile)) {
            throw new IOException("Session not saved. Cytoscape does not have write permission to save the session at \"" + this.outputFile.getParentFile().getAbsolutePath() + "\". Choose another folder or change the folder permissions.");
        }
        this.createTempFile();
        try {
            this.writer = writerMgr.getWriter(this.session, (CyFileFilter)filters.get(0), this.tmpFile);
            if (this.writer == null) {
                throw new NullPointerException("No CyWriter found for specified file type.");
            }
            this.writer.run(tm);
        }
        catch (Exception e) {
            this.deleteFile(this.tmpFile);
            throw e;
        }
        if (this.cancelled) {
            this.deleteFile(this.tmpFile);
            return;
        }
        this.replaceOutputFile();
    }

    public void cancel() {
        super.cancel();
        if (this.writer != null) {
            this.writer.cancel();
        }
    }

    private void createTempFile() {
        String osName = System.getProperty("os.name");
        boolean windows = osName.startsWith("Windows");
        String tmpFilename = this.outputFile.getParent() + System.getProperty("file.separator") + (windows ? "" : ".") + this.outputFile.getName() + ".tmp";
        this.tmpFile = new File(tmpFilename);
        int count = 0;
        while (this.tmpFile.exists() && count < 100) {
            try {
                this.tmpFile.delete();
            }
            catch (Exception e) {
                logger.warn("Cannot delete old temporary session file: " + this.tmpFile.getAbsolutePath(), (Throwable)e);
                this.tmpFile = new File(tmpFilename + ++count);
            }
        }
        try {
            this.tmpFile.deleteOnExit();
        }
        catch (Exception e) {
            logger.warn("Error requesting delete on exit for file: " + this.tmpFile.getAbsolutePath(), (Throwable)e);
        }
    }

    static boolean HasFileExtension(String pathName) {
        int lastDotPos = pathName.lastIndexOf(46);
        int lastSlashPos = pathName.lastIndexOf(File.separatorChar);
        return lastSlashPos < lastDotPos;
    }

    private void replaceOutputFile() {
        boolean success;
        File backup = null;
        if (this.outputFile.exists()) {
            backup = this.createBackupFile();
        }
        if (!(success = this.tmpFile.renameTo(this.outputFile))) {
            throw new RuntimeException("Cannot move the temporary file of the saved session to " + this.outputFile.getAbsolutePath() + ". The current session was saved at: " + this.tmpFile.getAbsolutePath());
        }
        this.deleteFile(backup);
    }

    private File createBackupFile() {
        File backup = new File(this.outputFile.getAbsolutePath() + ".bkp");
        int count = 0;
        while (backup.exists() && count < 100) {
            try {
                backup.delete();
            }
            catch (Exception e) {
                logger.warn("Cannot delete old session backup file: " + backup, (Throwable)e);
                backup = new File(this.outputFile.getAbsolutePath() + ".bkp" + ++count);
            }
        }
        if (!this.outputFile.renameTo(backup)) {
            throw new RuntimeException("Cannot create a backup of the original session file. The current session was saved at: " + this.tmpFile.getAbsolutePath());
        }
        this.deleteFile(this.outputFile);
        return backup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canWrite(File file) {
        File dir;
        File file2 = dir = file.isDirectory() ? file : file.getParentFile();
        if (!dir.canWrite()) {
            return false;
        }
        File dummy = new File(dir, "empty_" + System.currentTimeMillis() + ".tmp");
        try {
            dummy.createNewFile();
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (dummy != null) {
                    dummy.delete();
                }
            }
            catch (Exception e) {
                logger.warn("Cannot delete dummy file used to test write permission: " + dummy, (Throwable)e);
            }
        }
        return true;
    }

    private void deleteFile(File file) {
        if (file != null && file.exists()) {
            try {
                file.delete();
            }
            catch (Exception e) {
                logger.warn("Cannot delete file: " + file.getAbsolutePath(), (Throwable)e);
            }
        }
    }
}

