/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.select;

import org.cytoscape.command.util.EdgeList;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.select.AbstractSelectTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class DeselectEdgesTask
extends AbstractSelectTask {
    @Tunable(description="Network to deselect edges in", gravity=1.0, context="nogui")
    public CyNetwork network;
    public EdgeList edgeList = new EdgeList(null);

    @Tunable(description="Edges to deselect", gravity=2.0, context="nogui")
    public EdgeList getedgeList() {
        ((AbstractSelectTask)this).network = this.network;
        this.edgeList.setNetwork(this.network);
        return this.edgeList;
    }

    public void setedgeList(EdgeList setValue) {
    }

    public DeselectEdgesTask(CyServiceRegistrar serviceRegistrar) {
        super(null, serviceRegistrar);
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Deselect Edges");
        tm.setProgress(0.0);
        if (this.network == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
            return;
        }
        tm.showMessage(TaskMonitor.Level.INFO, "Deselecting " + this.edgeList.getValue().size() + " edges");
        this.selectUtils.setSelectedEdges(this.network, this.edgeList.getValue(), true);
        tm.setProgress(0.6);
        this.updateView();
        tm.setProgress(1.0);
    }
}

