/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.select;

import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.select.AbstractSelectTask;
import org.cytoscape.task.internal.select.SelectionEdit;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class DeselectAllTask
extends AbstractSelectTask {
    public DeselectAllTask(CyNetwork net, CyServiceRegistrar serviceRegistrar) {
        super(net, serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Deselect All");
        tm.setProgress(0.0);
        if (this.network == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
            return;
        }
        CyNetworkView view = this.getNetworkView(this.network);
        ((UndoSupport)this.serviceRegistrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)new SelectionEdit("Deselect All", this.network, view, SelectionEdit.SelectionFilter.NODES_AND_EDGES, this.serviceRegistrar));
        tm.setStatusMessage("Deselecting all edges...");
        tm.setProgress(0.2);
        this.selectUtils.setSelectedEdges(this.network, CyTableUtil.getEdgesInState((CyNetwork)this.network, (String)"selected", (boolean)true), false);
        tm.setStatusMessage("Deselecting all nodes...");
        tm.setProgress(0.5);
        this.selectUtils.setSelectedNodes(this.network, CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true), false);
        tm.setStatusMessage("Deselecting all annotations...");
        tm.setProgress(0.7);
        List annotations = ((AnnotationManager)this.serviceRegistrar.getService(AnnotationManager.class)).getSelectedAnnotations(view);
        this.selectUtils.setSelectedAnnotations(annotations, false);
        tm.setStatusMessage("Updating view...");
        tm.setProgress(0.9);
        this.updateView();
        tm.setProgress(1.0);
    }
}

