/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.select;

import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.select.AbstractSelectTask;
import org.cytoscape.task.internal.select.SelectionEdit;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class DeselectAllEdgesTask
extends AbstractSelectTask {
    public DeselectAllEdgesTask(CyNetwork net, CyServiceRegistrar serviceRegistrar) {
        super(net, serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Deselect All Edges");
        tm.setProgress(0.0);
        if (this.network == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
            return;
        }
        CyNetworkView view = this.getNetworkView(this.network);
        ((UndoSupport)this.serviceRegistrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)new SelectionEdit("Deselect All Edges", this.network, view, SelectionEdit.SelectionFilter.EDGES_ONLY, this.serviceRegistrar));
        tm.setStatusMessage("Deselecting Edges...");
        tm.setProgress(0.2);
        this.selectUtils.setSelectedEdges(this.network, this.network.getEdgeList(), false);
        tm.setStatusMessage("Updating View...");
        tm.setProgress(0.6);
        this.updateView();
        tm.setProgress(1.0);
    }
}

