/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.proxysettings;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.bind.DatatypeConverter;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.property.CyProperty;
import org.cytoscape.property.PropertyUpdatedEvent;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.proxysettings.TestProxySettings;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.util.ListSingleSelection;

public class ProxySettingsTask2
extends AbstractTask
implements TunableValidator {
    static final String PROXY_HOST = "proxy.server";
    static final String PROXY_PORT = "proxy.server.port";
    static final String PROXY_TYPE = "proxy.server.type";
    static final String PROXY_USERNAME = "proxy.server.userName";
    static final String PROXY_PASSWORD = "proxy.server.password";
    private static final List<String> KEYS = Arrays.asList("proxy.server", "proxy.server.port", "proxy.server.type", "proxy.server.userName", "proxy.server.password");
    private static final List<String> PROXY_TYPES = Arrays.asList("direct", "http", "socks");
    @Tunable(description="Type:")
    public ListSingleSelection<String> type = new ListSingleSelection(PROXY_TYPES);
    @Tunable(description="Proxy Server:", groups={"Options"}, dependsOn="type!=direct")
    public String hostname = "";
    @Tunable(description="Port:", groups={"Options"}, dependsOn="type!=direct")
    public int port;
    @Tunable(description="User Name:", groups={"Options"}, dependsOn="type!=direct")
    public String userName;
    @Tunable(description="Password:", groups={"Options"}, dependsOn="type!=direct")
    public String password;
    private final Map<String, String> oldSettings;
    private final CyServiceRegistrar serviceRegistrar;

    @ProvidesTitle
    public String getTitle() {
        return "Proxy Settings";
    }

    public ProxySettingsTask2(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.oldSettings = new HashMap<String, String>();
        try {
            CyProperty<Properties> proxyProps = this.getProxyProperties();
            Properties props = (Properties)proxyProps.getProperties();
            String proxyType = props.getProperty(PROXY_TYPE);
            if (PROXY_TYPES.contains(proxyType)) {
                this.type.setSelectedValue((Object)proxyType);
            } else {
                this.type.setSelectedValue((Object)"direct");
            }
            this.hostname = props.getProperty(PROXY_HOST);
            this.port = Integer.parseInt(props.getProperty(PROXY_PORT));
            this.userName = props.getProperty(PROXY_USERNAME);
            try {
                this.password = ProxySettingsTask2.decode(props.getProperty(PROXY_PASSWORD, null));
            }
            catch (IOException e) {
                this.password = null;
            }
        }
        catch (IllegalArgumentException e) {
            this.type.setSelectedValue((Object)"direct");
            this.hostname = "";
            this.port = 0;
        }
        this.assignSystemProperties();
    }

    public void assignSystemProperties() {
        if ("direct".equals(this.type.getSelectedValue())) {
            System.setProperty("http.proxyHost", "");
            System.setProperty("http.proxyPort", "");
            System.setProperty("socksProxyHost", "");
            System.setProperty("socksProxyPort", "");
        } else if ("http".equals(this.type.getSelectedValue())) {
            System.setProperty("http.proxyHost", this.hostname);
            System.setProperty("http.proxyPort", Integer.toString(this.port));
            System.setProperty("socksProxyHost", "");
            System.setProperty("socksProxyPort", "");
        } else if ("socks".equals(this.type.getSelectedValue())) {
            System.setProperty("http.proxyHost", "");
            System.setProperty("http.proxyPort", "");
            System.setProperty("socksProxyHost", this.hostname);
            System.setProperty("socksProxyPort", Integer.toString(this.port));
        }
    }

    private static String encode(String text) throws IOException {
        if (text == null) {
            return null;
        }
        return DatatypeConverter.printBase64Binary((byte[])text.getBytes("UTF-8"));
    }

    private static String decode(String text) throws IOException {
        if (text == null) {
            return null;
        }
        return new String(DatatypeConverter.parseBase64Binary((String)text), "UTF-8");
    }

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        CyProperty<Properties> proxyProps = this.getProxyProperties();
        Properties props = (Properties)proxyProps.getProperties();
        this.storeProxySettings(props);
        StreamUtil streamUtil = (StreamUtil)this.serviceRegistrar.getService(StreamUtil.class);
        FutureTask<Exception> task = new FutureTask<Exception>(new TestProxySettings(streamUtil));
        Exception result = null;
        try {
            new Thread(task).start();
            result = task.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            result = e;
        }
        catch (ExecutionException e) {
            result = e;
        }
        catch (TimeoutException e) {
            result = e;
        }
        this.revertProxySettings(props);
        if (result == null) {
            return TunableValidator.ValidationState.OK;
        }
        try {
            errMsg.append("Cytoscape was unable to connect to the internet because these proxy settings are not correct:\n\n" + result.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return TunableValidator.ValidationState.INVALID;
    }

    public void run(TaskMonitor tm) {
        tm.setProgress(0.0);
        CyProperty<Properties> proxyProps = this.getProxyProperties();
        Properties props = (Properties)proxyProps.getProperties();
        this.storeProxySettings(props);
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        for (String key : this.oldSettings.keySet()) {
            if (this.oldSettings.get(key).equals(props.get(key))) continue;
            eventHelper.fireEvent((CyEvent)new PropertyUpdatedEvent(proxyProps));
            break;
        }
        this.oldSettings.clear();
        tm.setProgress(1.0);
    }

    private void storeProxySettings(Properties props) {
        this.oldSettings.clear();
        for (String key : KEYS) {
            if (props.getProperty(key) != null) {
                this.oldSettings.put(key, props.getProperty(key));
            }
            props.remove(key);
        }
        String proxyType = (String)this.type.getSelectedValue();
        if ("direct".equals(proxyType)) {
            props.setProperty(PROXY_TYPE, proxyType);
        } else if ("http".equals(proxyType) || "socks".equals(proxyType)) {
            props.setProperty(PROXY_TYPE, proxyType);
            props.setProperty(PROXY_HOST, this.hostname);
            props.setProperty(PROXY_PORT, Integer.toString(this.port));
            if (this.userName != null && !this.userName.isEmpty() && this.password != null && !this.password.isEmpty()) {
                props.setProperty(PROXY_USERNAME, this.userName);
                try {
                    props.setProperty(PROXY_PASSWORD, ProxySettingsTask2.encode(this.password));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        this.assignSystemProperties();
    }

    private void revertProxySettings(Properties props) {
        for (String key : KEYS) {
            props.remove(key);
            if (!this.oldSettings.containsKey(key)) continue;
            props.setProperty(key, this.oldSettings.get(key));
        }
        this.oldSettings.clear();
        this.assignSystemProperties();
    }

    private CyProperty<Properties> getProxyProperties() {
        return (CyProperty)this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
    }
}

