/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.task.internal.networkobjects.AbstractGetTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class RenameEdgeTask
extends AbstractGetTask
implements ObservableTask {
    @Tunable(description="Network edge is in", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork network;
    @Tunable(description="Edge to be renamed", context="nogui", longDescription="Selects an edge by name, or, if the parameter has the prefix ```suid:```, selects an edge by SUID.", exampleStringValue="SUID:101")
    public String edge;
    @Tunable(description="New edge name", context="nogui", longDescription="New name of the edge", exampleStringValue="New Name")
    public String newName;

    public void run(TaskMonitor tm) {
        if (this.network == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
            return;
        }
        if (this.edge == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Edge name or suid must be specified");
            return;
        }
        if (this.newName == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "New name must be specified");
            return;
        }
        CyEdge renamedEdge = this.getEdge(this.network, this.edge);
        this.network.getRow((CyIdentifiable)renamedEdge).set("name", (Object)this.newName);
        tm.showMessage(TaskMonitor.Level.INFO, "Edge " + renamedEdge + " renamed to " + this.newName);
    }

    public Object getResults(Class type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> "{}";
            return res;
        }
        return null;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(JSONResult.class);
    }
}

