/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.networkobjects.AbstractGetTask;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class GetNodeTask
extends AbstractGetTask
implements ObservableTask {
    @Tunable(description="Network to get node from", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork network;
    @Tunable(description="Node to get", context="nogui", longDescription="Selects a node by name, or, if the parameter has the prefix ```suid:```, selects a node by SUID.", exampleStringValue="Node 1")
    public String node;
    private CyNode returnedNode;
    private final CyServiceRegistrar serviceRegistrar;

    protected GetNodeTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        if (this.network == null) {
            this.network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
            if (this.network == null) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
                throw new RuntimeException("Network must be specified");
            }
        }
        if (this.node == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Node name or suid must be specified");
            throw new RuntimeException("Node name or suid must be specified");
        }
        this.returnedNode = this.getNode(this.network, this.node);
    }

    public Object getResults(Class type) {
        if (type.equals(CyNode.class)) {
            return this.returnedNode;
        }
        if (type.equals(String.class)) {
            if (this.returnedNode == null) {
                return "<none>";
            }
            return this.returnedNode.toString();
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.returnedNode == null) {
                    return "{}";
                }
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                return "{\"node\":" + cyJSONUtil.toJson((CyIdentifiable)this.returnedNode) + "}";
            };
            return res;
        }
        return this.returnedNode;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(CyNode.class, String.class, JSONResult.class);
    }
}

