/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.networkobjects.AbstractGetTask;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.util.ListSingleSelection;

public class GetEdgeTask
extends AbstractGetTask
implements ObservableTask {
    @Tunable(description="Network to get edge from", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork network;
    @Tunable(description="Edge to match", context="nogui", longDescription="Selects an edge by name, or, if the parameter has the prefix ```suid:```, selects an edge by SUID. If this parameter is set, all other edge matching parameters are ignored.", exampleStringValue="Node 1 (interacts with) Node 2")
    public String edge;
    @Tunable(description="Name of source node to match", context="nogui", longDescription="Selects a node by name, or, if the parameter has the prefix ```suid:```, selects a node by SUID. Specifies that the edge matched must have this node as its source. This parameter must be used with the ```targetNode``` parameter to produce results.", exampleStringValue="Node 1")
    public String sourceNode;
    @Tunable(description="Name of target node to match", context="nogui", longDescription="Selects a node by name, or, if the parameter has the prefix ```suid:```, selects a node by SUID. Specifies that the edge matched must have this node as its target. This parameter must be used with the ```sourceNode``` parameter to produce results.", exampleStringValue="Node 2")
    public String targetNode;
    @Tunable(description="Edge type to match", context="nogui", longDescription="Specifies that the edge matched must be of the specified type. This parameter must be used with the ```sourceNode``` and ```targetNode``` parameters to produce results.", exampleStringValue="any")
    public ListSingleSelection type = new ListSingleSelection(new Object[]{"any", "directed", "undirected"});
    private CyEdge returnedEdge;
    private final CyServiceRegistrar serviceRegistrar;

    protected GetEdgeTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        if (this.network == null) {
            this.network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
            if (this.network == null) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
                throw new RuntimeException("Network must be specified");
            }
        }
        if (this.edge == null && (this.sourceNode == null || this.targetNode == null)) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Edge name, suid or source/target must be specified");
            throw new RuntimeException("Edge name, suid or source/target must be specified");
        }
        if (this.edge != null) {
            this.returnedEdge = this.getEdge(this.network, this.edge);
            return;
        }
        CyNode source = this.getNode(this.network, this.sourceNode);
        if (source == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Cannot find node '" + this.sourceNode + "'");
            throw new RuntimeException("Cannot find node '" + this.sourceNode + "'");
        }
        CyNode target = this.getNode(this.network, this.targetNode);
        if (target == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Cannot find node '" + this.targetNode + "'");
            throw new RuntimeException("Cannot find node '" + this.targetNode + "'");
        }
        CyEdge.Type edgeType = CyEdge.Type.ANY;
        if (this.type.getSelectedValue().equals("directed")) {
            edgeType = CyEdge.Type.DIRECTED;
        } else if (this.type.getSelectedValue().equals("undirected")) {
            edgeType = CyEdge.Type.UNDIRECTED;
        }
        List edges = this.network.getConnectingEdgeList(source, target, edgeType);
        if (edges.size() > 1) {
            this.returnedEdge = (CyEdge)edges.get(0);
            tm.showMessage(TaskMonitor.Level.WARN, "Specification yields multiple edges -- only one returned");
        } else if (edges.size() == 1) {
            this.returnedEdge = (CyEdge)edges.get(0);
        } else {
            tm.showMessage(TaskMonitor.Level.WARN, "No edge matching specification found");
        }
    }

    public Object getResults(Class type) {
        if (type.equals(CyEdge.class)) {
            return this.returnedEdge;
        }
        if (type.equals(String.class)) {
            if (this.returnedEdge == null) {
                return "<none>";
            }
            return this.returnedEdge.toString();
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.returnedEdge == null) {
                    return "{}";
                }
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                return "{\"edge\":" + cyJSONUtil.toJson((CyIdentifiable)this.returnedEdge) + "}";
            };
            return res;
        }
        return this.returnedEdge;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(CyEdge.class, String.class, JSONResult.class);
    }
}

