/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.work.AbstractTask;

public abstract class AbstractGetTask
extends AbstractTask {
    protected CyNode getNode(CyNetwork network, String nodeSpec) {
        Long nodeSuid = this.parseSpec(network.getDefaultNodeTable(), nodeSpec);
        if (nodeSuid == null) {
            return null;
        }
        return network.getNode(nodeSuid.longValue());
    }

    protected CyEdge getEdge(CyNetwork network, String edgeSpec) {
        Long edgeSuid = this.parseSpec(network.getDefaultEdgeTable(), edgeSpec);
        if (edgeSuid == null) {
            return null;
        }
        return network.getEdge(edgeSuid.longValue());
    }

    private Long parseSpec(CyTable table, String spec) {
        String[] splitString = spec.split(":");
        if (splitString.length > 1) {
            if (splitString[0].equalsIgnoreCase("suid")) {
                return this.getSuid(splitString[1]);
            }
            if (splitString[0].equalsIgnoreCase("name")) {
                spec = splitString[1];
            }
        }
        for (CyRow row : table.getAllRows()) {
            if (!((String)row.get("name", String.class)).equals(spec)) continue;
            return (Long)row.get("SUID", Long.class);
        }
        return null;
    }

    private Long getSuid(String suidString) {
        try {
            Long suid = Long.valueOf(suidString);
            return suid;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

