/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.network;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cytoscape.command.util.EdgeList;
import org.cytoscape.command.util.NodeList;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.network.AbstractNetworkFromSelectionTask;
import org.cytoscape.work.Tunable;

public class NewNetworkCommandTask
extends AbstractNetworkFromSelectionTask {
    private Set<CyNode> nodes;
    private Set<CyEdge> edges;
    @Tunable(description="Name of new network", gravity=1.0, context="nogui")
    public String networkName;
    public NodeList nodeList = new NodeList(null);
    public EdgeList edgeList = new EdgeList(null);
    @Tunable(description="Exclude connecting edges", longDescription="Unless this is set to true, edges that connect nodes in the nodeList are implicitly included", gravity=5.0, context="nogui", exampleStringValue="false")
    public boolean excludeEdges;

    @Tunable(description="Source network", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current", gravity=2.0, context="nogui")
    public CyNetwork getsource() {
        return this.parentNetwork;
    }

    public void setsource(CyNetwork network) {
        this.parentNetwork = network;
    }

    @Tunable(description="List of nodes for new network", longDescription="Specifies a list of nodes. The keywords ```all```, ```selected```, or ```unselected``` can be used to specify nodes by their selection state. The pattern ```COLUMN:VALUE``` sets this parameter to any rows that contain the specified column value; if the ```COLUMN``` prefix is not used, the NAME column is matched by default. A list of ```COLUMN:VALUE``` pairs of the format ```COLUMN1:VALUE1,COLUMN2:VALUE2,...``` can be used to match multiple values.", exampleStringValue="selected", gravity=3.0, context="nogui")
    public NodeList getnodeList() {
        this.nodeList.setNetwork(this.parentNetwork);
        return this.nodeList;
    }

    public void setnodeList(NodeList setValue) {
    }

    @Tunable(description="List of edges for new network", longDescription="Specifies a list of edges. The keywords ```all```, ```selected```, or ```unselected``` can be used to specify edges by their selection state. The pattern ```COLUMN:VALUE``` sets this parameter to any rows that contain the specified column value; if the ```COLUMN``` prefix is not used, the NAME column is matched by default. A list of ```COLUMN:VALUE``` pairs of the format ```COLUMN1:VALUE1,COLUMN2:VALUE2,...``` can be used to match multiple values.", exampleStringValue="selected", gravity=4.0, context="nogui")
    public EdgeList getedgeList() {
        this.edgeList.setNetwork(this.parentNetwork);
        return this.edgeList;
    }

    public void setedgeList(EdgeList setValue) {
    }

    public NewNetworkCommandTask(CyServiceRegistrar serviceRegistrar) {
        super(null, serviceRegistrar);
    }

    @Override
    Set<CyNode> getNodes(CyNetwork net) {
        if (this.nodes == null) {
            this.nodes = new HashSet<CyNode>(this.nodeList.getValue());
            if (this.edgeList != null && this.edgeList.getValue() != null) {
                List selectedEdges = this.edgeList.getValue();
                for (CyEdge e : selectedEdges) {
                    this.nodes.add(e.getSource());
                    this.nodes.add(e.getTarget());
                }
            }
        }
        return this.nodes;
    }

    @Override
    Set<CyEdge> getEdges(CyNetwork net) {
        if (this.edges == null) {
            this.edges = this.edgeList != null && this.edgeList.getValue() != null ? new HashSet<CyEdge>(this.edgeList.getValue()) : new HashSet<CyEdge>();
        }
        if (!this.excludeEdges) {
            List nList = this.nodeList.getValue();
            for (CyNode n1 : nList) {
                for (CyNode n2 : nList) {
                    this.edges.addAll(net.getConnectingEdgeList(n1, n2, CyEdge.Type.ANY));
                }
            }
        }
        return this.edges;
    }

    @Override
    String getNetworkName() {
        if (this.networkName != null) {
            return this.networkName;
        }
        return super.getNetworkName();
    }
}

