/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.network;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.create.NewEmptyNetworkViewFactory;
import org.cytoscape.task.internal.network.NewEmptyNetworkTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class NewEmptyNetworkTaskFactoryImpl
extends AbstractTaskFactory
implements NewEmptyNetworkViewFactory {
    private final Set<NetworkViewRenderer> viewRenderers;
    private final CyServiceRegistrar serviceRegistrar;

    public NewEmptyNetworkTaskFactoryImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.viewRenderers = new TreeSet<NetworkViewRenderer>(new Comparator<NetworkViewRenderer>(){

            @Override
            public int compare(NetworkViewRenderer r1, NetworkViewRenderer r2) {
                return r1.toString().compareToIgnoreCase(r2.toString());
            }
        });
    }

    public TaskIterator createTaskIterator() {
        return new TaskIterator(new Task[]{this.createTask()});
    }

    public CyNetworkView createNewEmptyNetworkView() {
        NewEmptyNetworkTask task = this.createTask();
        ((SynchronousTaskManager)this.serviceRegistrar.getService(SynchronousTaskManager.class)).execute(new TaskIterator(new Task[]{task}));
        return task.getView();
    }

    public void addNetworkViewRenderer(NetworkViewRenderer renderer, Map<?, ?> props) {
        this.viewRenderers.add(renderer);
    }

    public void removeNetworkViewRenderer(NetworkViewRenderer renderer, Map<?, ?> props) {
        this.viewRenderers.remove(renderer);
    }

    private NewEmptyNetworkTask createTask() {
        if (this.viewRenderers.isEmpty()) {
            throw new RuntimeException("Unable to create Network View: There is no NetworkViewRenderer.");
        }
        return new NewEmptyNetworkTask(this.viewRenderers, this.serviceRegistrar);
    }
}

