/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.layout;

import java.util.ArrayList;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.util.ListSingleSelection;

public class SetPreferredLayoutTask
extends AbstractTask {
    @Tunable(description="Layout to use as preferred", context="nogui", longDescription="Layout to use as preferred, for allowed names see Layout API", exampleStringValue="grid")
    public ListSingleSelection<String> preferredLayout;
    private final CyServiceRegistrar serviceRegistrar;

    public SetPreferredLayoutTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        ArrayList<String> layoutNames = new ArrayList<String>();
        CyLayoutAlgorithmManager layoutManager = (CyLayoutAlgorithmManager)serviceRegistrar.getService(CyLayoutAlgorithmManager.class);
        for (CyLayoutAlgorithm alg : layoutManager.getAllLayouts()) {
            if (alg.getName().startsWith("yfiles.")) continue;
            layoutNames.add(alg.getName());
        }
        this.preferredLayout = new ListSingleSelection(layoutNames);
    }

    public void run(TaskMonitor tm) {
        String prefName;
        CyLayoutAlgorithmManager layoutManager = (CyLayoutAlgorithmManager)this.serviceRegistrar.getService(CyLayoutAlgorithmManager.class);
        CyLayoutAlgorithm prefLayout = layoutManager.getLayout(prefName = (String)this.preferredLayout.getSelectedValue());
        if (prefLayout != null) {
            layoutManager.setDefaultLayout(prefLayout);
            tm.showMessage(TaskMonitor.Level.INFO, "Preferred layout set to " + prefName);
        } else {
            tm.showMessage(TaskMonitor.Level.WARN, "Can't set preferred layout -- invalid layout name");
        }
    }

    public Object getResults(Class type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> "{}";
            return res;
        }
        if (this.preferredLayout == null) {
            return null;
        }
        return this.preferredLayout;
    }
}

