/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.layout;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class GetPreferredLayoutTask
extends AbstractTask
implements ObservableTask {
    private CyLayoutAlgorithm preferredLayout;
    private final CyServiceRegistrar serviceRegistrar;
    @Tunable(description="Gets the name of the current preferred layout", context="nogui", longDescription="Gets the name of the current preferred layout")
    public CyNetwork network = null;

    public GetPreferredLayoutTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        this.preferredLayout = ((CyLayoutAlgorithmManager)this.serviceRegistrar.getService(CyLayoutAlgorithmManager.class)).getDefaultLayout();
        if (this.preferredLayout != null) {
            tm.showMessage(TaskMonitor.Level.INFO, "Preferred layout is " + this.preferredLayout.getName());
        } else {
            tm.showMessage(TaskMonitor.Level.WARN, "...but it's not available!");
        }
    }

    public Object getResults(Class type) {
        if (type.equals(String.class)) {
            return this.preferredLayout.getName();
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.preferredLayout == null) {
                    return "{ }";
                }
                return "\"" + this.preferredLayout.getName() + "\"";
            };
            return res;
        }
        if (this.preferredLayout == null) {
            return null;
        }
        return this.preferredLayout;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }
}

