/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.hide;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.work.undo.AbstractCyEdit;

final class HideEdit
extends AbstractCyEdit {
    private final CyNetworkView netView;
    private final Collection<? extends CyIdentifiable> elements;
    private final boolean visible;
    private final Map<View<? extends CyIdentifiable>, Boolean> previousStates;
    private final CyEventHelper eventHelper;
    private final VisualMappingManager vmMgr;

    HideEdit(String description, CyNetworkView netView, Collection<? extends CyIdentifiable> elements, boolean visible, CyEventHelper eventHelper, VisualMappingManager vmMgr) {
        super(description);
        this.netView = netView;
        this.elements = elements;
        this.visible = visible;
        this.eventHelper = eventHelper;
        this.vmMgr = vmMgr;
        this.previousStates = new HashMap<View<? extends CyIdentifiable>, Boolean>();
        for (CyIdentifiable cyIdentifiable : elements) {
            View view;
            if (cyIdentifiable instanceof CyNode) {
                view = netView.getNodeView((CyNode)cyIdentifiable);
                if (view != null) {
                    this.previousStates.put((View<? extends CyIdentifiable>)view, (Boolean)view.getVisualProperty(BasicVisualLexicon.NODE_VISIBLE));
                }
                if (visible) continue;
                CyNode n1 = (CyNode)cyIdentifiable;
                CyNetwork net = (CyNetwork)netView.getModel();
                for (CyNode n2 : net.getNeighborList(n1, CyEdge.Type.ANY)) {
                    for (CyEdge e : net.getConnectingEdgeList(n1, n2, CyEdge.Type.ANY)) {
                        View ev = netView.getEdgeView(e);
                        if (ev == null) continue;
                        this.previousStates.put((View<? extends CyIdentifiable>)ev, (Boolean)ev.getVisualProperty(BasicVisualLexicon.EDGE_VISIBLE));
                    }
                }
                continue;
            }
            if (!(cyIdentifiable instanceof CyEdge) || (view = netView.getEdgeView((CyEdge)cyIdentifiable)) == null) continue;
            this.previousStates.put((View<? extends CyIdentifiable>)view, (Boolean)view.getVisualProperty(BasicVisualLexicon.EDGE_VISIBLE));
        }
    }

    public void undo() {
        for (View<? extends CyIdentifiable> view : this.previousStates.keySet()) {
            this.setVisible(view, this.previousStates.get(view));
        }
        this.updateNetworkView();
    }

    public void redo() {
        for (CyIdentifiable cyIdentifiable : this.elements) {
            View view = null;
            if (cyIdentifiable instanceof CyNode) {
                view = this.netView.getNodeView((CyNode)cyIdentifiable);
            } else if (cyIdentifiable instanceof CyEdge) {
                view = this.netView.getEdgeView((CyEdge)cyIdentifiable);
            }
            if (view == null) continue;
            this.setVisible((View<? extends CyIdentifiable>)view, this.visible);
        }
        this.updateNetworkView();
    }

    private void setVisible(View<? extends CyIdentifiable> view, boolean visible) {
        VisualProperty vp;
        VisualProperty visualProperty = vp = view.getModel() instanceof CyNode ? BasicVisualLexicon.NODE_VISIBLE : BasicVisualLexicon.EDGE_VISIBLE;
        if (visible) {
            view.clearValueLock(vp);
        } else {
            view.setLockedValue(vp, (Object)false);
        }
    }

    private void updateNetworkView() {
        this.eventHelper.flushPayloadEvents();
        this.vmMgr.getVisualStyle(this.netView).apply(this.netView);
        this.netView.updateView();
    }
}

