/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.group;

import java.util.ArrayList;
import java.util.List;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNodeViewTaskFactory;
import org.cytoscape.task.edit.CollapseGroupTaskFactory;
import org.cytoscape.task.edit.ExpandGroupTaskFactory;
import org.cytoscape.task.internal.group.CollapseGroupTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;

public class GroupNodeContextTaskFactoryImpl
extends AbstractNodeViewTaskFactory
implements CollapseGroupTaskFactory,
ExpandGroupTaskFactory,
TaskFactory {
    private final CyGroupManager mgr;
    private final CyServiceRegistrar serviceRegistrar;
    private boolean collapse;

    public GroupNodeContextTaskFactoryImpl(CyGroupManager mgr, boolean collapse, CyServiceRegistrar serviceRegistrar) {
        this.mgr = mgr;
        this.collapse = collapse;
        this.serviceRegistrar = serviceRegistrar;
    }

    public boolean isReady() {
        return true;
    }

    public TaskIterator createTaskIterator() {
        return new TaskIterator(new Task[]{new CollapseGroupTask(this.mgr, this.collapse, this.serviceRegistrar)});
    }

    public boolean isReady(View<CyNode> nodeView, CyNetworkView netView) {
        CyGroup group;
        return this.collapse ? this.getExpandedGroupForNode((CyNode)nodeView.getModel(), netView) != null : (group = this.mgr.getGroup((CyNode)nodeView.getModel(), (CyNetwork)netView.getModel())) != null && group.isCollapsed((CyNetwork)netView.getModel());
    }

    public TaskIterator createTaskIterator(View<CyNode> nodeView, CyNetworkView netView) {
        ArrayList<CyGroup> groups = new ArrayList<CyGroup>();
        List selNodes = CyTableUtil.getNodesInState((CyNetwork)((CyNetwork)netView.getModel()), (String)"selected", (boolean)true);
        if (this.collapse) {
            groups.add(this.getExpandedGroupForNode((CyNode)nodeView.getModel(), netView));
            for (CyNode node : selNodes) {
                CyGroup g = this.getExpandedGroupForNode(node, netView);
                if (g == null) continue;
                groups.add(g);
            }
        } else {
            groups.add(this.mgr.getGroup((CyNode)nodeView.getModel(), (CyNetwork)netView.getModel()));
            for (CyNode node : selNodes) {
                CyGroup g = this.mgr.getGroup(node, (CyNetwork)netView.getModel());
                if (g == null) continue;
                groups.add(g);
            }
        }
        return new TaskIterator(new Task[]{new CollapseGroupTask((CyNetwork)netView.getModel(), groups, this.collapse, this.serviceRegistrar)});
    }

    private CyGroup getExpandedGroupForNode(CyNode node, CyNetworkView netView) {
        List groups = this.mgr.getGroupsForNode(node);
        if (groups == null || groups.size() == 0) {
            return null;
        }
        for (CyGroup group : groups) {
            if (!group.isInNetwork((CyNetwork)netView.getModel()) || group.isCollapsed((CyNetwork)netView.getModel())) continue;
            return group;
        }
        return null;
    }
}

