/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.group;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.group.AbstractGroupTask;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class GetGroupTask
extends AbstractGroupTask
implements ObservableTask {
    private CyApplicationManager appMgr;
    private CyGroup group;
    private CyJSONUtil jsonUtil;
    private static int groupNumber = 1;
    @Tunable(description="Network", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork network = null;
    @Tunable(description="Group to get", context="nogui", longDescription="Selects a node by name, or, if the parameter has the prefix ```suid:```, selects a node by SUID.", exampleStringValue="Node 1")
    public String node = null;
    public static String EXAMPLE_JSON = "{\"group\":1234,\"name\":\"my group\",\"nodes\":[122,123,124,125],\"externalEdges\":[201,202,203],\"internalEdges\":[300,301],\"collapsed\": false}";

    public GetGroupTask(CyApplicationManager appMgr, CyGroupManager mgr, CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.appMgr = appMgr;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setProgress(0.0);
        if (this.network == null) {
            this.network = this.appMgr.getCurrentNetwork();
            if (this.network == null) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
                throw new RuntimeException("Network must be specified");
            }
        }
        this.net = this.network;
        this.group = this.getGroup(this.node);
        if (this.group == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Can't find a group with that group node " + this.node);
            throw new RuntimeException("Can't find a group with that group node " + this.node);
        }
        tm.setProgress(1.0);
    }

    public Object getResults(Class requestedType) {
        if (this.group == null) {
            return null;
        }
        if (requestedType.equals(CyGroup.class)) {
            return this.group;
        }
        if (requestedType.equals(String.class)) {
            return this.group.toString();
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.group == null) {
                    return "{}";
                }
                return this.groupJSON(this.network, this.group);
            };
            return res;
        }
        return null;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, CyGroup.class, JSONResult.class);
    }

    public String groupJSON(CyNetwork network, CyGroup group) {
        this.jsonUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
        long suid = group.getGroupNode().getSUID();
        List nodes = group.getNodeList();
        List internalEdges = group.getInternalEdgeList();
        Set externalEdges = group.getExternalEdgeList();
        CyRow groupRow = ((CySubNetwork)this.net).getRootNetwork().getRow((CyIdentifiable)group.getGroupNode(), "SHARED_ATTRS");
        String name = (String)groupRow.get("shared name", String.class);
        String result = "{\"group\":" + suid + ",\"name\":\"" + name + "\",";
        result = result + "\"nodes\":" + this.jsonUtil.cyIdentifiablesToJson((Collection)nodes) + ",";
        result = result + "\"internalEdges\":" + this.jsonUtil.cyIdentifiablesToJson((Collection)internalEdges) + ",";
        result = result + "\"externalEdges\":" + this.jsonUtil.cyIdentifiablesToJson((Collection)externalEdges) + ",";
        result = result + "\"collapsed\":";
        result = group.isCollapsed(network) ? result + "true" : result + "false";
        result = result + "}";
        return result;
    }
}

