/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.filter;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.filter.TransformerManager;
import org.cytoscape.filter.model.NamedTransformer;
import org.cytoscape.filter.model.TransformerSink;
import org.cytoscape.io.read.CyTransformerReader;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.filter.SelectTunable;
import org.cytoscape.task.internal.filter.Sink;
import org.cytoscape.task.internal.filter.TransformerJsonTunable;
import org.cytoscape.task.internal.select.SelectUtils;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class SelectFilterTask
extends AbstractTask {
    @Tunable(description="Network", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork network = null;
    @ContainsTunables
    public TransformerJsonTunable json = new TransformerJsonTunable();
    @ContainsTunables
    public SelectTunable select = new SelectTunable();
    private final CyServiceRegistrar serviceRegistrar;

    public SelectFilterTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) throws Exception {
        CyTransformerReader transformerReader;
        NamedTransformer<CyNetwork, CyIdentifiable> transformer;
        if (this.network == null) {
            this.network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
            if (this.network == null) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
                throw new RuntimeException("Network must be specified");
            }
        }
        if ((transformer = this.json.getTransformer("ApplyFilterTask", transformerReader = (CyTransformerReader)this.serviceRegistrar.getService(CyTransformerReader.class))) == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Error parsing JSON");
            throw new RuntimeException("Error parsing JSON");
        }
        List<String> errors = TransformerJsonTunable.validate(transformer);
        if (!errors.isEmpty()) {
            for (String error : errors) {
                tm.showMessage(TaskMonitor.Level.ERROR, error);
            }
            throw new Exception("Transformer '" + transformer.getName() + "' is not valid: " + String.join((CharSequence)",", errors));
        }
        Optional<SelectTunable.Action> action = this.select.getAction();
        if (action.isEmpty()) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Invalid value for 'action' argument");
            throw new RuntimeException("Invalid value for 'action' argument");
        }
        int[] result = SelectFilterTask.applyFilter(this.serviceRegistrar, this.network, transformer, action.get());
        tm.showMessage(TaskMonitor.Level.INFO, SelectFilterTask.getResultMessage(result));
    }

    public static String getResultMessage(int[] result) {
        return String.format("Filter applied, selected %d nodes and %d edges.", result[0], result[1]);
    }

    public static int[] applyFilter(CyServiceRegistrar registrar, CyNetwork network, NamedTransformer<CyNetwork, CyIdentifiable> transformer, SelectTunable.Action action) {
        SelectUtils selectUtils = new SelectUtils(registrar);
        selectUtils.setSelectedNodes(network, network.getNodeList(), false);
        selectUtils.setSelectedEdges(network, network.getEdgeList(), false);
        Sink sink = new Sink();
        ((TransformerManager)registrar.getService(TransformerManager.class)).execute((Object)network, transformer.getTransformers(), (TransformerSink)sink);
        if (action == SelectTunable.Action.SELECT) {
            selectUtils.setSelectedNodes(network, sink.getNodes(), true);
            selectUtils.setSelectedEdges(network, sink.getEdges(), true);
        } else if (action == SelectTunable.Action.SHOW) {
            CyNetworkViewManager networkViewManager = (CyNetworkViewManager)registrar.getService(CyNetworkViewManager.class);
            Collection networkViews = networkViewManager.getNetworkViews(network);
            for (CyNetworkView networkView : networkViews) {
                selectUtils.setVisible(networkView, sink.getNodes(), sink.getEdges());
            }
        }
        return new int[]{sink.getNodeCount(), sink.getEdgeCount()};
    }
}

