/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.filter;

import org.cytoscape.filter.TransformerContainer;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.filter.ContainerTunable;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class DeleteFilterTask
extends AbstractTask {
    @Tunable
    public String name;
    @ContainsTunables
    public ContainerTunable containerTunable = new ContainerTunable();
    private final CyServiceRegistrar serviceRegistrar;

    public DeleteFilterTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        if (this.name == null || this.name.isEmpty()) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "name is missing");
            return;
        }
        TransformerContainer<CyNetwork, CyIdentifiable> container = this.containerTunable.getContainer(this.serviceRegistrar);
        if (container == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "container type not found: '" + this.containerTunable.getValue() + "'");
            return;
        }
        boolean removed = container.removeNamedTransformer(this.name);
        if (removed) {
            taskMonitor.showMessage(TaskMonitor.Level.INFO, "filter '" + this.name + "' removed");
        } else {
            taskMonitor.showMessage(TaskMonitor.Level.WARN, "filter '" + this.name + "' not found");
        }
    }
}

