/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.filter;

import java.util.Optional;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.filter.TransformerContainer;
import org.cytoscape.filter.model.NamedTransformer;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.filter.ContainerTunable;
import org.cytoscape.task.internal.filter.SelectFilterTask;
import org.cytoscape.task.internal.filter.SelectTunable;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class ApplyFilterTask
extends AbstractTask {
    @Tunable(description="Network", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork network = null;
    @Tunable
    public String name;
    @ContainsTunables
    public ContainerTunable containerTunable = new ContainerTunable();
    @ContainsTunables
    public SelectTunable select = new SelectTunable();
    private final CyServiceRegistrar serviceRegistrar;

    public ApplyFilterTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        TransformerContainer<CyNetwork, CyIdentifiable> container;
        if (this.name == null || this.name.isEmpty()) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "name is missing");
            throw new RuntimeException("Name must be specified");
        }
        if (this.network == null) {
            this.network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
            if (this.network == null) {
                taskMonitor.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
                throw new RuntimeException("Network must be specified");
            }
        }
        if ((container = this.containerTunable.getContainer(this.serviceRegistrar)) == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "container type not found: '" + this.containerTunable.getValue() + "'");
            throw new RuntimeException("container type not found: '" + this.containerTunable.getValue() + "'");
        }
        NamedTransformer transformer = container.getNamedTransformer(this.name);
        if (transformer == null) {
            taskMonitor.showMessage(TaskMonitor.Level.WARN, "filter '" + this.name + "' not found");
            return;
        }
        Optional<SelectTunable.Action> action = this.select.getAction();
        if (action.isEmpty()) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "Invalid value for 'action' argument");
            throw new RuntimeException("Invalid value for 'action' argument");
        }
        int[] result = SelectFilterTask.applyFilter(this.serviceRegistrar, this.network, (NamedTransformer<CyNetwork, CyIdentifiable>)transformer, action.get());
        taskMonitor.showMessage(TaskMonitor.Level.INFO, SelectFilterTask.getResultMessage(result));
    }
}

