/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.export.web;

import java.util.Map;
import java.util.Set;
import org.cytoscape.io.write.CySessionWriterFactory;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.export.web.ExportAsWebArchiveTask;
import org.cytoscape.task.internal.export.web.ShowWarningTask;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class ExportAsWebArchiveTaskFactory
extends AbstractTaskFactory {
    private static final Integer TH = 3000;
    private CySessionWriterFactory fullWriterFactory;
    private CySessionWriterFactory simpleWriterFactory;
    private CySessionWriterFactory zippedWriterFactory;
    private final CyServiceRegistrar serviceRegistrar;

    public ExportAsWebArchiveTaskFactory(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void registerFactory(CySessionWriterFactory writerFactory, Map<?, ?> props) {
        Object id = props.get("id");
        if (id == null) {
            return;
        }
        if (id.equals("fullWebSessionWriterFactory")) {
            this.fullWriterFactory = writerFactory;
        }
        if (id.equals("simpleWebSessionWriterFactory")) {
            this.simpleWriterFactory = writerFactory;
        }
        if (id.equals("zippedJsonWriterFactory")) {
            this.zippedWriterFactory = writerFactory;
        }
    }

    public void unregisterFactory(CySessionWriterFactory writerFactory, Map<?, ?> props) {
    }

    public TaskIterator createTaskIterator() {
        Set networks = ((CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class)).getNetworkSet();
        boolean showWarning = false;
        for (CyNetwork net : networks) {
            int nodeCount = net.getNodeCount();
            int edgeCount = net.getEdgeCount();
            if (nodeCount <= TH && edgeCount <= TH) continue;
            showWarning = true;
            break;
        }
        ExportAsWebArchiveTask exportTask = new ExportAsWebArchiveTask(this.fullWriterFactory, this.simpleWriterFactory, this.zippedWriterFactory, this.serviceRegistrar);
        return showWarning ? new TaskIterator(new Task[]{new ShowWarningTask((Task)exportTask)}) : new TaskIterator(new Task[]{exportTask});
    }

    public boolean isReady() {
        return ((CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class)).getNetworkSet().size() > 0;
    }
}

