/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.export.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CyNetworkNaming;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class GenerateNetworkViewsTask
extends AbstractTask
implements ObservableTask {
    private final String name;
    private final CyNetworkReader viewReader;
    private final int viewThreshold;
    private final CyServiceRegistrar serviceRegistrar;
    private List<CyNetworkView> results;
    private List<CyNetwork> largeNetworks;
    public static final String JSON_EXAMPLE = "{ \"networks\":[101,102,103],\"views\":[200,201,204] }";

    public GenerateNetworkViewsTask(String name, CyNetworkReader viewReader, int viewThreshold, CyServiceRegistrar serviceRegistrar) {
        this.name = name;
        this.viewReader = viewReader;
        this.viewThreshold = viewThreshold;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        CySubNetwork subnet;
        CyRootNetwork rootNet;
        String rootNetName;
        CyNetwork[] networks = this.viewReader.getNetworks();
        if (networks == null || networks.length == 0) {
            return;
        }
        taskMonitor.setProgress(0.0);
        CyNetworkNaming networkNaming = (CyNetworkNaming)this.serviceRegistrar.getService(CyNetworkNaming.class);
        double numNets = networks.length;
        int i = 0;
        this.results = new ArrayList<CyNetworkView>();
        this.largeNetworks = new ArrayList<CyNetwork>();
        for (CyNetwork net : networks) {
            String networkName = (String)net.getRow((CyIdentifiable)net).get("name", String.class);
            if (networkName == null || networkName.trim().length() == 0) {
                networkName = this.name != null ? this.name : "? (Name is missing)";
            }
            net.getRow((CyIdentifiable)net).set("name", (Object)networkNaming.getSuggestedNetworkTitle(networkName));
            ((CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class)).addNetwork(net, false);
            int numGraphObjects = net.getNodeCount() + net.getEdgeCount();
            if (numGraphObjects < this.viewThreshold) {
                this.createNetworkView(net);
            } else {
                this.largeNetworks.add(net);
            }
            taskMonitor.setProgress((double)(++i) / numNets);
        }
        if (networks.length == 1 && networks[0] instanceof CySubNetwork && ((rootNetName = (String)(rootNet = (subnet = (CySubNetwork)networks[0]).getRootNetwork()).getRow((CyIdentifiable)rootNet).get("name", String.class)) == null || rootNetName.trim().length() == 0)) {
            rootNet.getRow((CyIdentifiable)rootNet).set("name", (Object)((String)networks[0].getRow((CyIdentifiable)networks[0]).get("name", String.class)));
        }
        for (CyNetwork net : networks) {
            CySubNetwork subNet;
            CyRootNetwork rootNet2;
            String networkName;
            if (!(net instanceof CySubNetwork) || (networkName = (String)(rootNet2 = (subNet = (CySubNetwork)net).getRootNetwork()).getRow((CyIdentifiable)rootNet2).get("name", String.class)) != null && networkName.trim().length() != 0) continue;
            networkName = this.name;
            if (networkName == null) {
                networkName = "? (Name is missing)";
            }
            rootNet2.getRow((CyIdentifiable)rootNet2).set("name", (Object)networkNaming.getSuggestedNetworkTitle(networkName));
        }
        this.setCurrentNetworkAndViewTask(networks[0]);
        if (!this.largeNetworks.isEmpty()) {
            this.insertTasksAfterCurrentTask(new Task[]{new ConfirmCreateNetworkViewsTask(this.largeNetworks)});
        }
    }

    private Object getStringResults() {
        Object strRes = "";
        for (CyNetworkView view : this.results) {
            strRes = (String)strRes + view.toString() + "\n";
        }
        return ((String)strRes).isEmpty() ? null : ((String)strRes).substring(0, ((String)strRes).length() - 1);
    }

    private void createNetworkView(CyNetwork network) {
        CyNetworkView view = this.viewReader.buildCyNetworkView(network);
        VisualMappingManager vmManager = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        VisualStyle viewStyle = vmManager.getVisualStyle(view);
        CyNetworkViewManager viewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        viewManager.addNetworkView(view, false);
        if (viewStyle == null || viewStyle.equals(vmManager.getDefaultVisualStyle())) {
            VisualStyle style = vmManager.getDefaultVisualStyle();
            CyRootNetwork rootNet = ((CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class)).getRootNetwork(network);
            Collection baseViewSet = viewManager.getNetworkViews((CyNetwork)rootNet.getBaseNetwork());
            if (!baseViewSet.isEmpty()) {
                style = vmManager.getVisualStyle((CyNetworkView)baseViewSet.iterator().next());
            }
            vmManager.setVisualStyle(style, view);
            style.apply(view);
        }
        if (!(view.isSet(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION) || view.isSet(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION) || view.isSet(BasicVisualLexicon.NETWORK_CENTER_Z_LOCATION))) {
            view.fitContent();
        }
        this.results.add(view);
    }

    public void setCurrentNetworkAndViewTask(CyNetwork network) {
        CyNetworkViewManager netViewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        ArrayList views = new ArrayList(netViewManager.getNetworkViews(network));
        CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        boolean currentViewSet = false;
        for (CyNetworkView v : views) {
            if (!((CyNetwork)v.getModel()).equals(network)) continue;
            applicationManager.setCurrentNetworkView(v);
            currentViewSet = true;
            break;
        }
        if (!currentViewSet) {
            applicationManager.setCurrentNetwork(network);
        }
    }

    public Object getResults(Class expectedType) {
        if (expectedType.equals(String.class)) {
            return this.getStringResults();
        }
        if (expectedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.results == null && this.largeNetworks.isEmpty()) {
                    return "{}";
                }
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                ArrayList<CyNetwork> networks = new ArrayList<CyNetwork>();
                for (CyNetworkView view : this.results) {
                    networks.add((CyNetwork)view.getModel());
                }
                networks.addAll(this.largeNetworks);
                Object jsonRes = "{ \"networks\":";
                jsonRes = (String)jsonRes + cyJSONUtil.cyIdentifiablesToJson(networks);
                jsonRes = (String)jsonRes + ", \"views\":";
                jsonRes = (String)jsonRes + cyJSONUtil.cyIdentifiablesToJson(this.results) + "}";
                return jsonRes;
            };
            return res;
        }
        return this.results;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(List.class, String.class, JSONResult.class);
    }

    public class ConfirmCreateNetworkViewsTask
    extends AbstractTask
    implements ObservableTask {
        @Tunable(description="Do you want to create a view for your large networks now?\nThis could take a long time.", params="ForceSetDirectly=true;ForceSetTitle=Create Network Views?")
        public boolean createNetworkViews;
        private List<CyNetwork> networks;

        public ConfirmCreateNetworkViewsTask(List<CyNetwork> networks) {
            this.networks = networks;
        }

        public void run(TaskMonitor taskMonitor) throws Exception {
            taskMonitor.setProgress(0.0);
            CyNetworkViewFactory nullNetViewFactory = (CyNetworkViewFactory)GenerateNetworkViewsTask.this.serviceRegistrar.getService(CyNetworkViewFactory.class, "(id=NullCyNetworkViewFactory)");
            double numNets = this.networks.size();
            int i = 0;
            for (CyNetwork net : this.networks) {
                if (this.createNetworkViews) {
                    GenerateNetworkViewsTask.this.createNetworkView(net);
                } else {
                    GenerateNetworkViewsTask.this.results.add(nullNetViewFactory.createNetworkView(net));
                }
                taskMonitor.setProgress((double)(++i) / numNets);
            }
            if (!this.networks.isEmpty()) {
                GenerateNetworkViewsTask.this.setCurrentNetworkAndViewTask(this.networks.get(0));
            }
        }

        public Object getResults(Class expectedType) {
            if (expectedType.equals(String.class)) {
                return GenerateNetworkViewsTask.this.getStringResults();
            }
            if (expectedType.equals(JSONResult.class)) {
                JSONResult res = () -> {
                    if (GenerateNetworkViewsTask.this.results == null && GenerateNetworkViewsTask.this.largeNetworks.isEmpty()) {
                        return "{}";
                    }
                    CyJSONUtil cyJSONUtil = (CyJSONUtil)GenerateNetworkViewsTask.this.serviceRegistrar.getService(CyJSONUtil.class);
                    ArrayList<CyNetwork> networks = new ArrayList<CyNetwork>();
                    for (CyNetworkView view : GenerateNetworkViewsTask.this.results) {
                        networks.add((CyNetwork)view.getModel());
                    }
                    for (CyNetwork net : GenerateNetworkViewsTask.this.largeNetworks) {
                        if (networks.contains(net)) continue;
                        networks.add(net);
                    }
                    Object jsonRes = "{ \"networks\":";
                    jsonRes = (String)jsonRes + cyJSONUtil.cyIdentifiablesToJson(networks);
                    jsonRes = (String)jsonRes + ", \"views\":";
                    jsonRes = (String)jsonRes + cyJSONUtil.cyIdentifiablesToJson(GenerateNetworkViewsTask.this.results);
                    return jsonRes;
                };
                return res;
            }
            return GenerateNetworkViewsTask.this.results;
        }

        public List<Class<?>> getResultClasses() {
            return Arrays.asList(List.class, String.class, JSONResult.class);
        }
    }
}

