/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.export.network;

import java.io.File;
import java.io.OutputStream;
import org.apache.commons.io.FilenameUtils;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.write.CyNetworkViewWriterFactory;
import org.cytoscape.io.write.CyNetworkViewWriterManager;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.export.TunableAbstractCyWriter;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Tunable;

public final class CyNetworkWriter
extends TunableAbstractCyWriter<CyNetworkViewWriterFactory, CyNetworkViewWriterManager> {
    @Tunable(description="The network to be exported", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current", context="nogui")
    public CyNetwork network;

    public CyNetworkWriter(CyNetwork network, boolean useTunable, CyServiceRegistrar serviceRegistrar) {
        super((CyNetworkViewWriterManager)serviceRegistrar.getService(CyNetworkViewWriterManager.class), (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class));
        this.network = network;
        for (String fileTypeDesc : this.getFileFilterDescriptions()) {
            if (!fileTypeDesc.contains("SIF")) continue;
            this.options.setSelectedValue((Object)fileTypeDesc);
            break;
        }
        if (useTunable) {
            return;
        }
        if (network == null) {
            throw new RuntimeException("Network must be specified.");
        }
        this.outputFile = this.getSuggestedFile();
    }

    void setDefaultFileFormatUsingFileExt(File file) {
        String ext = FilenameUtils.getExtension((String)file.getName());
        ext = ext.toLowerCase().trim();
        String searchDesc = "*." + ext;
        for (String fileTypeDesc : this.getFileFilterDescriptions()) {
            if (!fileTypeDesc.contains(searchDesc)) continue;
            this.options.setSelectedValue((Object)fileTypeDesc);
            break;
        }
    }

    @Override
    protected CyWriter getWriter(CyFileFilter filter) throws Exception {
        if (this.network == null) {
            this.network = this.cyApplicationManager.getCurrentNetwork();
            if (this.network == null) {
                throw new RuntimeException("No current network");
            }
        }
        return ((CyNetworkViewWriterManager)this.writerManager).getWriter(this.network, filter, (OutputStream)this.outputStream);
    }

    @Override
    @Tunable(description="File to save network to", params="fileCategory=network;input=false", required=true, dependsOn="options!=", gravity=1.1)
    public File getOutputFile() {
        return this.outputFile;
    }

    @ProvidesTitle
    public String getTitle() {
        return "Export Network";
    }

    @Override
    protected String getExportName() {
        return (String)this.network.getRow((CyIdentifiable)this.network).get("name", String.class);
    }
}

