/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.export;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.io.write.CyWriterFactory;
import org.cytoscape.io.write.CyWriterManager;
import org.cytoscape.task.internal.export.AbstractCyWriter;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.swing.RequestsUIHelper;
import org.cytoscape.work.swing.TunableUIHelper;
import org.cytoscape.work.util.ListChangeListener;
import org.cytoscape.work.util.ListSelection;
import org.cytoscape.work.util.ListSingleSelection;

public abstract class TunableAbstractCyWriter<S extends CyWriterFactory, T extends CyWriterManager<S>>
extends AbstractCyWriter<S, T>
implements TunableValidator,
RequestsUIHelper,
ObservableTask {
    @Tunable(description="Export File Format:", longDescription="The format of the output file.", exampleStringValue="CSV", gravity=1.0)
    public ListSingleSelection<String> options;
    @ContainsTunables(offset=1.0)
    public CyWriter writer;
    protected TunableUIHelper helper;

    @Override
    public CyWriter getWriter() {
        if (this.writer == null) {
            try {
                this.writer = this.getWriter(this.getFileFilter(this.getExportFileFormat()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.writer;
    }

    @Override
    public final void setOutputFile(File f) {
        if (f == null || this.fileExtensionIsOk(f)) {
            this.outputFile = f;
        } else {
            this.outputFile = this.addOrReplaceExtension(f);
            if (this.helper != null) {
                this.helper.update((Object)this);
            }
        }
    }

    @Override
    protected final String getExportFileFormat() {
        return (String)this.options.getSelectedValue();
    }

    public TunableAbstractCyWriter(T writerManager, CyApplicationManager cyApplicationManager) {
        super(writerManager, cyApplicationManager);
        ArrayList<String> availableFormats = new ArrayList<String>(this.getFileFilterDescriptions());
        this.options = new ListSingleSelection(availableFormats);
        this.options.addListener((ListChangeListener)new ListChangeListener<String>(){

            public void selectionChanged(ListSelection<String> source) {
                try {
                    TunableAbstractCyWriter.this.writer = TunableAbstractCyWriter.this.getWriter(TunableAbstractCyWriter.this.getFileFilter(TunableAbstractCyWriter.this.getExportFileFormat()));
                    if (TunableAbstractCyWriter.this.outputFile != null) {
                        TunableAbstractCyWriter.this.outputFile = TunableAbstractCyWriter.this.addOrReplaceExtension(TunableAbstractCyWriter.this.outputFile);
                    }
                    if (TunableAbstractCyWriter.this.helper != null) {
                        TunableAbstractCyWriter.this.helper.refresh((Object)TunableAbstractCyWriter.this);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void listChanged(ListSelection<String> source) {
            }
        });
    }

    public TunableValidator.ValidationState getValidationState(Appendable msg) {
        if (this.getExportFileFormat() == null) {
            try {
                msg.append("Select a file type.");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return TunableValidator.ValidationState.INVALID;
        }
        if (this.outputFile == null) {
            try {
                msg.append("Enter a file name.");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return TunableValidator.ValidationState.INVALID;
        }
        if (this.outputFile.exists()) {
            try {
                msg.append("File already exists, are you sure you want to overwrite it?");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return TunableValidator.ValidationState.REQUEST_CONFIRMATION;
        }
        return TunableValidator.ValidationState.OK;
    }

    public void setUIHelper(TunableUIHelper helper) {
        this.helper = helper;
    }

    public Object getResults(Class type) {
        if (type == String.class) {
            String res = null;
            if (this.outputFile != null) {
                res = "Output File: " + this.outputFile.getAbsolutePath();
            }
            return res;
        }
        if (type == JSONResult.class) {
            JsonObject jsonObj = new JsonObject();
            jsonObj.addProperty("file", this.outputFile != null ? this.outputFile.getAbsolutePath() : null);
            String json = new Gson().toJson((JsonElement)jsonObj);
            JSONResult res = () -> json;
            return res;
        }
        return this.outputFile;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, File.class, JSONResult.class);
    }
}

