/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.edit;

import java.util.ArrayList;
import java.util.Collection;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.undo.AbstractCyEdit;

final class ConnectSelectedNodesEdit
extends AbstractCyEdit {
    private final CyNetwork network;
    private Collection<CyEdge> edges;

    ConnectSelectedNodesEdit(CyNetwork network, Collection<CyEdge> edges) {
        super("Connect Selected Nodes");
        this.network = network;
        this.edges = edges;
    }

    public void redo() {
        ArrayList<CyEdge> newEdges = new ArrayList<CyEdge>(this.edges.size());
        for (CyEdge edge : this.edges) {
            CyNode source = edge.getSource();
            CyNode target = edge.getTarget();
            CyEdge newEdge = this.network.addEdge(source, target, false);
            this.network.getRow((CyIdentifiable)newEdge).set("name", (Object)((String)this.network.getRow((CyIdentifiable)source).get("name", String.class) + " (interacts with) " + (String)this.network.getRow((CyIdentifiable)target).get("name", String.class)));
            this.network.getRow((CyIdentifiable)newEdge).set("interaction", (Object)"interacts with");
            newEdges.add(newEdge);
        }
        this.edges = newEdges;
    }

    public void undo() {
        this.network.removeEdges(this.edges);
    }
}

