/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.group.CyGroupFactory;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.io.write.CyNetworkViewWriterManager;
import org.cytoscape.io.write.CySessionWriterFactory;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractTableColumnTaskFactory;
import org.cytoscape.task.NetworkCollectionTaskFactory;
import org.cytoscape.task.NetworkTaskFactory;
import org.cytoscape.task.NetworkViewCollectionTaskFactory;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.task.NodeViewTaskFactory;
import org.cytoscape.task.TableCellTaskFactory;
import org.cytoscape.task.TableColumnTaskFactory;
import org.cytoscape.task.TableTaskFactory;
import org.cytoscape.task.create.CloneNetworkTaskFactory;
import org.cytoscape.task.create.CreateNetworkViewTaskFactory;
import org.cytoscape.task.create.NewEmptyNetworkViewFactory;
import org.cytoscape.task.create.NewNetworkSelectedNodesAndEdgesTaskFactory;
import org.cytoscape.task.create.NewNetworkSelectedNodesOnlyTaskFactory;
import org.cytoscape.task.create.NewSessionTaskFactory;
import org.cytoscape.task.destroy.DeleteColumnTaskFactory;
import org.cytoscape.task.destroy.DeleteSelectedNodesAndEdgesTaskFactory;
import org.cytoscape.task.destroy.DeleteTableTaskFactory;
import org.cytoscape.task.destroy.DestroyNetworkTaskFactory;
import org.cytoscape.task.destroy.DestroyNetworkViewTaskFactory;
import org.cytoscape.task.edit.CollapseGroupTaskFactory;
import org.cytoscape.task.edit.ConnectSelectedNodesTaskFactory;
import org.cytoscape.task.edit.EditNetworkTitleTaskFactory;
import org.cytoscape.task.edit.ExpandGroupTaskFactory;
import org.cytoscape.task.edit.GroupNodesTaskFactory;
import org.cytoscape.task.edit.MapGlobalToLocalTableTaskFactory;
import org.cytoscape.task.edit.MapTableToNetworkTablesTaskFactory;
import org.cytoscape.task.edit.MergeTablesTaskFactory;
import org.cytoscape.task.edit.RenameColumnTaskFactory;
import org.cytoscape.task.edit.UnGroupNodesTaskFactory;
import org.cytoscape.task.edit.UnGroupTaskFactory;
import org.cytoscape.task.hide.HideSelectedEdgesTaskFactory;
import org.cytoscape.task.hide.HideSelectedNodesTaskFactory;
import org.cytoscape.task.hide.HideSelectedTaskFactory;
import org.cytoscape.task.hide.HideTaskFactory;
import org.cytoscape.task.hide.HideUnselectedEdgesTaskFactory;
import org.cytoscape.task.hide.HideUnselectedNodesTaskFactory;
import org.cytoscape.task.hide.HideUnselectedTaskFactory;
import org.cytoscape.task.hide.UnHideAllEdgesTaskFactory;
import org.cytoscape.task.hide.UnHideAllNodesTaskFactory;
import org.cytoscape.task.hide.UnHideAllTaskFactory;
import org.cytoscape.task.hide.UnHideSelectedEdgesTaskFactory;
import org.cytoscape.task.hide.UnHideSelectedNodesTaskFactory;
import org.cytoscape.task.hide.UnHideTaskFactory;
import org.cytoscape.task.internal.DynamicTaskFactoryProvisionerImpl;
import org.cytoscape.task.internal.edit.ConnectSelectedNodesTaskFactoryImpl;
import org.cytoscape.task.internal.export.graphics.ExportNetworkImageTaskFactoryImpl;
import org.cytoscape.task.internal.export.network.ExportNetworkTaskFactoryImpl;
import org.cytoscape.task.internal.export.network.ExportNetworkViewTaskFactoryImpl;
import org.cytoscape.task.internal.export.network.ExportSelectedNetworkTaskFactoryImpl;
import org.cytoscape.task.internal.export.network.LoadMultipleNetworkFilesTaskFactoryImpl;
import org.cytoscape.task.internal.export.network.LoadNetworkFileTaskFactoryImpl;
import org.cytoscape.task.internal.export.network.LoadNetworkURLTaskFactoryImpl;
import org.cytoscape.task.internal.export.table.ExportNoGuiSelectedTableTaskFactoryImpl;
import org.cytoscape.task.internal.export.table.ExportSelectedTableTaskFactoryImpl;
import org.cytoscape.task.internal.export.table.ExportTableTaskFactoryImpl;
import org.cytoscape.task.internal.export.web.ExportAsWebArchiveTaskFactory;
import org.cytoscape.task.internal.filter.ApplyFilterTaskFactory;
import org.cytoscape.task.internal.filter.CreateFilterTaskFactory;
import org.cytoscape.task.internal.filter.DeleteFilterTaskFactory;
import org.cytoscape.task.internal.filter.GetFilterTaskFactory;
import org.cytoscape.task.internal.filter.ListFiltersTaskFactory;
import org.cytoscape.task.internal.filter.RenameFilterTaskFactory;
import org.cytoscape.task.internal.filter.SelectFilterTaskFactory;
import org.cytoscape.task.internal.group.AddToGroupTaskFactory;
import org.cytoscape.task.internal.group.GetGroupTask;
import org.cytoscape.task.internal.group.GetGroupTaskFactory;
import org.cytoscape.task.internal.group.GroupNodeContextTaskFactoryImpl;
import org.cytoscape.task.internal.group.GroupNodesTaskFactoryImpl;
import org.cytoscape.task.internal.group.ListGroupsTaskFactory;
import org.cytoscape.task.internal.group.RemoveFromGroupTaskFactory;
import org.cytoscape.task.internal.group.RenameGroupTaskFactory;
import org.cytoscape.task.internal.group.UnGroupNodesTaskFactoryImpl;
import org.cytoscape.task.internal.help.HelpTaskFactory;
import org.cytoscape.task.internal.hide.HideCommandTaskFactory;
import org.cytoscape.task.internal.hide.HideSelectedEdgesTaskFactoryImpl;
import org.cytoscape.task.internal.hide.HideSelectedNodesTaskFactoryImpl;
import org.cytoscape.task.internal.hide.HideSelectedTaskFactoryImpl;
import org.cytoscape.task.internal.hide.HideTaskFactoryImpl;
import org.cytoscape.task.internal.hide.HideUnselectedEdgesTaskFactoryImpl;
import org.cytoscape.task.internal.hide.HideUnselectedNodesTaskFactoryImpl;
import org.cytoscape.task.internal.hide.HideUnselectedTaskFactoryImpl;
import org.cytoscape.task.internal.hide.UnHideAllEdgesTaskFactoryImpl;
import org.cytoscape.task.internal.hide.UnHideAllNodesTaskFactoryImpl;
import org.cytoscape.task.internal.hide.UnHideAllTaskFactoryImpl;
import org.cytoscape.task.internal.hide.UnHideCommandTaskFactory;
import org.cytoscape.task.internal.hide.UnHideSelectedEdgesTaskFactoryImpl;
import org.cytoscape.task.internal.hide.UnHideSelectedNodesTaskFactoryImpl;
import org.cytoscape.task.internal.hide.UnHideTaskFactoryImpl;
import org.cytoscape.task.internal.layout.ApplyPreferredLayoutTaskFactoryImpl;
import org.cytoscape.task.internal.layout.GetPreferredLayoutTaskFactory;
import org.cytoscape.task.internal.layout.SetPreferredLayoutTaskFactory;
import org.cytoscape.task.internal.network.CloneNetworkTaskFactoryImpl;
import org.cytoscape.task.internal.network.DestroyNetworkTaskFactoryImpl;
import org.cytoscape.task.internal.network.NewEmptyNetworkTaskFactoryImpl;
import org.cytoscape.task.internal.network.NewNetworkCommandTaskFactory;
import org.cytoscape.task.internal.network.NewNetworkSelectedNodesEdgesTaskFactoryImpl;
import org.cytoscape.task.internal.network.NewNetworkSelectedNodesOnlyTaskFactoryImpl;
import org.cytoscape.task.internal.networkobjects.AddEdgeTaskFactory;
import org.cytoscape.task.internal.networkobjects.AddNodeTaskFactory;
import org.cytoscape.task.internal.networkobjects.AddTaskFactory;
import org.cytoscape.task.internal.networkobjects.DeleteSelectedNodesAndEdgesTaskFactoryImpl;
import org.cytoscape.task.internal.networkobjects.GetEdgeTaskFactory;
import org.cytoscape.task.internal.networkobjects.GetNetworkTaskFactory;
import org.cytoscape.task.internal.networkobjects.GetNodeTaskFactory;
import org.cytoscape.task.internal.networkobjects.GetPropertiesTaskFactory;
import org.cytoscape.task.internal.networkobjects.ListEdgesTaskFactory;
import org.cytoscape.task.internal.networkobjects.ListNetworksTaskFactory;
import org.cytoscape.task.internal.networkobjects.ListNodesTaskFactory;
import org.cytoscape.task.internal.networkobjects.ListPropertiesTaskFactory;
import org.cytoscape.task.internal.networkobjects.RenameEdgeTaskFactory;
import org.cytoscape.task.internal.networkobjects.RenameNodeTaskFactory;
import org.cytoscape.task.internal.networkobjects.SetCurrentNetworkTaskFactory;
import org.cytoscape.task.internal.networkobjects.SetPropertiesTaskFactory;
import org.cytoscape.task.internal.proxysettings.ProxySettingsTaskFactoryImpl;
import org.cytoscape.task.internal.select.DeselectAllEdgesTaskFactoryImpl;
import org.cytoscape.task.internal.select.DeselectAllNodesTaskFactoryImpl;
import org.cytoscape.task.internal.select.DeselectAllTaskFactoryImpl;
import org.cytoscape.task.internal.select.DeselectTaskFactory;
import org.cytoscape.task.internal.select.InvertSelectedEdgesTaskFactoryImpl;
import org.cytoscape.task.internal.select.InvertSelectedNodesTaskFactoryImpl;
import org.cytoscape.task.internal.select.SelectAdjacentEdgesTaskFactoryImpl;
import org.cytoscape.task.internal.select.SelectAllEdgesTaskFactoryImpl;
import org.cytoscape.task.internal.select.SelectAllNodesTaskFactoryImpl;
import org.cytoscape.task.internal.select.SelectAllTaskFactoryImpl;
import org.cytoscape.task.internal.select.SelectConnectedNodesTaskFactoryImpl;
import org.cytoscape.task.internal.select.SelectFirstNeighborsNodeViewTaskFactoryImpl;
import org.cytoscape.task.internal.select.SelectFirstNeighborsTaskFactoryImpl;
import org.cytoscape.task.internal.select.SelectFromFileListTaskFactoryImpl;
import org.cytoscape.task.internal.select.SelectTaskFactory;
import org.cytoscape.task.internal.session.NewSessionTaskFactoryImpl;
import org.cytoscape.task.internal.session.OpenSessionCommandTaskFactory;
import org.cytoscape.task.internal.session.OpenSessionTaskFactoryImpl;
import org.cytoscape.task.internal.session.SaveSessionAsTaskFactoryImpl;
import org.cytoscape.task.internal.session.SaveSessionTaskFactoryImpl;
import org.cytoscape.task.internal.table.AddRowTaskFactory;
import org.cytoscape.task.internal.table.CopyValueToColumnTaskFactoryImpl;
import org.cytoscape.task.internal.table.CreateColumnTaskFactory;
import org.cytoscape.task.internal.table.CreateNetworkAttributeTaskFactory;
import org.cytoscape.task.internal.table.CreateTableTaskFactory;
import org.cytoscape.task.internal.table.DeleteColumnCommandTaskFactory;
import org.cytoscape.task.internal.table.DeleteColumnTaskFactoryImpl;
import org.cytoscape.task.internal.table.DeleteRowTaskFactory;
import org.cytoscape.task.internal.table.DeleteTableTaskFactoryImpl;
import org.cytoscape.task.internal.table.DestroyTableTaskFactory;
import org.cytoscape.task.internal.table.GetColumnTaskFactory;
import org.cytoscape.task.internal.table.GetNetworkAttributeTaskFactory;
import org.cytoscape.task.internal.table.GetRowTaskFactory;
import org.cytoscape.task.internal.table.GetValueTaskFactory;
import org.cytoscape.task.internal.table.ListColumnsTaskFactory;
import org.cytoscape.task.internal.table.ListNetworkAttributesTaskFactory;
import org.cytoscape.task.internal.table.ListRowsTaskFactory;
import org.cytoscape.task.internal.table.ListTablesTaskFactory;
import org.cytoscape.task.internal.table.MapGlobalToLocalTableTaskFactoryImpl;
import org.cytoscape.task.internal.table.MapTableToNetworkTablesTaskFactoryImpl;
import org.cytoscape.task.internal.table.MergeTablesTaskFactoryImpl;
import org.cytoscape.task.internal.table.RenameColumnTaskFactoryImpl;
import org.cytoscape.task.internal.table.SetNetworkAttributeTaskFactory;
import org.cytoscape.task.internal.table.SetTableTitleTaskFactory;
import org.cytoscape.task.internal.table.SetValuesTaskFactory;
import org.cytoscape.task.internal.title.EditNetworkTitleTaskFactoryImpl;
import org.cytoscape.task.internal.utils.IconUtil;
import org.cytoscape.task.internal.view.CreateNetworkViewTaskFactoryImpl;
import org.cytoscape.task.internal.view.DestroyNetworkViewTaskFactoryImpl;
import org.cytoscape.task.internal.view.GetCurrentNetworkViewTaskFactory;
import org.cytoscape.task.internal.view.ListNetworkViewsTaskFactory;
import org.cytoscape.task.internal.view.SetCurrentNetworkViewTaskFactory;
import org.cytoscape.task.internal.view.UpdateNetworkViewTaskFactory;
import org.cytoscape.task.internal.vizmap.ApplyVisualStyleTaskFactoryimpl;
import org.cytoscape.task.internal.vizmap.ClearAllEdgeBendsFactory;
import org.cytoscape.task.internal.vizmap.ExportVizmapTaskFactoryImpl;
import org.cytoscape.task.internal.vizmap.LoadVizmapFileTaskFactoryImpl;
import org.cytoscape.task.internal.zoom.FitContentTaskFactory;
import org.cytoscape.task.internal.zoom.FitSelectedTaskFactory;
import org.cytoscape.task.internal.zoom.ZoomInTaskFactory;
import org.cytoscape.task.internal.zoom.ZoomOutTaskFactory;
import org.cytoscape.task.read.LoadMultipleNetworkFilesTaskFactory;
import org.cytoscape.task.read.LoadNetworkFileTaskFactory;
import org.cytoscape.task.read.LoadNetworkURLTaskFactory;
import org.cytoscape.task.read.LoadVizmapFileTaskFactory;
import org.cytoscape.task.read.OpenSessionTaskFactory;
import org.cytoscape.task.select.DeselectAllEdgesTaskFactory;
import org.cytoscape.task.select.DeselectAllNodesTaskFactory;
import org.cytoscape.task.select.DeselectAllTaskFactory;
import org.cytoscape.task.select.InvertSelectedEdgesTaskFactory;
import org.cytoscape.task.select.InvertSelectedNodesTaskFactory;
import org.cytoscape.task.select.SelectAdjacentEdgesTaskFactory;
import org.cytoscape.task.select.SelectAllEdgesTaskFactory;
import org.cytoscape.task.select.SelectAllNodesTaskFactory;
import org.cytoscape.task.select.SelectAllTaskFactory;
import org.cytoscape.task.select.SelectConnectedNodesTaskFactory;
import org.cytoscape.task.select.SelectFirstNeighborsNodeViewTaskFactory;
import org.cytoscape.task.select.SelectFirstNeighborsTaskFactory;
import org.cytoscape.task.select.SelectFromFileListTaskFactory;
import org.cytoscape.task.visualize.ApplyPreferredLayoutTaskFactory;
import org.cytoscape.task.visualize.ApplyVisualStyleTaskFactory;
import org.cytoscape.task.write.ExportNetworkImageTaskFactory;
import org.cytoscape.task.write.ExportNetworkTaskFactory;
import org.cytoscape.task.write.ExportNetworkViewTaskFactory;
import org.cytoscape.task.write.ExportSelectedNetworkTaskFactory;
import org.cytoscape.task.write.ExportSelectedTableTaskFactory;
import org.cytoscape.task.write.ExportTableTaskFactory;
import org.cytoscape.task.write.ExportVizmapTaskFactory;
import org.cytoscape.task.write.SaveSessionAsTaskFactory;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TunableSetter;
import org.osgi.framework.BundleContext;

public class CyActivator
extends AbstractCyActivator {
    private static float LARGE_ICON_FONT_SIZE = 32.0f;
    private static int LARGE_ICON_SIZE = 32;
    private static float SMALL_ICON_FONT_SIZE = 14.0f;
    private static int SMALL_ICON_SIZE = 16;
    private Font iconFont;
    private CyServiceRegistrar serviceRegistrar;
    private CyNetworkViewWriterManager netViewWriterManager;
    private CyNetworkManager netManager;
    private CyApplicationManager applicationManager;
    private CyTableManager tableManager;
    private CyLayoutAlgorithmManager layoutAlgManager;
    private TunableSetter tunableSetter;
    private IconManager iconManager;

    public void start(BundleContext bc) {
        this.serviceRegistrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        this.netViewWriterManager = (CyNetworkViewWriterManager)this.getService(bc, CyNetworkViewWriterManager.class);
        this.netManager = (CyNetworkManager)this.getService(bc, CyNetworkManager.class);
        this.applicationManager = (CyApplicationManager)this.getService(bc, CyApplicationManager.class);
        this.tableManager = (CyTableManager)this.getService(bc, CyTableManager.class);
        this.layoutAlgManager = (CyLayoutAlgorithmManager)this.getService(bc, CyLayoutAlgorithmManager.class);
        this.tunableSetter = (TunableSetter)this.getService(bc, TunableSetter.class);
        this.iconManager = (IconManager)this.getService(bc, IconManager.class);
        CyGroupManager groupManager = (CyGroupManager)this.getService(bc, CyGroupManager.class);
        CyGroupFactory groupFactory = (CyGroupFactory)this.getService(bc, CyGroupFactory.class);
        this.iconFont = this.iconManager.getIconFont("cytoscape-3", LARGE_ICON_FONT_SIZE);
        DynamicTaskFactoryProvisionerImpl factory = new DynamicTaskFactoryProvisionerImpl(this.serviceRegistrar);
        this.registerAllServices(bc, factory);
        this.createPreferencesTaskFactories(bc);
        this.createFilterTaskFactories(bc);
        this.createTableTaskFactories(bc);
        this.createNetworkTaskFactories(bc, groupManager, groupFactory);
        this.createViewTaskFactories(bc);
        this.createVizmapTaskFactories(bc);
        this.createSessionTaskFactories(bc);
        this.createGroupTaskFactories(bc, groupManager, groupFactory);
        this.createNodeEdgeTaskFactories(bc);
        this.createLayoutTaskFactories(bc);
        this.createHelpTaskFactories(bc);
    }

    private void createPreferencesTaskFactories(BundleContext bc) {
        ProxySettingsTaskFactoryImpl factory = new ProxySettingsTaskFactoryImpl(this.serviceRegistrar);
        Properties props = new Properties();
        props.setProperty("preferredMenu", "Edit.Preferences");
        props.setProperty("menuGravity", "3.0");
        props.setProperty("title", "Proxy Settings...");
        this.registerService(bc, (Object)factory, TaskFactory.class, props);
    }

    private void createFilterTaskFactories(BundleContext bc) {
        String createLongDescription;
        try {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("create_filter_long_description.md");
            createLongDescription = new BufferedReader(new InputStreamReader(in)).lines().collect(Collectors.joining("\n"));
        }
        catch (Exception e) {
            createLongDescription = "Create a filter by suppling a name and a JSON filter expression.";
        }
        Properties props = new Properties();
        props.setProperty("command", "create");
        props.setProperty("commandNamespace", "filter");
        props.setProperty("commandDescription", "Create a filter.");
        props.setProperty("commandLongDescription", createLongDescription);
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ }");
        this.registerService(bc, (Object)new CreateFilterTaskFactory(this.serviceRegistrar), TaskFactory.class, props);
        props = new Properties();
        props.setProperty("command", "select");
        props.setProperty("commandNamespace", "filter");
        props.setProperty("commandDescription", "Select nodes and edges using a JSON filter expression.");
        props.setProperty("commandLongDescription", "See the documentation for 'filter create' for details on the accepted JSON format.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ }");
        this.registerService(bc, (Object)new SelectFilterTaskFactory(this.serviceRegistrar), TaskFactory.class, props);
        props = new Properties();
        props.setProperty("command", "apply");
        props.setProperty("commandNamespace", "filter");
        props.setProperty("commandDescription", "Select nodes and edges by running a filter.");
        props.setProperty("commandLongDescription", "Run an existing filter by supplying the filter name.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ }");
        this.registerService(bc, (Object)new ApplyFilterTaskFactory(this.serviceRegistrar), TaskFactory.class, props);
        props = new Properties();
        props.setProperty("command", "delete");
        props.setProperty("commandNamespace", "filter");
        props.setProperty("commandDescription", "Delete a filter.");
        props.setProperty("commandLongDescription", "Delete an existing filter by supplying the filter name.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ }");
        this.registerService(bc, (Object)new DeleteFilterTaskFactory(this.serviceRegistrar), TaskFactory.class, props);
        props = new Properties();
        props.setProperty("command", "rename");
        props.setProperty("commandNamespace", "filter");
        props.setProperty("commandDescription", "Rename a filter.");
        props.setProperty("commandLongDescription", "Rename an existing filter by supplying the filter name and a new name.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ }");
        this.registerService(bc, (Object)new RenameFilterTaskFactory(this.serviceRegistrar), TaskFactory.class, props);
        props = new Properties();
        props.setProperty("command", "list");
        props.setProperty("commandNamespace", "filter");
        props.setProperty("commandDescription", "List filters.");
        props.setProperty("commandLongDescription", "Returns a list of current filter names.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ }");
        this.registerService(bc, (Object)new ListFiltersTaskFactory(this.serviceRegistrar), TaskFactory.class, props);
        props = new Properties();
        props.setProperty("command", "get");
        props.setProperty("commandNamespace", "filter");
        props.setProperty("commandDescription", "Returns the JSON representation of a filter.");
        props.setProperty("commandLongDescription", "Returns the JSON representation of a filter.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ }");
        this.registerService(bc, (Object)new GetFilterTaskFactory(this.serviceRegistrar), TaskFactory.class, props);
    }

    private void createLayoutTaskFactories(BundleContext bc) {
        Object factory = new ApplyPreferredLayoutTaskFactoryImpl(this.serviceRegistrar);
        TextIcon icon = new TextIcon("a", this.iconFont, IconUtil.C1, LARGE_ICON_SIZE, LARGE_ICON_SIZE);
        String iconId = "cy::APPLY_LAYOUT";
        this.iconManager.addIcon(iconId, (Icon)icon);
        Properties props = new Properties();
        props.setProperty("preferredMenu", "Layout");
        props.setProperty("accelerator", "fn5");
        props.setProperty("largeIconID", iconId);
        props.setProperty("enableFor", "networkAndView");
        props.setProperty("title", "Apply Preferred Layout");
        props.setProperty("toolBarGravity", "7.0");
        props.setProperty("inToolBar", "true");
        props.setProperty("menuGravity", "5.0");
        props.setProperty("tooltip", "Apply Preferred Layout");
        props.setProperty("tooltipLongDescription", "Applies the preferred layout to the selected views.");
        props.setProperty("tooltipImage", ((Object)((Object)this)).getClass().getResource("/images/tooltips/apply-preferred-layout.gif").toString());
        this.registerService(bc, factory, NetworkViewCollectionTaskFactory.class, props);
        this.registerService(bc, factory, ApplyPreferredLayoutTaskFactory.class, props);
        props = new Properties();
        props.setProperty("command", "apply preferred");
        props.setProperty("commandNamespace", "layout");
        props.setProperty("commandDescription", "Execute the preferred layout on a network");
        props.setProperty("commandLongDescription", "Executes the current preferred layout. Default is ```grid```.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ }");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new GetPreferredLayoutTaskFactory(this.serviceRegistrar);
        Properties props2 = new Properties();
        props2.setProperty("command", "get preferred");
        props2.setProperty("commandNamespace", "layout");
        props2.setProperty("commandDescription", "Return the current preferred layout");
        props2.setProperty("commandLongDescription", "Returns the name of the current preferred layout or empty string if not set. Default is ```grid```.");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "\"grid\"");
        this.registerService(bc, factory, TaskFactory.class, props2);
        factory = new SetPreferredLayoutTaskFactory(this.serviceRegistrar);
        props2 = new Properties();
        props2.setProperty("command", "set preferred");
        props2.setProperty("commandNamespace", "layout");
        props2.setProperty("commandDescription", "Set the preferred layout");
        props2.setProperty("commandLongDescription", "Sets the preferred layout. Takes a specific name as defined in the API Default is ```grid```.");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "{ }");
        this.registerService(bc, factory, TaskFactory.class, props2);
    }

    private void createViewTaskFactories(BundleContext bc) {
        Object factory = new ExportNetworkViewTaskFactoryImpl(this.netViewWriterManager, this.applicationManager, this.tunableSetter);
        Properties props = new Properties();
        props.setProperty("id", "exportNetworkViewTaskFactory");
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props);
        this.registerService(bc, factory, ExportNetworkViewTaskFactory.class, props);
        factory = new CreateNetworkViewTaskFactoryImpl(this.netManager, this.layoutAlgManager, this.applicationManager, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("id", "createNetworkViewTaskFactory");
        props.setProperty("preferredMenu", "Edit");
        props.setProperty("title", "Create Views");
        props.setProperty("menuGravity", "3.0");
        this.registerService(bc, factory, NetworkCollectionTaskFactory.class, props);
        this.registerService(bc, factory, CreateNetworkViewTaskFactory.class, props);
        props = new Properties();
        props.setProperty("id", "createNetworkViewTaskFactory");
        props.setProperty("command", "create");
        props.setProperty("commandNamespace", "view");
        props.setProperty("commandDescription", "Create a new view for a network");
        props.setProperty("commandLongDescription", "Creates a new view for the passed network and returns the SUID of the new view and the original network. If no networks are specified, it creates a view for the current network, if there is one.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"network\":101,\"view\":400}");
        this.registerService(bc, factory, TaskFactory.class, props);
        this.registerServiceListener(bc, ((CreateNetworkViewTaskFactoryImpl)((Object)factory))::addNetworkViewRenderer, ((CreateNetworkViewTaskFactoryImpl)((Object)factory))::removeNetworkViewRenderer, NetworkViewRenderer.class);
        factory = new DestroyNetworkViewTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("preferredMenu", "Edit");
        props.setProperty("title", "Destroy Views");
        props.setProperty("menuGravity", "3.1");
        props.setProperty("enableFor", "networkAndView");
        props.setProperty("command", "destroy");
        props.setProperty("commandNamespace", "view");
        props.setProperty("commandDescription", "Destroy the selected network views");
        props.setProperty("commandLongDescription", "Destroys all selected network views and returns their SUIDs. If no views are selected, this command does nothing.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"views\":[ 343, 521, 770 ]}");
        this.registerService(bc, factory, NetworkViewCollectionTaskFactory.class, props);
        this.registerService(bc, factory, DestroyNetworkViewTaskFactory.class, props);
        factory = new ExportNetworkImageTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("preferredMenu", "File.Export[24.8]");
        props.setProperty("enableFor", "networkAndView");
        props.setProperty("menuGravity", "3");
        props.setProperty("title", "Network to Image...");
        props.setProperty("inContextMenu", "false");
        props.setProperty("tooltip", "Export Network Image to File");
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props);
        this.registerService(bc, factory, ExportNetworkImageTaskFactory.class, props);
        props = new Properties();
        props.setProperty("enableFor", "networkAndView");
        props.setProperty("command", "export");
        props.setProperty("commandNamespace", "view");
        props.setProperty("commandDescription", "Export the current view to a graphics file");
        props.setProperty("commandLongDescription", "Exports the current view to a graphics file and returns the path to the saved file. PNG and JPEG formats have options for scaling, while other formats only have the option 'exportTextAsFont'. For the PDF format, exporting text as font does not work for two-byte characters such as Chinese or Japanese. To avoid corrupted texts in the exported PDF, please set false to 'exportTextAsFont' when exporting networks including those non-English characters.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ \"file\": \"/Users/johndoe/Documents/MyNetwork.pdf\" }");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new ExportAsWebArchiveTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("preferredMenu", "File.Export[24.8]");
        props.setProperty("enableFor", "networkAndView");
        props.setProperty("menuGravity", "4");
        props.setProperty("title", "Network to Web Page...");
        this.registerAllServices(bc, factory, props);
        this.registerServiceListener(bc, ((ExportAsWebArchiveTaskFactory)((Object)factory))::registerFactory, ((ExportAsWebArchiveTaskFactory)((Object)factory))::unregisterFactory, CySessionWriterFactory.class);
        factory = new ZoomInTaskFactory(this.serviceRegistrar);
        TextIcon icon = new TextIcon(IconUtil.LAYERED_ZOOM_IN, this.iconFont, IconUtil.COLORS_3, LARGE_ICON_SIZE, LARGE_ICON_SIZE, new Integer[]{1});
        String iconId = "cy::LAYERED_ZOOM_IN";
        this.iconManager.addIcon(iconId, (Icon)icon);
        Properties props2 = new Properties();
        props2.setProperty("preferredMenu", "View");
        props2.setProperty("title", "Zoom In");
        props2.setProperty("menuGravity", "6.3");
        props2.setProperty("accelerator", "cmd equals");
        props2.setProperty("largeIconID", iconId);
        props2.setProperty("enableFor", "networkAndView");
        props2.setProperty("tooltip", "Zoom In");
        props2.setProperty("tooltipLongDescription", "Zooms in the current view.");
        props2.setProperty("tooltipImage", ((Object)((Object)this)).getClass().getResource("/images/tooltips/zoom-in.gif").toString());
        props2.setProperty("toolBarGravity", "5.1");
        props2.setProperty("inToolBar", "true");
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props2);
        factory = new ZoomOutTaskFactory(this.serviceRegistrar);
        icon = new TextIcon(IconUtil.LAYERED_ZOOM_OUT, this.iconFont, IconUtil.COLORS_3, LARGE_ICON_SIZE, LARGE_ICON_SIZE, new Integer[]{1});
        iconId = "cy::LAYERED_ZOOM_OUT";
        this.iconManager.addIcon(iconId, (Icon)icon);
        props2 = new Properties();
        props2.setProperty("preferredMenu", "View");
        props2.setProperty("title", "Zoom Out");
        props2.setProperty("tooltip", "Zoom Out");
        props2.setProperty("tooltipLongDescription", "Zooms out the current view.");
        props2.setProperty("tooltipImage", ((Object)((Object)this)).getClass().getResource("/images/tooltips/zoom-out.gif").toString());
        props2.setProperty("menuGravity", "6.4");
        props2.setProperty("insertSeparatorAfter", "true");
        props2.setProperty("accelerator", "cmd minus");
        props2.setProperty("largeIconID", iconId);
        props2.setProperty("enableFor", "networkAndView");
        props2.setProperty("toolBarGravity", "5.2");
        props2.setProperty("inToolBar", "true");
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props2);
        factory = new FitSelectedTaskFactory(this.serviceRegistrar);
        icon = new TextIcon(IconUtil.LAYERED_ZOOM_SEL, this.iconFont, IconUtil.COLORS_3, LARGE_ICON_SIZE, LARGE_ICON_SIZE, new Integer[]{1});
        iconId = "cy::LAYERED_ZOOM_SELECTED";
        this.iconManager.addIcon(iconId, (Icon)icon);
        props2 = new Properties();
        props2.setProperty("preferredMenu", "View");
        props2.setProperty("title", "Fit Selected");
        props2.setProperty("tooltip", "Fit Selected");
        props2.setProperty("tooltipLongDescription", "Changes the current view's zoom and viewport so the selected nodes and edges fit into the displayed view area.");
        props2.setProperty("tooltipImage", ((Object)((Object)this)).getClass().getResource("/images/tooltips/fit-selected.gif").toString());
        props2.setProperty("menuGravity", "6.2");
        props2.setProperty("accelerator", "cmd 9");
        props2.setProperty("largeIconID", iconId);
        props2.setProperty("enableFor", "selectedNodesOrEdges");
        props2.setProperty("toolBarGravity", "5.4");
        props2.setProperty("inToolBar", "true");
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props2);
        props2 = new Properties();
        props2.setProperty("command", "fit selected");
        props2.setProperty("commandNamespace", "view");
        props2.setProperty("commandDescription", "Fit the selected nodes and edges into the view");
        props2.setProperty("commandLongDescription", "Changes the current view's zoom and viewport so the selected nodes and edges fit into the view area.");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "{ }");
        this.registerService(bc, factory, TaskFactory.class, props2);
        factory = new FitContentTaskFactory(this.serviceRegistrar);
        icon = new TextIcon(IconUtil.LAYERED_ZOOM_FIT, this.iconFont, IconUtil.COLORS_3, LARGE_ICON_SIZE, LARGE_ICON_SIZE, new Integer[]{1});
        iconId = "cy::LAYERED_ZOOM_FIT";
        this.iconManager.addIcon(iconId, (Icon)icon);
        props2 = new Properties();
        props2.setProperty("preferredMenu", "View");
        props2.setProperty("title", "Fit Content");
        props2.setProperty("tooltip", "Fit Content");
        props2.setProperty("tooltipLongDescription", "Zooms out the current view in order to display all of its elements.");
        props2.setProperty("tooltipImage", ((Object)((Object)this)).getClass().getResource("/images/tooltips/fit-content.gif").toString());
        props2.setProperty("menuGravity", "6.1");
        props2.setProperty("accelerator", "cmd 0");
        props2.setProperty("largeIconID", iconId);
        props2.setProperty("enableFor", "networkAndView");
        props2.setProperty("toolBarGravity", "5.3");
        props2.setProperty("inToolBar", "true");
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props2);
        props2 = new Properties();
        props2.setProperty("command", "fit content");
        props2.setProperty("commandNamespace", "view");
        props2.setProperty("commandDescription", "Fit all of the nodes and edges into the view");
        props2.setProperty("commandLongDescription", "Zooms out the current view in order to display all of its elements.");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "{ }");
        this.registerService(bc, factory, TaskFactory.class, props2);
        factory = new GetCurrentNetworkViewTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "get current");
        props.setProperty("commandNamespace", "view");
        props.setProperty("commandDescription", "Get the current view");
        props.setProperty("commandLongDescription", "Returns the current view or null if there is none.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"view\": 136}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new ListNetworkViewsTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "list");
        props.setProperty("commandNamespace", "view");
        props.setProperty("commandDescription", "List views");
        props.setProperty("commandLongDescription", "Returns a list with the passed network's views or an empty list if there are no views. If a network is not specified, it assumes the current network.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"views\":[ 90, 136 ]}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new SetCurrentNetworkViewTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "set current");
        props.setProperty("commandNamespace", "view");
        props.setProperty("commandDescription", "Set the current view");
        props.setProperty("commandLongDescription", "Sets the current view, which can also be null.  Note that this command takes both ```view``` and ```network``` as arguments.  If both are provided, the ```view``` argument takes precedence.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ }");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new UpdateNetworkViewTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "update");
        props.setProperty("commandNamespace", "view");
        props.setProperty("commandDescription", "Update (repaint) a view");
        props.setProperty("commandLongDescription", "Updates and repaints all views of the specified network.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ }");
        this.registerService(bc, factory, TaskFactory.class, props);
    }

    private void createNodeEdgeTaskFactories(BundleContext bc) {
        Object factory = new DeleteSelectedNodesAndEdgesTaskFactoryImpl(this.serviceRegistrar);
        Properties props = new Properties();
        props.setProperty("preferredMenu", "Edit");
        props.setProperty("enableFor", "selectedNodesOrEdges");
        props.setProperty("title", "Remove Selected Nodes and Edges");
        props.setProperty("menuGravity", "5.0");
        props.setProperty("accelerator", "DELETE");
        props.setProperty("command", "delete");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Delete nodes or edges from a network");
        props.setProperty("commandLongDescription", "Deletes nodes and edges provided by the arguments, or if no nodes or edges are provides, the selected nodes and edges.  When deleting nodes, adjacent edges are also deleted.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"nodes\":[101,102,103], \"edges\":[201,202]}");
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        this.registerService(bc, factory, DeleteSelectedNodesAndEdgesTaskFactory.class, props);
        factory = new SelectAllEdgesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("preferredMenu", "Select.Edges[3]");
        props.setProperty("accelerator", "alt e");
        props.setProperty("enableFor", "network");
        props.setProperty("title", "Select All Edges");
        props.setProperty("menuGravity", "4");
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        this.registerService(bc, factory, SelectAllEdgesTaskFactory.class, props);
        factory = new SelectAllNodesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "network");
        props.setProperty("preferredMenu", "Select.Nodes[2]");
        props.setProperty("menuGravity", "4");
        props.setProperty("accelerator", "alt n");
        props.setProperty("title", "Select All Nodes");
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        this.registerService(bc, factory, SelectAllNodesTaskFactory.class, props);
        factory = new SelectAdjacentEdgesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "network");
        props.setProperty("preferredMenu", "Select.Edges[3]");
        props.setProperty("menuGravity", "6");
        props.setProperty("accelerator", "cmd alt e");
        props.setProperty("title", "Select Adjacent Edges");
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        this.registerService(bc, factory, SelectAdjacentEdgesTaskFactory.class, props);
        factory = new SelectConnectedNodesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "network");
        props.setProperty("preferredMenu", "Select.Nodes[2]");
        props.setProperty("menuGravity", "7");
        props.setProperty("accelerator", "cmd alt n");
        props.setProperty("title", "Nodes Connected by Selected Edges");
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        this.registerService(bc, factory, SelectConnectedNodesTaskFactory.class, props);
        factory = new SelectFirstNeighborsTaskFactoryImpl(CyEdge.Type.ANY, this.serviceRegistrar);
        TextIcon icon = new TextIcon("f", this.iconFont, IconUtil.C1, LARGE_ICON_SIZE, LARGE_ICON_SIZE);
        String iconId = "cy::FIRST_NEIGHBORS";
        this.iconManager.addIcon(iconId, (Icon)icon);
        Properties props2 = new Properties();
        props2.setProperty("enableFor", "selectedNodesOrEdges");
        props2.setProperty("preferredMenu", "Select.Nodes.First Neighbors of Selected Nodes");
        props2.setProperty("menuGravity", "6");
        props2.setProperty("toolBarGravity", "9.15");
        props2.setProperty("accelerator", "cmd 6");
        props2.setProperty("title", "Undirected");
        props2.setProperty("largeIconID", iconId);
        props2.setProperty("inToolBar", "true");
        props2.setProperty("tooltip", "First Neighbors of Selected Nodes (Undirected)");
        props2.setProperty("tooltipLongDescription", "Selects the first neighbors of the current network's selected nodes (undirected).");
        props2.setProperty("tooltipImage", ((Object)((Object)this)).getClass().getResource("/images/tooltips/first-neighbors.gif").toString());
        this.registerService(bc, factory, NetworkTaskFactory.class, props2);
        this.registerService(bc, factory, SelectFirstNeighborsTaskFactory.class, props2);
        factory = new SelectFirstNeighborsTaskFactoryImpl(CyEdge.Type.INCOMING, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "network");
        props.setProperty("preferredMenu", "Select.Nodes.First Neighbors of Selected Nodes");
        props.setProperty("menuGravity", "0.11");
        props.setProperty("title", "Directed: Incoming");
        props.setProperty("tooltip", "First Neighbors of Selected Nodes (Directed: Incoming)");
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        this.registerService(bc, factory, SelectFirstNeighborsTaskFactory.class, props);
        factory = new SelectFirstNeighborsTaskFactoryImpl(CyEdge.Type.OUTGOING, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "network");
        props.setProperty("preferredMenu", "Select.Nodes.First Neighbors of Selected Nodes");
        props.setProperty("menuGravity", "6.2");
        props.setProperty("title", "Directed: Outgoing");
        props.setProperty("tooltip", "First Neighbors of Selected Nodes (Directed: Outgoing)");
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        this.registerService(bc, factory, SelectFirstNeighborsTaskFactory.class, props);
        factory = new DeselectAllEdgesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "network");
        props.setProperty("preferredMenu", "Select.Edges[3]");
        props.setProperty("menuGravity", "5");
        props.setProperty("accelerator", "alt shift e");
        props.setProperty("title", "Deselect All Edges");
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        this.registerService(bc, factory, DeselectAllEdgesTaskFactory.class, props);
        factory = new DeselectAllNodesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "network");
        props.setProperty("preferredMenu", "Select.Nodes[2]");
        props.setProperty("menuGravity", "5.0");
        props.setProperty("accelerator", "alt shift n");
        props.setProperty("title", "Deselect All Nodes");
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        this.registerService(bc, factory, DeselectAllNodesTaskFactory.class, props);
        factory = new InvertSelectedEdgesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "network");
        props.setProperty("preferredMenu", "Select.Edges[3]");
        props.setProperty("menuGravity", "1.0");
        props.setProperty("accelerator", "alt i");
        props.setProperty("title", "Invert Edge Selection");
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        this.registerService(bc, factory, InvertSelectedEdgesTaskFactory.class, props);
        factory = new InvertSelectedNodesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "selectedNodes");
        props.setProperty("preferredMenu", "Select.Nodes[2]");
        props.setProperty("menuGravity", "1.0");
        props.setProperty("toolBarGravity", "9.2");
        props.setProperty("accelerator", "cmd i");
        props.setProperty("title", "Invert Node Selection");
        props.setProperty("inToolBar", "false");
        props.setProperty("tooltip", "Invert Node Selection");
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        this.registerService(bc, factory, InvertSelectedNodesTaskFactory.class, props);
        factory = new SelectFromFileListTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "network");
        props.setProperty("preferredMenu", "Select.Nodes[2]");
        props.setProperty("menuGravity", "8");
        props.setProperty("accelerator", "cmd alt i");
        props.setProperty("title", "From ID List File...");
        props.setProperty("commandNamespace", "node");
        props.setProperty("command", "select from file");
        props.setProperty("commandDescription", "Select nodes from a file");
        props.setProperty("commandLongDescription", "Selects nodes in the current network based on node names provided by a file.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "true");
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        this.registerService(bc, factory, SelectFromFileListTaskFactory.class, props);
        factory = new SelectFirstNeighborsNodeViewTaskFactoryImpl(CyEdge.Type.ANY, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("preferredMenu", "Select[-1090]");
        props.setProperty("menuGravity", "1.0");
        props.setProperty("title", "Select First Neighbors (Undirected)");
        this.registerService(bc, factory, NodeViewTaskFactory.class, props);
        this.registerService(bc, factory, SelectFirstNeighborsNodeViewTaskFactory.class, props);
        factory = new SelectAllTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("preferredMenu", "Select");
        props.setProperty("accelerator", "cmd a");
        props.setProperty("enableFor", "network");
        props.setProperty("title", "Select All");
        props.setProperty("tooltip", "Select all nodes, edges and annotations");
        props.setProperty("menuGravity", "5.2");
        props.setProperty("insertSeparatorBefore", "true");
        props.setProperty("preferredAction", "NEW");
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        this.registerService(bc, factory, SelectAllTaskFactory.class, props);
        props = new Properties();
        props.setProperty("preferredMenu", "Select[-1070]");
        props.setProperty("enableFor", "networkAndView");
        props.setProperty("title", "All Nodes and Edges");
        props.setProperty("menuGravity", "1.1");
        props.setProperty("preferredAction", "NEW");
        props.setProperty("inMenuBar", "false");
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props);
        factory = new DeselectAllTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "network");
        props.setProperty("preferredMenu", "Select");
        props.setProperty("menuGravity", "5.2");
        props.setProperty("accelerator", "cmd shift a");
        props.setProperty("title", "Deselect All");
        props.setProperty("tooltip", "Deselect all nodes, edges and annotations");
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        this.registerService(bc, factory, DeselectAllTaskFactory.class, props);
        factory = new UnHideAllTaskFactoryImpl(this.serviceRegistrar);
        icon = new TextIcon(IconUtil.LAYERED_SHOW_ALL, this.iconFont, IconUtil.COLORS_2A, LARGE_ICON_SIZE, LARGE_ICON_SIZE, new Integer[]{1});
        iconId = "cy::SHOW_ALL";
        this.iconManager.addIcon(iconId, (Icon)icon);
        props2 = new Properties();
        props2.setProperty("enableFor", "networkAndView");
        props2.setProperty("preferredMenu", "Select");
        props2.setProperty("menuGravity", "4.10");
        props2.setProperty("toolBarGravity", "9.6");
        props2.setProperty("title", factory.getDescription());
        props2.setProperty("largeIconID", iconId);
        props2.setProperty("inToolBar", "true");
        props2.setProperty("tooltip", factory.getDescription());
        props2.setProperty("tooltipLongDescription", "Unhides the current view's hidden nodes and edges.");
        props2.setProperty("tooltipImage", ((Object)((Object)this)).getClass().getResource("/images/tooltips/show-hide.gif").toString());
        props2.setProperty("insertSeparatorBefore", "true");
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props2);
        this.registerService(bc, factory, UnHideAllTaskFactory.class, props2);
        factory = new HideSelectedTaskFactoryImpl(this.serviceRegistrar);
        icon = new TextIcon(IconUtil.LAYERED_HIDE_SELECTED, this.iconFont, IconUtil.COLORS_3, LARGE_ICON_SIZE, LARGE_ICON_SIZE, new Integer[]{1});
        iconId = "cy::HIDE_SELECTED";
        this.iconManager.addIcon(iconId, (Icon)icon);
        props2 = new Properties();
        props2.setProperty("enableFor", "selectedNodesOrEdges");
        props2.setProperty("preferredMenu", "Select");
        props2.setProperty("menuGravity", "4.11");
        props2.setProperty("toolBarGravity", "9.5");
        props2.setProperty("title", factory.getDescription());
        props2.setProperty("largeIconID", iconId);
        props2.setProperty("inToolBar", "true");
        props2.setProperty("tooltip", factory.getDescription());
        props2.setProperty("tooltipLongDescription", "Hides the current view's selected nodes and edges.");
        props2.setProperty("tooltipImage", ((Object)((Object)this)).getClass().getResource("/images/tooltips/show-hide.gif").toString());
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props2);
        this.registerService(bc, factory, HideSelectedTaskFactory.class, props2);
        factory = new HideUnselectedTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("preferredMenu", "Select");
        props.setProperty("menuGravity", "4.2");
        props.setProperty("title", factory.getDescription());
        props.setProperty("tooltip", factory.getDescription());
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props);
        this.registerService(bc, factory, HideUnselectedTaskFactory.class, props);
        factory = new HideSelectedNodesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "selectedNodes");
        props.setProperty("preferredMenu", "Select.Nodes[2]");
        props.setProperty("menuGravity", "2");
        props.setProperty("title", factory.getDescription());
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props);
        this.registerService(bc, factory, HideSelectedNodesTaskFactory.class, props);
        factory = new HideUnselectedNodesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("preferredMenu", "Select.Nodes[2]");
        props.setProperty("menuGravity", "2.1");
        props.setProperty("title", factory.getDescription());
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props);
        this.registerService(bc, factory, HideUnselectedNodesTaskFactory.class, props);
        factory = new HideSelectedEdgesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "selectedEdges");
        props.setProperty("preferredMenu", "Select.Edges[3]");
        props.setProperty("menuGravity", "2");
        props.setProperty("title", factory.getDescription());
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props);
        this.registerService(bc, factory, HideSelectedEdgesTaskFactory.class, props);
        factory = new HideUnselectedEdgesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("preferredMenu", "Select.Edges[3]");
        props.setProperty("menuGravity", "2.1");
        props.setProperty("title", factory.getDescription());
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props);
        this.registerService(bc, factory, HideUnselectedEdgesTaskFactory.class, props);
        factory = new UnHideAllNodesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "networkAndView");
        props.setProperty("preferredMenu", "Select.Nodes[2]");
        props.setProperty("menuGravity", "3.0");
        props.setProperty("title", factory.getDescription());
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props);
        this.registerService(bc, factory, UnHideAllNodesTaskFactory.class, props);
        factory = new UnHideAllEdgesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "networkAndView");
        props.setProperty("preferredMenu", "Select.Edges[3]");
        props.setProperty("menuGravity", "3");
        props.setProperty("title", factory.getDescription());
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props);
        this.registerService(bc, factory, UnHideAllEdgesTaskFactory.class, props);
        factory = new UnHideSelectedNodesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "networkAndView");
        props.setProperty("preferredMenu", "Select.Nodes[2]");
        props.setProperty("menuGravity", "3.0");
        props.setProperty("title", factory.getDescription());
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props);
        this.registerService(bc, factory, UnHideSelectedNodesTaskFactory.class, props);
        factory = new UnHideSelectedEdgesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "networkAndView");
        props.setProperty("preferredMenu", "Select.Edges[3]");
        props.setProperty("menuGravity", "3");
        props.setProperty("title", factory.getDescription());
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props);
        this.registerService(bc, factory, UnHideSelectedEdgesTaskFactory.class, props);
        factory = new HideTaskFactoryImpl(this.serviceRegistrar);
        this.registerService(bc, factory, HideTaskFactory.class);
        factory = new UnHideTaskFactoryImpl(this.serviceRegistrar);
        this.registerService(bc, factory, UnHideTaskFactory.class);
        factory = new AddTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "add");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Add nodes and edges to a network (they must be in the current collection)");
        props.setProperty("commandLongDescription", "Adds nodes and edges to an existing network.  The nodes and edges to be added must already exist in the network collection.  This command is most often used to populate a subnetwork with selected nodes and edges from a parent network.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"nodes\":[101,102,103],\"edges\":[201,202,203]}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new AddEdgeTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "add edge");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Add an edge between two nodes");
        props.setProperty("commandLongDescription", "Add a new edge between two existing nodes in a network.  The names of the nodes must be specified and much match the value in the 'name' column for each node");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"edge\":101}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new AddNodeTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "add node");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Add a new node to a network");
        props.setProperty("commandLongDescription", "Add a new node to an existing network.  The name of the node must be provided.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"node\":101}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new SelectTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "select");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Select nodes or edges in a network");
        props.setProperty("commandLongDescription", "Select nodes and/or edges in a network.  This command provides options to invert the selection, add first neighbors, add adjacent edges of selected nodes, and add adjacent nodes of selected edges");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"nodes\": [101,122,495], \"edges\": [201,202,203]}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new DeselectTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "deselect");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Deselect nodes or edges in a network");
        props.setProperty("commandLongDescription", "Deselect nodes and/or edges in a network.  A list of nodes and/or edges may be provided and those nodes and edges will be deselected.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"nodes\": [101,122,495], \"edges\": [201,202,203]}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new HideCommandTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "hide");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Hide nodes or edges in a network");
        props.setProperty("commandLongDescription", "Hide nodes and/or edges in a network.  A list of nodes and/or edges may be provided and those nodes and edges will be hidden in the view associated with the provided network.Note that the network '''must''' have a view.  The SUIDs of the hidden nodes and/or edges are returned.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"nodes\": [101,122,495], \"edges\": [201,202,203]}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new UnHideCommandTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "show");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Show hidden nodes and edges");
        props.setProperty("commandLongDescription", "Show nodes and/or edges in a network.  A list of nodes and/or edges may be provided and those nodes and edges will be unhidden in the view associated with the provided network.Note that the network '''must''' have a view.  The SUIDs of the unhidden nodes and/or edges are returned.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"nodes\": [101,122,495], \"edges\": [201,202,203]}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new CreateNetworkAttributeTaskFactory(CyNode.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "create attribute");
        props.setProperty("commandNamespace", "node");
        props.setProperty("commandDescription", "Create a new column for nodes");
        props.setProperty("commandLongDescription", "Creates a new node column.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ \"columnName\": \"New Column\" }");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new GetNodeTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "get");
        props.setProperty("commandNamespace", "node");
        props.setProperty("commandDescription", "Get a node from a network");
        props.setProperty("commandLongDescription", "Returns the SUID of a node that matches the passed parameters. If multiple nodes are found, only one will be returned, and a warning will be printed.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"node\":101}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new GetNetworkAttributeTaskFactory(CyNode.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "get attribute");
        props.setProperty("commandNamespace", "node");
        props.setProperty("commandDescription", "Get values from the node table");
        props.setProperty("commandLongDescription", "Returns the attributes for the nodes passed as parameters.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "[  { \"name\": \"Object 1\", \"SUID\": 101 },   { \"name\": \"Object 2\", \"SUID\": 102 }]");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new GetPropertiesTaskFactory(CyNode.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "get properties");
        props.setProperty("commandNamespace", "node");
        props.setProperty("commandDescription", "Get visual properties for a node");
        props.setProperty("commandLongDescription", "Returns the visual properties for the nodes that match the passed parameters.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "[ {\"SUID\": 92,\"visualProperties\": [{\"visualProperty\": \"NODE_PAINT\",\"value\": \"#808080\"},{\"visualProperty\": \"NODE_VISIBLE\",\"value\": true}]}]");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new ListNodesTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "list");
        props.setProperty("commandNamespace", "node");
        props.setProperty("commandDescription", "List all of the nodes in a network");
        props.setProperty("commandLongDescription", "Returns a list of the node SUIDs associated with the passed network parameter.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"nodes\": [101,102]}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new ListNetworkAttributesTaskFactory(CyNode.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "list attributes");
        props.setProperty("commandNamespace", "node");
        props.setProperty("commandDescription", "List all of the columns for nodes");
        props.setProperty("commandLongDescription", "Returns a list of column names assocated with nodes.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "[\"SUID\",\"name\"]");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new ListPropertiesTaskFactory(CyNode.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "list properties");
        props.setProperty("commandNamespace", "node");
        props.setProperty("commandDescription", "List all of the visual properties for nodes");
        props.setProperty("commandLongDescription", "Returns a list of visual properties available for nodes.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "[\"Paint\",\"Visible\"]");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new RenameNodeTaskFactory();
        props = new Properties();
        props.setProperty("command", "rename");
        props.setProperty("commandNamespace", "node");
        props.setProperty("commandDescription", "Rename a node");
        props.setProperty("commandLongDescription", "Sets the value of the name column for the passed node.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new SetNetworkAttributeTaskFactory(CyNode.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "set attribute");
        props.setProperty("commandNamespace", "node");
        props.setProperty("commandDescription", "Change node table values for a node or set of nodes");
        props.setProperty("commandLongDescription", "Sets the value of a specified column for the passed node or set of nodes.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new SetPropertiesTaskFactory(CyNode.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "set properties");
        props.setProperty("commandNamespace", "node");
        props.setProperty("commandDescription", "Set node visual properties");
        props.setProperty("commandLongDescription", "Sets the value of a specified property for the passed node or set of nodes.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new CreateNetworkAttributeTaskFactory(CyEdge.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "create attribute");
        props.setProperty("commandNamespace", "edge");
        props.setProperty("commandDescription", "Create a new column for edges");
        props.setProperty("commandLongDescription", "Creates a new edge column.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ \"columnName\": \"New Column\" }");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new GetEdgeTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "get");
        props.setProperty("commandNamespace", "edge");
        props.setProperty("commandDescription", "Get an edge");
        props.setProperty("commandLongDescription", "Returns the SUID of an edge that matches the passed parameters. If multiple edges are found, only one will be returned, and a warning will be reported in the Cytoscape Task History dialog.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"edge\": 101}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new GetNetworkAttributeTaskFactory(CyEdge.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "get attribute");
        props.setProperty("commandNamespace", "edge");
        props.setProperty("commandDescription", "Get the values from a column in a set of edges");
        props.setProperty("commandLongDescription", "Returns the attributes for the edges passed as parameters.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "[  { \"name\": \"Object 1\", \"SUID\": 101 },   { \"name\": \"Object 2\", \"SUID\": 102 }]");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new GetPropertiesTaskFactory(CyEdge.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "get properties");
        props.setProperty("commandNamespace", "edge");
        props.setProperty("commandDescription", "Get the visual properties for edges");
        props.setProperty("commandLongDescription", "Returns the visual properties for the edges that match the passed parameters.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "[ {\"SUID\": 92,\"visualProperties\": [{\"visualProperty\": \"EDGE_PAINT\",\"value\": \"#808080\"},{\"visualProperty\": \"EDGE_VISIBLE\",\"value\": true}]}]");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new ListEdgesTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "list");
        props.setProperty("commandNamespace", "edge");
        props.setProperty("commandDescription", "List edges");
        props.setProperty("commandLongDescription", "Returns a list of the edge SUIDs associated with the passed network parameter.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"edges\": [101,102]}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new ListNetworkAttributesTaskFactory(CyEdge.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "list attributes");
        props.setProperty("commandNamespace", "edge");
        props.setProperty("commandDescription", "List all of the columns for edges");
        props.setProperty("commandLongDescription", "Returns a list of column names assocated with edges.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "[\"SUID\",\"name\"]");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new ListPropertiesTaskFactory(CyEdge.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "list properties");
        props.setProperty("commandNamespace", "edge");
        props.setProperty("commandDescription", "List all of the visual properties for edges");
        props.setProperty("commandLongDescription", "Returns a list of visual properties available for edges.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "[\"Paint\",\"Visible\"]");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new RenameEdgeTaskFactory();
        props = new Properties();
        props.setProperty("command", "rename");
        props.setProperty("commandNamespace", "edge");
        props.setProperty("commandDescription", "Rename an edge");
        props.setProperty("commandLongDescription", "Sets the value of the name column for the passed edge.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new SetNetworkAttributeTaskFactory(CyEdge.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "set attribute");
        props.setProperty("commandNamespace", "edge");
        props.setProperty("commandDescription", "Change edge table values for an edge or set of edges");
        props.setProperty("commandLongDescription", "Sets the value of a specified column for the passed edge or set of edges.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new SetPropertiesTaskFactory(CyEdge.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "set properties");
        props.setProperty("commandNamespace", "edge");
        props.setProperty("commandDescription", "Change visual properties for a set of edges");
        props.setProperty("commandLongDescription", "Sets the value of a specified property for the passed edge or set of edges.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{}");
        this.registerService(bc, factory, TaskFactory.class, props);
    }

    private void createGroupTaskFactories(BundleContext bc, CyGroupManager groupManager, CyGroupFactory groupFactory) {
        Object factory = new GroupNodesTaskFactoryImpl(this.serviceRegistrar);
        Properties props = new Properties();
        props.setProperty("preferredMenu", "Group[-1060]");
        props.setProperty("title", "Group Selected Nodes");
        props.setProperty("tooltip", "Group Selected Nodes Together");
        props.setProperty("inToolBar", "false");
        props.setProperty("menuGravity", "0.0");
        props.setProperty("inMenuBar", "false");
        props.setProperty("preferredAction", "NEW");
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props);
        this.registerService(bc, factory, GroupNodesTaskFactory.class, props);
        props = new Properties();
        props.setProperty("command", "create");
        props.setProperty("commandNamespace", "group");
        props.setProperty("commandDescription", "Create a new group of nodes");
        props.setProperty("commandLongDescription", "Create a group from the specified nodes.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"group\":123}");
        this.registerService(bc, factory, TaskFactory.class, props);
        props = new Properties();
        props.setProperty("preferredMenu", "Group[-1080]");
        props.setProperty("menuGravity", "0.0");
        props.setProperty("title", "Group Selected Nodes");
        props.setProperty("tooltip", "Group Selected Nodes Together");
        props.setProperty("inToolBar", "false");
        props.setProperty("inMenuBar", "false");
        props.setProperty("preferredAction", "NEW");
        this.registerService(bc, factory, NodeViewTaskFactory.class, props);
        factory = new GetGroupTaskFactory(this.applicationManager, groupManager, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "get");
        props.setProperty("commandNamespace", "group");
        props.setProperty("commandDescription", "Get a particular group");
        props.setProperty("commandLongDescription", "Get a group by providing a network and the group node identifier");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", GetGroupTask.EXAMPLE_JSON);
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new UnGroupNodesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("preferredMenu", "Group[-1060]");
        props.setProperty("title", "Ungroup Selected Nodes");
        props.setProperty("tooltip", "Ungroup Selected Nodes");
        props.setProperty("inToolBar", "false");
        props.setProperty("inMenuBar", "false");
        props.setProperty("menuGravity", "1.0");
        props.setProperty("preferredAction", "NEW");
        props.setProperty("commandDescription", "Removes the selected group nodes and replaces them with the members of the groups. ");
        props.setProperty("commandSupportsJSON", "true");
        this.registerService(bc, factory, NetworkViewTaskFactory.class, props);
        this.registerService(bc, factory, UnGroupTaskFactory.class, props);
        props = new Properties();
        props.setProperty("command", "ungroup");
        props.setProperty("commandNamespace", "group");
        props.setProperty("commandDescription", "Ungroup a set of previously grouped nodes");
        props.setProperty("commandLongDescription", "Ungroups one or more groups, expanding them if they are collapsed and removing the group nodes.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"groups\": [123,124]}");
        this.registerService(bc, factory, TaskFactory.class, props);
        props = new Properties();
        props.setProperty("preferredMenu", "Group[-1080]");
        props.setProperty("menuGravity", "1.0");
        props.setProperty("insertSeparatorAfter", "true");
        props.setProperty("title", "Ungroup Selected Nodes");
        props.setProperty("tooltip", "Ungroup Selected Nodes");
        props.setProperty("inToolBar", "false");
        props.setProperty("inMenuBar", "false");
        props.setProperty("preferredAction", "NEW");
        this.registerService(bc, factory, NodeViewTaskFactory.class, props);
        this.registerService(bc, factory, UnGroupNodesTaskFactory.class, props);
        factory = new GroupNodeContextTaskFactoryImpl(groupManager, true, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("preferredMenu", "Group[-1080]");
        props.setProperty("title", "Collapse Group(s)");
        props.setProperty("tooltip", "Collapse Grouped Nodes");
        props.setProperty("preferredAction", "NEW");
        props.setProperty("menuGravity", "2.0");
        this.registerService(bc, factory, NodeViewTaskFactory.class, props);
        this.registerService(bc, factory, CollapseGroupTaskFactory.class, props);
        props = new Properties();
        props.setProperty("command", "collapse");
        props.setProperty("commandNamespace", "group");
        props.setProperty("commandDescription", "Collapse groups");
        props.setProperty("commandLongDescription", "Replaces the representation of all of the nodes and edges in a group with a single node");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"groups\": [123,124]}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new GroupNodeContextTaskFactoryImpl(groupManager, false, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("preferredMenu", "Group[-1080]");
        props.setProperty("title", "Expand Group(s)");
        props.setProperty("tooltip", "Expand Group(s)");
        props.setProperty("preferredAction", "NEW");
        props.setProperty("menuGravity", "3.0");
        this.registerService(bc, factory, NodeViewTaskFactory.class, props);
        this.registerService(bc, factory, ExpandGroupTaskFactory.class, props);
        props = new Properties();
        props.setProperty("command", "expand");
        props.setProperty("commandNamespace", "group");
        props.setProperty("commandDescription", "Expand collapsed groups");
        props.setProperty("commandLongDescription", "Replaces the group node with member nodes for a set of groups");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"groups\": [123,124]}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new AddToGroupTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "add");
        props.setProperty("commandNamespace", "group");
        props.setProperty("commandDescription", "Add nodes or edges to a group");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{}");
        props.setProperty("commandLongDescription", "Adds the specified nodes and edges to the specified group");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new ListGroupsTaskFactory(this.applicationManager, groupManager, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "list");
        props.setProperty("commandNamespace", "group");
        props.setProperty("commandDescription", "List all of the groups in a network");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandLongDescription", "Lists the SUIDs of all of the groups in a network");
        props.setProperty("commandExampleJSON", "{\"groups\": [123,124,126]}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new RemoveFromGroupTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "remove");
        props.setProperty("commandNamespace", "group");
        props.setProperty("commandDescription", "Remove nodes or edges from a group");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandLongDescription", "Remove the selected nodes and edges from their current group");
        props.setProperty("commandExampleJSON", "{}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new RenameGroupTaskFactory(this.applicationManager, groupManager, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "rename");
        props.setProperty("commandNamespace", "group");
        props.setProperty("commandDescription", "Rename a group");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandLongDescription", "Changes the name of the selected group or groups");
        props.setProperty("commandExampleJSON", "{}");
        this.registerService(bc, factory, TaskFactory.class, props);
    }

    private void createTableTaskFactories(BundleContext bc) {
        Object factory = new ExportSelectedTableTaskFactoryImpl(this.serviceRegistrar);
        Properties props = new Properties();
        props.setProperty("enableFor", "table");
        props.setProperty("preferredMenu", "File.Export[24.8]");
        props.setProperty("menuGravity", "5");
        props.setProperty("title", "Table to File...");
        props.setProperty("insertSeparatorBefore", "true");
        props.setProperty("tooltip", "Save a table to the file system");
        this.registerService(bc, factory, TaskFactory.class, props);
        this.registerService(bc, factory, ExportSelectedTableTaskFactory.class, props);
        factory = new ExportTableTaskFactoryImpl(this.serviceRegistrar);
        TextIcon icon = new TextIcon("+", this.iconFont.deriveFont(22.0f), 32, 31);
        String iconId = "cy::Table:EXPORT_TABLE";
        this.iconManager.addIcon(iconId, (Icon)icon);
        Properties props2 = new Properties();
        props2.setProperty("enableFor", "table");
        props2.setProperty("inNodeTableToolBar", "true");
        props2.setProperty("inEdgeTableToolBar", "true");
        props2.setProperty("inNetworkTableToolBar", "true");
        props2.setProperty("inUnassignedTableToolBar", "true");
        props2.setProperty("toolBarGravity", "0.007");
        props2.setProperty("largeIconID", iconId);
        props2.setProperty("tooltip", "Export Table to File...");
        props2.setProperty("insertToolbarSeparatorAfter", "true");
        this.registerService(bc, factory, TableTaskFactory.class, props2);
        this.registerService(bc, factory, ExportTableTaskFactory.class);
        factory = new MergeTablesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "table");
        props.setProperty("preferredMenu", "Tools.Merge[2.0]");
        props.setProperty("title", "Tables...");
        props.setProperty("menuGravity", "8");
        props.setProperty("tooltip", "Merge Tables");
        props.setProperty("command", "merge");
        props.setProperty("commandNamespace", "table");
        props.setProperty("commandDescription", "Merge tables together");
        props.setProperty("commandLongDescription", "Merge tables together joining around a designated key column.  Depending on the arguments, might merge into multiple local tables.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"tables\":[101,102]}");
        this.registerService(bc, factory, TaskFactory.class, props);
        this.registerService(bc, factory, MergeTablesTaskFactory.class, props);
        factory = new MapGlobalToLocalTableTaskFactoryImpl(this.tableManager, this.netManager, this.tunableSetter);
        props = new Properties();
        this.registerService(bc, factory, TableTaskFactory.class, props);
        this.registerService(bc, factory, MapGlobalToLocalTableTaskFactory.class, props);
        factory = new MapTableToNetworkTablesTaskFactoryImpl(this.serviceRegistrar);
        this.registerService(bc, factory, MapTableToNetworkTablesTaskFactory.class);
        factory = new DeleteTableTaskFactoryImpl(this.serviceRegistrar);
        this.registerService(bc, factory, TableTaskFactory.class);
        this.registerService(bc, factory, DeleteTableTaskFactory.class);
        factory = new CopyValueToColumnTaskFactoryImpl(false, "Apply to entire column", this.serviceRegistrar);
        props = new Properties();
        props.setProperty("title", ((CopyValueToColumnTaskFactoryImpl)((Object)factory)).getTaskFactoryName());
        props.setProperty("tableTypes", "node,edge,network,unassigned");
        this.registerService(bc, factory, TableCellTaskFactory.class, props);
        factory = new CopyValueToColumnTaskFactoryImpl(true, "Apply to selected nodes", this.serviceRegistrar);
        props = new Properties();
        props.setProperty("title", ((CopyValueToColumnTaskFactoryImpl)((Object)factory)).getTaskFactoryName());
        props.setProperty("tableTypes", "node");
        this.registerService(bc, factory, TableCellTaskFactory.class, props);
        factory = new CopyValueToColumnTaskFactoryImpl(true, "Apply to selected edges", this.serviceRegistrar);
        props = new Properties();
        props.setProperty("title", ((CopyValueToColumnTaskFactoryImpl)((Object)factory)).getTaskFactoryName());
        props.setProperty("tableTypes", "edge");
        this.registerService(bc, factory, TableCellTaskFactory.class, props);
        factory = new ExportNoGuiSelectedTableTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "export");
        props.setProperty("commandNamespace", "table");
        props.setProperty("commandDescription", "Export a table to a file");
        props.setProperty("commandLongDescription", "Creates a file with name <FILE> and writes the table there.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"file\": \"myfile.csv\"}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new CreateTableTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "create table");
        props.setProperty("commandNamespace", "table");
        props.setProperty("commandDescription", "Create a new table");
        props.setProperty("commandLongDescription", "Adds a new table to the network.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"table\":101}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new DestroyTableTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "destroy");
        props.setProperty("commandNamespace", "table");
        props.setProperty("commandDescription", "Destroy (delete) an entire table");
        props.setProperty("commandLongDescription", "Removes the specified table from the network. ");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"table\": 101}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new DeleteColumnCommandTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "delete column");
        props.setProperty("commandNamespace", "table");
        props.setProperty("commandDescription", "Delete a column from a table");
        props.setProperty("commandLongDescription", "Remove a column from a table, specified by its name.  Returns the name of the column removed.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"table\":101,\"column\":\"defunct\"}");
        this.registerService(bc, factory, TaskFactory.class, props);
        TextIcon icon2 = new TextIcon("\uf014", this.iconManager.getIconFont(SMALL_ICON_FONT_SIZE), SMALL_ICON_SIZE, SMALL_ICON_SIZE);
        String iconId2 = "cy::DELETE_COLUMN_SMALL";
        this.iconManager.addIcon(iconId2, (Icon)icon2);
        AbstractTableColumnTaskFactory factory2 = new DeleteColumnTaskFactoryImpl(this.serviceRegistrar);
        props2 = new Properties();
        props2.setProperty("title", "Delete Column");
        props2.setProperty("menuGravity", "1.3");
        props2.setProperty("smallIconID", iconId2);
        props2.setProperty("insertSeparatorAfter", "true");
        this.registerService(bc, factory2, TableColumnTaskFactory.class, props2);
        this.registerService(bc, factory2, DeleteColumnTaskFactory.class, props2);
        icon2 = new TextIcon("\uf044", this.iconManager.getIconFont(SMALL_ICON_FONT_SIZE), SMALL_ICON_SIZE, SMALL_ICON_SIZE);
        iconId2 = "cy::RENAME_COLUMN_SMALL";
        this.iconManager.addIcon(iconId2, (Icon)icon2);
        factory2 = new RenameColumnTaskFactoryImpl(this.serviceRegistrar);
        props2 = new Properties();
        props2.setProperty("title", "Rename Column...");
        props2.setProperty("menuGravity", "1.2");
        props2.setProperty("smallIconID", iconId2);
        props2.setProperty("command", "rename column");
        props2.setProperty("commandNamespace", "table");
        props2.setProperty("commandDescription", "Rename a column in a table");
        props2.setProperty("commandLongDescription", "Changes the name of a specified column in the table.");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "{\"table\":101,\"column\":\"New Column\"}");
        this.registerService(bc, factory2, TableColumnTaskFactory.class, props2);
        this.registerService(bc, factory2, RenameColumnTaskFactory.class, props2);
        this.registerService(bc, factory2, TaskFactory.class, props2);
        factory = new AddRowTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "add row");
        props.setProperty("commandNamespace", "table");
        props.setProperty("commandDescription", "Add a new row to a table");
        props.setProperty("commandLongDescription", "Appends an additional row of empty cells to the current table");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"table\":101,\"row\":\"row key\"}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new CreateColumnTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "create column");
        props.setProperty("commandNamespace", "table");
        props.setProperty("commandDescription", "Create a new column in a table");
        props.setProperty("commandLongDescription", "Appends an additional column of attribute values to the current table");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"table\":101, \"column\": \"uncertainty\"}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new DeleteRowTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "delete row");
        props.setProperty("commandNamespace", "table");
        props.setProperty("commandDescription", "Delete a row from a table");
        props.setProperty("commandLongDescription", "Deletes a row from a table.Requires the table name or SUID and the row key.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"table\":101,\"key\":\"62\"}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new GetColumnTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "get column");
        props.setProperty("commandNamespace", "table");
        props.setProperty("commandDescription", "Get the information about a table column");
        props.setProperty("commandLongDescription", "Get the information about a table column.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"name\": \"New name\", \"type\": \"String\", \"immutable\": false, \"primaryKey\": false, \"values\":[\"EGFR\",\"BRCA1\",\"BRCA2\"]}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new GetRowTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "get row");
        props.setProperty("commandNamespace", "table");
        props.setProperty("commandDescription", "Return all values in a table row");
        props.setProperty("commandLongDescription", "Returns the values in each column of a row of a table.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"table\":101,\"SUID\":101,\"name\":\"mynode\"}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new GetValueTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "get value");
        props.setProperty("commandNamespace", "table");
        props.setProperty("commandDescription", "Return a single value from a table");
        props.setProperty("commandLongDescription", "Returns the value from a cell as specified by row and column ids");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"table\":123, \"row\":\"123\", \"column\":\"degree\", \"value\":1}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new ListColumnsTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "list columns");
        props.setProperty("commandNamespace", "table");
        props.setProperty("commandDescription", "List all of the columns in a table");
        props.setProperty("commandLongDescription", "Returns the list of columns in the table");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "[\"name\",\"degree\"]");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new ListRowsTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "list rows");
        props.setProperty("commandNamespace", "table");
        props.setProperty("commandDescription", "List all of the rows in a table");
        props.setProperty("commandLongDescription", "Returns the list of primary keys for each of the rows in the specified table");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"table\": 123, \"rows\":[\"101\",\"102\",\"103\"]}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new ListTablesTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "list");
        props.setProperty("commandNamespace", "table");
        props.setProperty("commandDescription", "List all of the registered tables");
        props.setProperty("commandLongDescription", "Returns a list of the table SUIDs associated with the passed network parameter.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"tables\":[101,102,104]}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new SetTableTitleTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "set title");
        props.setProperty("commandNamespace", "table");
        props.setProperty("commandDescription", "Set the title of a table");
        props.setProperty("commandLongDescription", "Changes the visible identifier of a single table");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"table\":101, \"title\": \"My Title\"}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new SetValuesTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "set values");
        props.setProperty("commandNamespace", "table");
        props.setProperty("commandDescription", "Set values in a table");
        props.setProperty("commandLongDescription", "Set all the values in the specified list of rows with a single value");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"table\":101, \"rows\":[\"key1\",\"key1\",\"key1\"]}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new CreateNetworkAttributeTaskFactory(CyNetwork.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "create attribute");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Create a new column in the network table");
        props.setProperty("commandLongDescription", "Creates a new network column.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ \"columnName\": \"New Column\" }");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new GetNetworkAttributeTaskFactory(CyNetwork.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "get attribute");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Get the value from a column for a network");
        props.setProperty("commandLongDescription", "Returns the attributes for the network passed as parameter.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "[  { \"name\": \"Object 1\", \"SUID\": 101 },   { \"name\": \"Object 2\", \"SUID\": 102 }]");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new ListNetworkAttributesTaskFactory(CyNetwork.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "list attributes");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "List all of the columns for networks");
        props.setProperty("commandLongDescription", "Returns a list of column names assocated with a network.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "[\"SUID\",\"shared name\",\"name\",\"selected\",\"__Annotations\",\"publication\"]");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new SetNetworkAttributeTaskFactory(CyNetwork.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "set attribute");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Set a value in the network table");
        props.setProperty("commandLongDescription", "Sets the value of a specified column for the passed network.");
        props.setProperty("commandExampleJSON", "{}");
        props.setProperty("commandSupportsJSON", "true");
        this.registerService(bc, factory, TaskFactory.class, props);
    }

    private void createNetworkTaskFactories(BundleContext bc, CyGroupManager groupManager, CyGroupFactory groupFactory) {
        Object factory = new NewEmptyNetworkTaskFactoryImpl(this.serviceRegistrar);
        Properties props = new Properties();
        props.setProperty("preferredMenu", "File.New Network[16]");
        props.setProperty("menuGravity", "4.0");
        props.setProperty("title", "Empty");
        props.setProperty("command", "create empty");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Create an empty network");
        props.setProperty("commandLongDescription", "Create a new, empty network. The new network may be created as part of an existing network collection or a new network collection.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"network\":101}");
        this.registerService(bc, factory, TaskFactory.class, props);
        this.registerService(bc, factory, NewEmptyNetworkViewFactory.class, props);
        this.registerServiceListener(bc, ((NewEmptyNetworkTaskFactoryImpl)((Object)factory))::addNetworkViewRenderer, ((NewEmptyNetworkTaskFactoryImpl)((Object)factory))::removeNetworkViewRenderer, NetworkViewRenderer.class);
        factory = new CloneNetworkTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "network");
        props.setProperty("preferredMenu", "File.New Network[16]");
        props.setProperty("menuGravity", "3.0");
        props.setProperty("title", "Clone Current Network");
        props.setProperty("insertSeparatorBefore", "true");
        props.setProperty("command", "clone");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Make a copy of the current network");
        props.setProperty("commandLongDescription", "Create a new network by cloning an existing network. The new network will be created as part of a new network collection.  The SUID of the new network and view (if one is created) are returned.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"network\":101,\"view\":400}");
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        this.registerService(bc, factory, CloneNetworkTaskFactory.class, props);
        factory = new NewNetworkSelectedNodesOnlyTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("preferredMenu", "File.New Network[16]");
        props.setProperty("accelerator", "cmd n");
        props.setProperty("enableFor", "selectedNodes");
        props.setProperty("title", "From Selected Nodes, All Edges");
        props.setProperty("menuGravity", "1.0");
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        this.registerService(bc, factory, NewNetworkSelectedNodesOnlyTaskFactory.class, props);
        factory = new NewNetworkSelectedNodesEdgesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "selectedNodesOrEdges");
        props.setProperty("preferredMenu", "File.New Network[16]");
        props.setProperty("menuGravity", "2.0");
        props.setProperty("accelerator", "cmd shift n");
        props.setProperty("title", "From Selected Nodes, Selected Edges");
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        this.registerService(bc, factory, NewNetworkSelectedNodesAndEdgesTaskFactory.class, props);
        factory = new DestroyNetworkTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("preferredMenu", "Edit");
        props.setProperty("enableFor", "network");
        props.setProperty("title", "Destroy Networks");
        props.setProperty("menuGravity", "3.2");
        this.registerService(bc, factory, NetworkCollectionTaskFactory.class, props);
        this.registerService(bc, factory, DestroyNetworkTaskFactory.class, props);
        Properties props2 = new Properties();
        props2.setProperty("enableFor", "network");
        props2.setProperty("command", "destroy");
        props2.setProperty("commandNamespace", "network");
        props2.setProperty("commandDescription", "Destroy (delete) a network");
        props2.setProperty("commandLongDescription", "Destroy (delete) a network. The SUID of the destroyed network is returned.");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "{\"network\":101}");
        this.registerService(bc, factory, TaskFactory.class, props2);
        factory = new LoadNetworkFileTaskFactoryImpl(this.serviceRegistrar);
        TextIcon icon = new TextIcon(IconUtil.LAYERED_IMPORT_NET, this.iconFont, IconUtil.COLORS_2B, LARGE_ICON_SIZE, LARGE_ICON_SIZE);
        String iconId = "cy::IMPORT_NET";
        this.iconManager.addIcon(iconId, (Icon)icon);
        Properties props3 = new Properties();
        props3.setProperty("id", "loadNetworkFileTaskFactory");
        props3.setProperty("preferredMenu", "File.Import[23.0]");
        props3.setProperty("accelerator", "cmd l");
        props3.setProperty("title", "Network from File...");
        props3.setProperty("commandNamespace", "network");
        props3.setProperty("command", "load file");
        props3.setProperty("commandDescription", "Load a network file (e.g. XGMML)");
        props3.setProperty("commandLongDescription", "Load a new network from a network file type (e.g. ``SIF``, ``XGMML``, etc.).  Use ``network import file`` to load networks from Excel or csv files.  This command will create a new network collection if no current network collection is selected, otherwise it will add the network to the current collection.\tThe SUIDs of the new networks and views are returned.");
        props3.setProperty("commandSupportsJSON", "true");
        props3.setProperty("commandExampleJSON", "{ \"networks\":[101,102,103],\"views\":[200,201,204] }");
        props3.setProperty("menuGravity", "0.1");
        props3.setProperty("toolBarGravity", "2.0");
        props3.setProperty("largeIconID", iconId);
        props3.setProperty("inToolBar", "true");
        props3.setProperty("tooltip", "Import Network from File System");
        props3.setProperty("tooltipLongDescription", "Opens a network from a file and adds it to the current session.");
        this.registerService(bc, factory, TaskFactory.class, props3);
        this.registerService(bc, factory, LoadNetworkFileTaskFactory.class, props3);
        factory = new LoadMultipleNetworkFilesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        this.registerService(bc, factory, TaskFactory.class, props);
        this.registerService(bc, factory, LoadMultipleNetworkFilesTaskFactory.class, props);
        factory = new LoadNetworkURLTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("id", "loadNetworkURLTaskFactory");
        props.setProperty("preferredMenu", "File.Import[23.0]");
        props.setProperty("accelerator", "cmd shift l");
        props.setProperty("menuGravity", "0.2");
        props.setProperty("title", "Network from URL...");
        props.setProperty("tooltip", "Open a network from a remote Internet location");
        props.setProperty("command", "load url");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Load a network file (e.g. XGMML) from a url");
        props.setProperty("commandLongDescription", "Load a new network from a URL that points to a network file type (e.g. ``SIF``, ``XGMML``, etc.).  Use ``network import url`` to load networks from Excel or csv files.  This command will create a new network collection if no current network collection is selected, otherwise it will add the network to the current collection.\tThe SUIDs of the new networks and views are returned.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ \"networks\":[101,102,103],\"views\":[200,201,204] }");
        this.registerService(bc, factory, TaskFactory.class, props);
        this.registerService(bc, factory, LoadNetworkURLTaskFactory.class, props);
        factory = new EditNetworkTitleTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("inNetworkPanelContextMenu", "true");
        props.setProperty("inContextMenu", "false");
        props.setProperty("enableFor", "singleNetwork");
        props.setProperty("menuGravity", "5.5");
        props.setProperty("title", "Rename Network...");
        props.setProperty("insertSeparatorBefore", "true");
        props.setProperty("command", "rename");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Rename a network");
        props.setProperty("commandLongDescription", "Rename an existing network.  The SUID of the network is returned");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"network\":101, \"title\":\"My title\"}");
        this.registerService(bc, factory, EditNetworkTitleTaskFactory.class, props);
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        factory = new ExportSelectedNetworkTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "network");
        props.setProperty("preferredMenu", "File.Export[24.8]");
        props.setProperty("insertSeparatorBefore", "true");
        props.setProperty("menuGravity", "2.99");
        props.setProperty("title", "Network to File...");
        props.setProperty("inContextMenu", "false");
        props.setProperty("tooltip", "Save this network to the file system.");
        this.registerService(bc, factory, TaskFactory.class, props);
        this.registerService(bc, factory, ExportSelectedNetworkTaskFactory.class, props);
        factory = new ExportNetworkTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("id", "exportNetworkTaskFactory");
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        this.registerService(bc, factory, ExportNetworkTaskFactory.class, props);
        props = new Properties();
        props.setProperty("command", "export");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Export a network to a file");
        props.setProperty("commandLongDescription", "Export a network to a network file (e.g. ``XGMML``, ``SIF``, etc.)");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"file\":\"/tmp/foo.sif\"}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new ConnectSelectedNodesTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("inMenuBar", "false");
        props.setProperty("inToolBar", "false");
        props.setProperty("preferredAction", "NEW");
        props.setProperty("preferredMenu", "Add[-1110]");
        props.setProperty("menuGravity", "0.2");
        props.setProperty("title", "Edges Connecting Selected Nodes");
        this.registerService(bc, factory, NodeViewTaskFactory.class, props);
        this.registerService(bc, factory, ConnectSelectedNodesTaskFactory.class, props);
        props2 = new Properties();
        props2.setProperty("command", "connect nodes");
        props2.setProperty("commandNamespace", "network");
        props2.setProperty("commandDescription", "Create new edges that connect a list of nodes");
        props2.setProperty("commandLongDescription", "Create new edges that connect a list of nodes");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "{\"edges\": [102,103]}");
        this.registerService(bc, factory, NetworkTaskFactory.class, props2);
        factory = new NewNetworkCommandTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "create");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Create a new network");
        props.setProperty("commandLongDescription", "Create a new network from a list of nodes and edges in an existing source network. The SUID of the network and view are returned.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"network\":102,\"view\":500}");
        this.registerService(bc, factory, NetworkTaskFactory.class, props);
        factory = new GetNetworkTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "get");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Return a network");
        props.setProperty("commandLongDescription", "Return a network from the name, SUID, or other identifier.  If the name or SUID doesn't exist, the current network is returned.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"shared name\": \"my network\", \"SUID\": 80, \"name\":\"my network\"}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new ListNetworksTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "list");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "List all of the available networks");
        props.setProperty("commandLongDescription", "List all of the networks in the current session.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"networks\": [102,103]}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new SetCurrentNetworkTaskFactory(this.applicationManager);
        props = new Properties();
        props.setProperty("command", "set current");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Set the current network");
        props.setProperty("commandLongDescription", "Sets the current network, which can also be null.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new ListPropertiesTaskFactory(CyNetwork.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "list properties");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "List all of the visual properties for networks");
        props.setProperty("commandLongDescription", "List all of the visual properties for networks");
        props.setProperty("commandExampleJSON", "[\"Background Paint\",\"Node Selection\",\"Edge Selection\"]");
        props.setProperty("commandSupportsJSON", "true");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new GetPropertiesTaskFactory(CyNetwork.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "get properties");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Get the visual property value for a network");
        props.setProperty("commandLongDescription", "Returns the visual properties for the network that matches the passed parameters.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "[ {\"SUID\": 92,\"visualProperties\": [{\"visualProperty\": \"NETWORK_BACKGROUND_PAINT\",\"value\": \"#808080\"},{\"visualProperty\": \"NETWORK_TITLE\",\"value\": \"my network\"}]}]");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new SetPropertiesTaskFactory(CyNetwork.class, this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "set properties");
        props.setProperty("commandNamespace", "network");
        props.setProperty("commandDescription", "Set network visual properties");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandLongDescription", "Sets the value of a specified property for the passed network.");
        props.setProperty("commandExampleJSON", "{}");
        this.registerService(bc, factory, TaskFactory.class, props);
    }

    private void createSessionTaskFactories(BundleContext bc) {
        AbstractTaskFactory factory = new NewSessionTaskFactoryImpl(this.serviceRegistrar);
        Properties props = new Properties();
        props.setProperty("preferredMenu", "File");
        props.setProperty("menuGravity", "1.8");
        props.setProperty("insertSeparatorAfter", "true");
        props.setProperty("title", "Close");
        props.setProperty("command", "new");
        props.setProperty("commandNamespace", "session");
        props.setProperty("commandDescription", "Create a new, empty session");
        props.setProperty("commandLongDescription", "Destroys the current session and creates a new, empty one.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ }");
        this.registerService(bc, factory, TaskFactory.class, props);
        this.registerService(bc, factory, NewSessionTaskFactory.class, props);
        factory = new OpenSessionTaskFactoryImpl(this.serviceRegistrar);
        TextIcon icon = new TextIcon(IconUtil.LAYERED_OPEN_FILE, this.iconFont, IconUtil.COLORS_2B, LARGE_ICON_SIZE, LARGE_ICON_SIZE);
        String iconId = "cy::OPEN_FILE";
        this.iconManager.addIcon(iconId, (Icon)icon);
        Properties props2 = new Properties();
        props2.setProperty("id", "openSessionTaskFactory");
        props2.setProperty("preferredMenu", "File");
        props2.setProperty("accelerator", "cmd o");
        props2.setProperty("largeIconID", iconId);
        props2.setProperty("title", "Open...");
        props2.setProperty("toolBarGravity", "1.0");
        props2.setProperty("inToolBar", "true");
        props2.setProperty("menuGravity", "0.5");
        props2.setProperty("tooltip", "Open Session");
        props2.setProperty("tooltipLongDescription", "Opens a session file (.cys) from the file system.");
        this.registerService(bc, factory, OpenSessionTaskFactory.class, props2);
        this.registerService(bc, factory, TaskFactory.class, props2);
        factory = new OpenSessionCommandTaskFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("command", "open");
        props.setProperty("commandNamespace", "session");
        props.setProperty("commandDescription", "Open a session from a file");
        props.setProperty("commandLongDescription", "Opens a session from a local file or URL.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{}");
        this.registerService(bc, factory, TaskFactory.class, props);
        factory = new SaveSessionTaskFactoryImpl(this.serviceRegistrar);
        icon = new TextIcon(IconUtil.LAYERED_SAVE, this.iconFont, IconUtil.COLORS_3, LARGE_ICON_SIZE, LARGE_ICON_SIZE, new Integer[]{1, 2});
        iconId = "cy::SAVE";
        this.iconManager.addIcon(iconId, (Icon)icon);
        props2 = new Properties();
        props2.setProperty("preferredMenu", "File");
        props2.setProperty("accelerator", "cmd s");
        props2.setProperty("largeIconID", iconId);
        props2.setProperty("title", "Save");
        props2.setProperty("toolBarGravity", "1.1");
        props2.setProperty("inToolBar", "true");
        props2.setProperty("menuGravity", "1.5");
        props2.setProperty("tooltip", "Save Session");
        props2.setProperty("tooltipLongDescription", "Saves the session to a file.");
        props2.setProperty("command", "save");
        props2.setProperty("commandNamespace", "session");
        props2.setProperty("commandDescription", "Save the session");
        props2.setProperty("commandLongDescription", "Saves the current session to an existing file, which will be replaced. If this is a new session that has not been saved yet, use 'save as' instead.");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "{ }");
        this.registerService(bc, factory, TaskFactory.class, props2);
        factory = new SaveSessionAsTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("preferredMenu", "File");
        props.setProperty("accelerator", "cmd shift s");
        props.setProperty("menuGravity", "1.7");
        props.setProperty("title", "Save As...");
        props.setProperty("command", "save as");
        props.setProperty("commandNamespace", "session");
        props.setProperty("commandDescription", "Save the session to a file");
        props.setProperty("commandLongDescription", "Saves the current session as a new file.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ }");
        this.registerService(bc, factory, TaskFactory.class, props);
        this.registerService(bc, factory, SaveSessionAsTaskFactory.class, props);
    }

    private void createVizmapTaskFactories(BundleContext bc) {
        Object factory = new ApplyVisualStyleTaskFactoryimpl(this.serviceRegistrar);
        Properties props = new Properties();
        props.setProperty("id", "applyVisualStyleTaskFactory");
        props.setProperty("command", "apply");
        props.setProperty("commandNamespace", "vizmap");
        props.setProperty("commandDescription", "Apply a style");
        props.setProperty("commandLongDescription", "Applies the specified style to the selected views and returns the SUIDs of the affected views.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"views\": [ 322, 420 ]}");
        this.registerService(bc, factory, NetworkViewCollectionTaskFactory.class, props);
        this.registerService(bc, factory, ApplyVisualStyleTaskFactory.class, props);
        factory = new ExportVizmapTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("enableFor", "vizmap");
        props.setProperty("preferredMenu", "File.Export[24.8]");
        props.setProperty("insertSeparatorBefore", "true");
        props.setProperty("menuGravity", "8");
        props.setProperty("title", "Styles to File...");
        props.setProperty("command", "export");
        props.setProperty("commandNamespace", "vizmap");
        props.setProperty("commandDescription", "Export styles to a file");
        props.setProperty("commandLongDescription", "Exports the specified styles to a Cytoscape vizmap (XML) or a Cytoscape.js (JSON) file and returns the path to the saved file.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ \"file\": \"/Users/johndoe/Downloads/MyStyles.json\" }");
        this.registerService(bc, factory, TaskFactory.class, props);
        this.registerService(bc, factory, ExportVizmapTaskFactory.class, props);
        factory = new LoadVizmapFileTaskFactoryImpl(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("preferredMenu", "File.Import[23.0]");
        props.setProperty("menuGravity", "20.0");
        props.setProperty("insertSeparatorBefore", "true");
        props.setProperty("title", "Styles from File...");
        props.setProperty("command", "load file");
        props.setProperty("commandNamespace", "vizmap");
        props.setProperty("commandDescription", "Load styles from a file");
        props.setProperty("commandLongDescription", "Loads styles from a vizmap (XML or properties) file and returns the names of the loaded styles.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "[ \"My Style 1\", \"My Style 2\" ]");
        this.registerService(bc, factory, TaskFactory.class, props);
        this.registerService(bc, factory, LoadVizmapFileTaskFactory.class, new Properties());
        factory = new ClearAllEdgeBendsFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("id", "clearAllEdgeBendsFactory");
        props.setProperty("title", "Clear All Edge Bends");
        props.setProperty("preferredMenu", "Layout");
        props.setProperty("menuGravity", "0.1");
        props.setProperty("enableFor", "networkAndView");
        this.registerService(bc, factory, NetworkViewCollectionTaskFactory.class, props);
        factory = new ClearAllEdgeBendsFactory(this.serviceRegistrar);
        props = new Properties();
        props.setProperty("title", "Clear All Edge Bends");
        props.setProperty("inNetworkPanelContextMenu", "true");
        props.setProperty("menuGravity", "6.0");
        props.setProperty("insertSeparatorBefore", "true");
        props.setProperty("enableFor", "networkAndView");
        this.registerService(bc, factory, NetworkViewCollectionTaskFactory.class, props);
    }

    private void createHelpTaskFactories(BundleContext bc) {
        HelpTaskFactory factory = new HelpTaskFactory(this.serviceRegistrar);
        TextIcon icon = new TextIcon(IconUtil.LAYERED_HELP, this.iconFont, IconUtil.COLORS_2A, LARGE_ICON_SIZE, LARGE_ICON_SIZE, new Integer[]{1});
        String iconId = "cy::HELP";
        this.iconManager.addIcon(iconId, (Icon)icon);
        Properties props = new Properties();
        props.setProperty("accelerator", "cmd ?");
        props.setProperty("largeIconID", iconId);
        props.setProperty("title", "Help");
        props.setProperty("tooltip", "Help");
        props.setProperty("tooltipLongDescription", "Opens a web page that contains context sensitive help.");
        props.setProperty("toolBarGravity", "3.4028235E38");
        props.setProperty("inToolBar", "true");
        this.registerService(bc, (Object)factory, TaskFactory.class, props);
    }
}

