/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.util;

import java.awt.Color;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.slf4j.Logger;

public final class ViewUtil {
    public static Color getDefaultTableHeaderBg() {
        return UIManager.getColor("TableHeader.background");
    }

    public static Color getSelectedTableHeaderBg() {
        int alpha = LookAndFeelUtil.isNimbusLAF() ? 50 : 25;
        return ViewUtil.alphaBlendColors(ViewUtil.getDefaultTableHeaderBg(), UIManager.getColor("Focus.color"), alpha);
    }

    public static Color alphaBlendColors(Color bottom, Color top, int topAlpha) {
        if (topAlpha == 255) {
            return top;
        }
        if (topAlpha == 0 || top == null) {
            return bottom;
        }
        int br = bottom.getRed();
        int bg = bottom.getGreen();
        int bb = bottom.getBlue();
        int tr = top.getRed();
        int tg = top.getGreen();
        int tb = top.getBlue();
        int r = (tr * topAlpha + br * (255 - topAlpha)) / 255;
        int g = (tg * topAlpha + bg * (255 - topAlpha)) / 255;
        int b = (tb * topAlpha + bb * (255 - topAlpha)) / 255;
        return new Color(r, g, b);
    }

    public static void invokeOnEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void invokeOnEDTAndWait(Runnable runnable) {
        ViewUtil.invokeOnEDTAndWait(runnable, null);
    }

    public static void invokeOnEDTAndWait(Runnable runnable, Logger logger) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                if (logger != null) {
                    logger.error("Unexpected error", (Throwable)e);
                }
                e.printStackTrace();
            }
        }
    }

    private ViewUtil() {
    }
}

