/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.util;

import java.util.Comparator;
import org.cytoscape.view.table.internal.util.ValidatedObjectAndEditString;

public class ValidatedObjectAndEditStringComparator
implements Comparator<ValidatedObjectAndEditString> {
    private final Class<?> internalColumnType;

    ValidatedObjectAndEditStringComparator(Class<?> internalColumnType) {
        this.internalColumnType = internalColumnType;
    }

    @Override
    public int compare(ValidatedObjectAndEditString v1, ValidatedObjectAndEditString v2) {
        String errorText1 = v1.getErrorText();
        String errorText2 = v2.getErrorText();
        if (errorText1 != null && errorText2 != null) {
            return errorText1.compareToIgnoreCase(errorText2);
        }
        if (errorText2 != null) {
            return 1;
        }
        if (errorText1 != null) {
            return -1;
        }
        Object val1 = v1.getValidatedObject();
        Object val2 = v2.getValidatedObject();
        if (this.internalColumnType == Double.class) {
            return ValidatedObjectAndEditStringComparator.doubleCompare((Double)val1, (Double)val2);
        }
        if (this.internalColumnType == Long.class) {
            return ValidatedObjectAndEditStringComparator.longCompare((Long)val1, (Long)val2);
        }
        if (this.internalColumnType == Integer.class) {
            return ValidatedObjectAndEditStringComparator.integerCompare((Integer)val1, (Integer)val2);
        }
        if (this.internalColumnType == Boolean.class) {
            return ValidatedObjectAndEditStringComparator.booleanCompare((Boolean)val1, (Boolean)val2);
        }
        return ValidatedObjectAndEditStringComparator.stringCompare(val1.toString(), val2.toString());
    }

    private static int doubleCompare(double d1, double d2) {
        if (d1 < d2) {
            return -1;
        }
        return d1 > d2 ? 1 : 0;
    }

    private static int longCompare(long l1, long l2) {
        if (l1 < l2) {
            return -1;
        }
        return l1 > l2 ? 1 : 0;
    }

    private static int integerCompare(int i1, int i2) {
        if (i1 < i2) {
            return -1;
        }
        return i1 > i2 ? 1 : 0;
    }

    private static int booleanCompare(boolean b1, boolean b2) {
        if (b1 && b2 || !b1 && !b2) {
            return 0;
        }
        return b1 ? -1 : 1;
    }

    private static int stringCompare(String s1, String s2) {
        return s1.compareToIgnoreCase(s2);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ValidatedObjectAndEditStringComparator && ((ValidatedObjectAndEditStringComparator)obj).internalColumnType == this.internalColumnType;
    }
}

