/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.impl.icon;

import java.awt.Color;
import java.awt.Font;
import javax.swing.Icon;
import org.cytoscape.cg.util.CustomGraphicsIcon;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.view.table.internal.impl.icon.ColorIcon;
import org.cytoscape.view.table.internal.impl.icon.FontFaceIcon;
import org.cytoscape.view.table.internal.impl.icon.TextIcon;
import org.cytoscape.view.table.internal.impl.icon.VisualPropertyIcon;

public class VisualPropertyIconFactory {
    public static <V> Icon createIcon(V value, int w, int h) {
        if (value == null) {
            return null;
        }
        VisualPropertyIcon icon = null;
        if (value instanceof Color) {
            icon = new ColorIcon((Color)value, w, h, value.toString());
        } else if (value instanceof Font) {
            icon = new FontFaceIcon((Font)value, w, h, "");
        } else if (value instanceof CyCustomGraphics) {
            String name = ((CyCustomGraphics)value).getDisplayName();
            icon = new CustomGraphicsIcon((CyCustomGraphics)value, w, h, name);
        } else {
            icon = new TextIcon(value, w, h, value.toString());
        }
        return icon;
    }
}

