/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.impl;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.function.Function;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.table.CyColumnView;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;
import org.cytoscape.view.table.internal.BrowserTableVisualLexicon;

public class BrowserTablePresentation {
    private final IconManager iconManager;
    private final Font defaultFont;

    public BrowserTablePresentation(Font defaultFont, CyServiceRegistrar registrar) {
        this.iconManager = (IconManager)registrar.getService(IconManager.class);
        this.defaultFont = defaultFont.deriveFont(LookAndFeelUtil.getSmallFontSize());
    }

    public Color getBackgroundColor(CyRow row, int rowIndex, CyColumnView colView, CyTableView tableView) {
        Paint val;
        Function fn;
        Color color = UIManager.getColor("Table.background");
        if (Boolean.TRUE.equals(tableView.getVisualProperty(BasicTableVisualLexicon.TABLE_ALTERNATE_ROW_COLORS))) {
            if (rowIndex % 2 != 0 && (color = UIManager.getColor("Table.alternateRowColor")).getAlpha() == 0) {
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255);
            }
        } else if ((color == null || colView.isSet(BasicTableVisualLexicon.CELL_BACKGROUND_PAINT)) && (fn = colView.getCellVisualProperty(BasicTableVisualLexicon.CELL_BACKGROUND_PAINT)) != null && (val = (Paint)fn.apply(row)) instanceof Color && (color = (Color)val) instanceof ColorUIResource) {
            color = new Color(color.getRGB());
        }
        return color;
    }

    public Color getForegroundColor(CyRow row, CyColumnView colView) {
        Paint vpValue;
        Function fn;
        Color color = UIManager.getColor("Table.foreground");
        if ((color == null || colView.isSet(BasicTableVisualLexicon.CELL_TEXT_COLOR)) && (fn = colView.getCellVisualProperty(BasicTableVisualLexicon.CELL_TEXT_COLOR)) != null && (vpValue = (Paint)fn.apply(row)) instanceof Color) {
            color = (Color)vpValue;
        }
        return color;
    }

    public Font getFont(CyRow row, CyColumnView colView, Object value) {
        Function fn;
        Font font = this.defaultFont;
        if (value instanceof Boolean) {
            font = this.iconManager.getIconFont(12.0f);
        } else if (colView.isSet(BasicTableVisualLexicon.CELL_FONT_FACE) && (fn = colView.getCellVisualProperty(BasicTableVisualLexicon.CELL_FONT_FACE)) != null) {
            font = (Font)fn.apply(row);
        }
        if (font == null) {
            font = this.defaultFont;
        }
        if (colView.isSet(BasicTableVisualLexicon.CELL_FONT_SIZE) && (fn = colView.getCellVisualProperty(BasicTableVisualLexicon.CELL_FONT_SIZE)) != null) {
            float size = ((Integer)fn.apply(row)).intValue();
            font = font.deriveFont(size);
        }
        return font;
    }

    public String getTooltip(CyRow row, CyColumnView colView, String defaultTooltip) {
        Function fn;
        String tooltip = defaultTooltip;
        if (colView.isSet(BasicTableVisualLexicon.CELL_TOOLTIP) && (fn = colView.getCellVisualProperty(BasicTableVisualLexicon.CELL_TOOLTIP)) != null && ((tooltip = (String)fn.apply(row)) == null || tooltip.isEmpty())) {
            tooltip = defaultTooltip;
        }
        return tooltip;
    }

    public CyCustomGraphics<?> getCustomGraphics(CyRow row, CyColumnView colView) {
        Function fn = colView.getCellVisualProperty(BrowserTableVisualLexicon.CELL_CUSTOMGRAPHICS);
        return fn != null ? (CyCustomGraphics)fn.apply(row) : null;
    }

    public boolean isTextWrapped(CyColumnView colView) {
        boolean b = false;
        if (colView.isSet(BasicTableVisualLexicon.COLUMN_TEXT_WRAPPED)) {
            b = (Boolean)colView.getVisualProperty(BasicTableVisualLexicon.COLUMN_TEXT_WRAPPED);
        }
        return b;
    }
}

