/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.impl;

import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.cytoscape.cg.model.NullCustomGraphics;
import org.cytoscape.cg.model.SVGLayer;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.table.CyColumnView;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.Cy2DGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.view.presentation.customgraphics.ImageCustomGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.PaintedShape;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;
import org.cytoscape.view.presentation.property.table.CellFormat;
import org.cytoscape.view.table.internal.impl.BrowserTable;
import org.cytoscape.view.table.internal.impl.BrowserTableModel;
import org.cytoscape.view.table.internal.impl.BrowserTablePresentation;
import org.cytoscape.view.table.internal.util.ValidatedObjectAndEditString;

public class BrowserTableCellRenderer
extends JPanel
implements TableCellRenderer {
    private static final int H_PAD = 5;
    private static final int V_PAD = 0;
    private final Pattern htmlPattern = Pattern.compile("[\\S\\s]*\\<html[\\S\\s]*\\>[\\S\\s]*\\<\\/html[\\S\\s]*\\>[\\S\\s]*", 66);
    private JLabel label;
    private JTextArea textArea;
    private Color bg;
    private Color fg;
    private Font font;
    private String text;
    private String tooltip;
    private boolean isError;
    private boolean isEquation;
    private CyCustomGraphics<?> cg;
    private final Border border;
    private CyColumn col;
    private CyRow row;
    private CyTableView tableView;
    private CyColumnView columnView;
    private final DefaultCellRenderer defCellRenderer = new DefaultCellRenderer();
    private final BrowserTablePresentation presentation;

    public BrowserTableCellRenderer(CyServiceRegistrar serviceRegistrar) {
        this.presentation = new BrowserTablePresentation(this.defCellRenderer.getFont(), serviceRegistrar);
        this.setLayout(new BorderLayout());
        Border defBorder = this.defCellRenderer.getBorder();
        this.border = defBorder == null ? BorderFactory.createEmptyBorder(0, 5, 0, 5) : BorderFactory.createCompoundBorder(defBorder, BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.setBorder(this.border);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int colIndex) {
        JComponent textComp;
        boolean wrap;
        this.removeAll();
        if (colIndex < 0 || colIndex >= table.getColumnCount() || rowIndex > table.getRowCount()) {
            return this;
        }
        ValidatedObjectAndEditString objEditStr = (ValidatedObjectAndEditString)value;
        Object validatedObj = objEditStr != null ? objEditStr.getValidatedObject() : null;
        BrowserTable browserTable = (BrowserTable)table;
        BrowserTableModel model = (BrowserTableModel)browserTable.getModel();
        this.tableView = model.getTableView();
        this.col = model.getCyColumn(browserTable.convertColumnIndexToModel(colIndex));
        this.row = model.getCyRow(browserTable.convertRowIndexToModel(rowIndex));
        if (this.col == null || this.row == null) {
            return this;
        }
        boolean isColumnSelected = Arrays.binarySearch(table.getColumnModel().getSelectedColumns(), colIndex) >= 0;
        this.columnView = (CyColumnView)this.tableView.getColumnView(this.col);
        this.bg = this.presentation.getBackgroundColor(this.row, rowIndex, this.columnView, this.tableView);
        this.fg = this.presentation.getForegroundColor(this.row, this.columnView);
        this.font = this.presentation.getFont(this.row, this.columnView, validatedObj);
        this.isError = objEditStr != null && objEditStr.getErrorText() != null;
        boolean bl = this.isEquation = objEditStr != null && objEditStr.isEquation();
        if (objEditStr == null || validatedObj == null && objEditStr.getErrorText() == null) {
            this.text = "";
        } else {
            if (objEditStr.getErrorText() != null) {
                this.text = "#ERR: " + objEditStr.getErrorText();
            } else if (validatedObj instanceof Boolean) {
                this.text = Boolean.TRUE.equals(validatedObj) ? "\uf14a" : "\uf096";
            } else if (validatedObj instanceof Double) {
                String formatStr = null;
                CellFormat format = (CellFormat)this.columnView.getVisualProperty(BasicTableVisualLexicon.COLUMN_FORMAT);
                if (format != null) {
                    formatStr = format.getFormat();
                }
                this.text = formatStr == null || formatStr.isBlank() ? validatedObj.toString() : String.format(formatStr, validatedObj);
            } else {
                this.text = validatedObj.toString();
            }
            this.tooltip = validatedObj instanceof Boolean ? validatedObj.toString() : this.text;
            this.tooltip = this.presentation.getTooltip(this.row, this.columnView, this.tooltip);
            if (this.tooltip != null && this.tooltip.isBlank()) {
                this.tooltip = null;
            }
        }
        if (isSelected && isColumnSelected) {
            boolean hasTempFocus;
            boolean bl2 = hasTempFocus = browserTable.getTempFocusedRow() == rowIndex && browserTable.getTempFocusedColumn() == colIndex;
            if (hasFocus || hasTempFocus) {
                this.bg = UIManager.getColor("Table.focusCellBackground");
                this.fg = UIManager.getColor("Table.focusCellForeground");
            } else {
                this.bg = UIManager.getColor("Table.selectionBackground");
                this.fg = this.isError ? LookAndFeelUtil.getErrorColor() : UIManager.getColor("Table.selectionForeground");
            }
        } else if (!table.isCellEditable(rowIndex, colIndex)) {
            if (!this.columnView.isSet(BasicTableVisualLexicon.CELL_TEXT_COLOR)) {
                this.fg = UIManager.getColor("TextField.inactiveForeground");
            }
        } else {
            this.fg = this.isError ? LookAndFeelUtil.getErrorColor() : this.fg;
        }
        this.cg = this.presentation.getCustomGraphics(this.row, this.columnView);
        this.setBackground(this.bg);
        this.setToolTipText(this.tooltip);
        boolean bl3 = wrap = (this.isError || !(validatedObj instanceof Boolean) || !(validatedObj instanceof Number)) && this.presentation.isTextWrapped(this.columnView);
        if (wrap) {
            Matcher matcher = this.htmlPattern.matcher(this.text);
            textComp = matcher.matches() ? this.getTextPane() : this.getTextArea();
        } else {
            textComp = this.getLabel();
            if (validatedObj instanceof Boolean) {
                ((JLabel)textComp).setHorizontalAlignment(0);
            } else {
                ((JLabel)textComp).setHorizontalAlignment(validatedObj instanceof Number ? 4 : 2);
            }
        }
        if (wrap) {
            Insets borderInsets = this.border.getBorderInsets(this);
            int hpad = borderInsets.left + borderInsets.right;
            int vpad = borderInsets.top + borderInsets.bottom;
            textComp.setSize(table.getColumnModel().getColumn(colIndex).getWidth() - hpad, textComp.getPreferredSize().height);
            int h = textComp.getPreferredSize().height + vpad;
            if (h != table.getRowHeight(rowIndex) && h >= browserTable.getRowHeight()) {
                table.setRowHeight(rowIndex, h);
            }
        }
        this.add((Component)textComp, "Center");
        return this;
    }

    private JComponent getLabel() {
        if (this.label == null) {
            this.label = new JLabel();
            this.label.setOpaque(false);
            this.label.setVerticalTextPosition(0);
        }
        this.label.setForeground(this.fg);
        this.label.setFont(this.font);
        this.label.setText(this.text);
        this.label.setToolTipText(this.tooltip);
        return this.label;
    }

    private JTextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextArea();
            this.textArea.setBorder(BorderFactory.createEmptyBorder());
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
        }
        this.textArea.setBackground(this.bg);
        this.textArea.setForeground(this.fg);
        this.textArea.setFont(this.font);
        this.textArea.setText(this.text);
        this.textArea.setToolTipText(this.tooltip);
        return this.textArea;
    }

    private JTextPane getTextPane() {
        JTextPane textPane = new JTextPane();
        textPane.setBorder(BorderFactory.createEmptyBorder());
        textPane.setContentType("text/html");
        textPane.setEditorKit(new WrappedHtmlEditorKit());
        textPane.setBackground(this.bg);
        textPane.setForeground(this.fg);
        textPane.setText(this.text);
        textPane.setToolTipText(this.tooltip);
        if (LookAndFeelUtil.isNimbusLAF()) {
            UIDefaults defaults = UIManager.getLookAndFeelDefaults();
            defaults.put("TextPane.background", this.bg);
            defaults.put("TextPane.foreground", this.fg);
            textPane.putClientProperty("Nimbus.Overrides", defaults);
            textPane.putClientProperty("Nimbus.Overrides.InheritDefaults", true);
        }
        return textPane;
    }

    @Override
    public void paintComponent(Graphics g) {
        int h;
        int w;
        Graphics2D g2;
        super.paintComponent(g);
        if (this.cg != null && !this.cg.equals((Object)NullCustomGraphics.getNullObject())) {
            g2 = (Graphics2D)g.create();
            w = this.getWidth();
            h = this.getHeight();
            Rectangle2D.Float bounds = new Rectangle2D.Float(0.0f, 0.0f, w, h);
            for (CustomGraphicLayer layer : this.cg.getLayers(this.tableView, this.columnView, this.row)) {
                if (layer instanceof PaintedShape) {
                    PaintedShape ps = (PaintedShape)layer;
                    Shape shape = ps.getShape();
                    if (ps.getStroke() != null) {
                        Paint strokePaint = ps.getStrokePaint();
                        if (strokePaint == null) {
                            strokePaint = Color.BLACK;
                        }
                        g2.setPaint(strokePaint);
                        g2.setStroke(ps.getStroke());
                        g2.draw(shape);
                    }
                    g2.setPaint(ps.getPaint());
                    g2.fill(shape);
                    continue;
                }
                if (layer instanceof Cy2DGraphicLayer) {
                    if (layer instanceof SVGLayer) {
                        Rectangle2D.Double rect = new Rectangle2D.Double((float)w / 2.0f, (float)h / 2.0f, w, h);
                        ((SVGLayer)layer).draw(g2, (Shape)rect, (Rectangle2D)rect);
                        continue;
                    }
                    layer = this.affineTransform(layer);
                    ((Cy2DGraphicLayer)layer).draw(g2, this.tableView, this.col, this.row);
                    continue;
                }
                if (layer instanceof ImageCustomGraphicLayer) {
                    Rectangle b = layer.getBounds2D().getBounds();
                    if (b != null) {
                        double cgW = b.getWidth();
                        double cgH = b.getHeight();
                        if ((double)w != cgW || (double)h != cgH) {
                            double scale = Math.min((double)w / cgW, (double)h / cgH);
                            AffineTransform xform = AffineTransform.getScaleInstance(scale, scale);
                            layer = layer.transform(xform);
                            b = layer.getBounds2D().getBounds();
                        }
                    }
                    double cw = b.getWidth();
                    double ch = b.getHeight();
                    double xOffset = ((double)w - cw) / 2.0;
                    double yOffset = ((double)h - ch) / 2.0;
                    BufferedImage img = ((ImageCustomGraphicLayer)layer).getPaint((Rectangle2D)b).getImage();
                    g2.drawImage(img, (int)xOffset, (int)yOffset, (int)cw, (int)ch, null);
                    continue;
                }
                g2.setPaint(layer.getPaint((Rectangle2D)bounds));
                g2.fill(bounds);
            }
            g2.dispose();
        }
        if (this.isEquation) {
            g2 = (Graphics2D)g.create();
            w = 8;
            h = 8;
            int[] xPoints = new int[]{0, 0, w};
            int[] yPoints = new int[]{h, 0, 0};
            g2.setColor(LookAndFeelUtil.getSuccessColor());
            g2.fillPolygon(xPoints, yPoints, 3);
            g2.dispose();
        }
    }

    private CustomGraphicLayer affineTransform(CustomGraphicLayer layer) {
        Rectangle2D b = layer.getBounds2D();
        if (b != null) {
            int pad;
            int x = pad = 1;
            int y = pad;
            double w = this.getWidth() - 2 * pad;
            double h = this.getHeight() - 2 * pad;
            double cw = b.getWidth();
            double ch = b.getHeight();
            double cx = b.getX();
            double cy = b.getY();
            double xOffset = -cx + (double)x + (w - cw) / 2.0;
            double yOffset = -cy + (double)y + (h - ch) / 2.0;
            AffineTransform xform = new AffineTransform();
            xform.translate(xOffset, yOffset);
            xform.scale(w / cw, h / ch);
            layer = layer.transform(xform);
        }
        return layer;
    }

    private class WrappedHtmlEditorKit
    extends HTMLEditorKit {
        private ViewFactory viewFactory = new WrappedHtmlFactory();

        @Override
        public ViewFactory getViewFactory() {
            return this.viewFactory;
        }

        private class WrappedHtmlFactory
        extends HTMLEditorKit.HTMLFactory {
            private WrappedHtmlFactory() {
            }

            @Override
            public View create(Element elem) {
                View v = super.create(elem);
                if (v instanceof LabelView) {
                    Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
                    if (o instanceof HTML.Tag && o == HTML.Tag.BR) {
                        return v;
                    }
                    return new WrapLabelView(elem);
                }
                return v;
            }

            private class WrapLabelView
            extends LabelView {
                public WrapLabelView(Element elem) {
                    super(elem);
                }

                @Override
                public float getMinimumSpan(int axis) {
                    switch (axis) {
                        case 0: {
                            return 0.0f;
                        }
                        case 1: {
                            return super.getMinimumSpan(axis);
                        }
                    }
                    throw new IllegalArgumentException("Invalid axis: " + axis);
                }
            }
        }
    }
}

