/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.equation;

import java.awt.Color;
import java.awt.Font;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.table.internal.equation.EquationTokenMaker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.TokenMaker;

public class SyntaxAreaFactory {
    public static RSyntaxTextArea createEquationTextArea(CyServiceRegistrar registrar) {
        RSyntaxTextArea textArea = new RSyntaxTextArea();
        SyntaxAreaFactory.installTokeniser(textArea, registrar);
        SyntaxAreaFactory.installSyntaxScheme(textArea);
        return textArea;
    }

    private static void installTokeniser(RSyntaxTextArea textArea, CyServiceRegistrar registrar) {
        EquationTokenMaker tokenMaker = new EquationTokenMaker(registrar);
        ((RSyntaxDocument)textArea.getDocument()).setSyntaxStyle((TokenMaker)tokenMaker);
    }

    private static void installSyntaxScheme(RSyntaxTextArea textArea) {
        textArea.setCodeFoldingEnabled(false);
        textArea.setHighlightCurrentLine(false);
        textArea.setAutoIndentEnabled(false);
        Font bold = RSyntaxTextArea.getDefaultFont().deriveFont(1);
        Color function = Style.DEFAULT_FOREGROUND;
        Color identifier = Style.DEFAULT_FOREGROUND;
        Color literal = new Color(50, 109, 168);
        SyntaxScheme scheme = new SyntaxScheme(false);
        scheme.setStyle(8, new Style(function, null, bold));
        scheme.setStyle(20, new Style(identifier));
        scheme.setStyle(13, new Style(literal));
        scheme.setStyle(9, new Style(literal));
        scheme.setStyle(11, new Style(literal));
        for (int i = 0; i < scheme.getStyleCount(); ++i) {
            if (scheme.getStyle(i) != null) continue;
            scheme.setStyle(i, new Style());
        }
        textArea.setSyntaxScheme(scheme);
        textArea.setText("");
    }
}

