/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.equation;

import java.awt.Dimension;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.cytoscape.model.CyColumn;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.table.internal.equation.FunctionInfo;
import org.cytoscape.view.table.internal.equation.InfoPanel;
import org.cytoscape.view.table.internal.equation.ItemListPanel;
import org.cytoscape.view.table.internal.equation.SyntaxAreaPanel;
import org.cytoscape.view.table.internal.impl.BrowserTable;

public class EquationEditorPanel
extends JPanel {
    private final CyServiceRegistrar registrar;
    private final BrowserTable browserTable;
    private SyntaxAreaPanel syntaxPanel;
    private ItemListPanel<String> tutorialPanel;
    private ItemListPanel<FunctionInfo> functionPanel;
    private ItemListPanel<CyColumn> attributePanel;
    private InfoPanel infoPanel;
    private JPanel buttonPanel;
    private JButton closeButton;

    public EquationEditorPanel(CyServiceRegistrar registrar, BrowserTable browserTable) {
        this.registrar = registrar;
        this.browserTable = browserTable;
        this.init();
    }

    private void init() {
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        GroupLayout layout = new GroupLayout(this);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        this.setLayout(layout);
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getSyntaxPanel(), 0, 120, 120).addGap(20).addGroup(layout.createParallelGroup().addComponent(this.getFunctionPanel(), 0, 80, Short.MAX_VALUE).addComponent(this.getAttributePanel(), 0, 80, Short.MAX_VALUE).addComponent(this.getTutorialPanel(), 0, 80, Short.MAX_VALUE)).addComponent(this.getInfoPanel()).addGap(20).addComponent(this.getButtonPanel()));
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.getSyntaxPanel()).addGroup(layout.createSequentialGroup().addComponent(this.getFunctionPanel(), 0, 200, Short.MAX_VALUE).addComponent(this.getAttributePanel(), 0, 200, Short.MAX_VALUE).addComponent(this.getTutorialPanel(), 0, 200, Short.MAX_VALUE)).addComponent(this.getInfoPanel()).addComponent(this.getButtonPanel()));
    }

    public SyntaxAreaPanel getSyntaxPanel() {
        if (this.syntaxPanel == null) {
            this.syntaxPanel = new SyntaxAreaPanel(this.registrar, this.browserTable);
            Dimension p = this.syntaxPanel.getPreferredSize();
            this.syntaxPanel.setPreferredSize(new Dimension(p.width, 50));
        }
        return this.syntaxPanel;
    }

    public ItemListPanel<String> getTutorialPanel() {
        if (this.tutorialPanel == null) {
            this.tutorialPanel = new ItemListPanel("Syntax");
        }
        return this.tutorialPanel;
    }

    public ItemListPanel<FunctionInfo> getFunctionPanel() {
        if (this.functionPanel == null) {
            this.functionPanel = new ItemListPanel("Functions");
        }
        return this.functionPanel;
    }

    public ItemListPanel<CyColumn> getAttributePanel() {
        if (this.attributePanel == null) {
            this.attributePanel = new ItemListPanel("Attributes");
        }
        return this.attributePanel;
    }

    public InfoPanel getInfoPanel() {
        if (this.infoPanel == null) {
            this.infoPanel = new InfoPanel();
        }
        return this.infoPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            String help = "http://manual.cytoscape.org/en/stable/Column_Data_Functions_and_Equations.html";
            this.buttonPanel = LookAndFeelUtil.createOkCancelPanel(null, (JButton)this.getCloseButton(), (String)help);
        }
        return this.buttonPanel;
    }

    public JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton("Close");
        }
        return this.closeButton;
    }
}

