/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal;

import java.awt.Font;
import java.util.Properties;
import javax.swing.Icon;
import org.cytoscape.application.TableViewRenderer;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.TableCellTaskFactory;
import org.cytoscape.task.TableColumnTaskFactory;
import org.cytoscape.task.TableTaskFactory;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.table.CyTableViewFactory;
import org.cytoscape.view.model.table.CyTableViewFactoryProvider;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.table.internal.BrowserTableVisualLexicon;
import org.cytoscape.view.table.internal.TableViewRendererImpl;
import org.cytoscape.view.table.internal.equation.EquationEditorDialogFactory;
import org.cytoscape.view.table.internal.equation.EquationEditorTaskFactory;
import org.cytoscape.view.table.internal.impl.PopupMenuHelper;
import org.osgi.framework.BundleContext;

public class CyActivator
extends AbstractCyActivator {
    public void start(BundleContext bc) {
        CyServiceRegistrar registrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        IconManager iconManager = (IconManager)this.getService(bc, IconManager.class);
        PopupMenuHelper popupMenuHelper = new PopupMenuHelper(registrar);
        this.registerServiceListener(bc, popupMenuHelper::addTableColumnTaskFactory, popupMenuHelper::removeTableColumnTaskFactory, TableColumnTaskFactory.class);
        this.registerServiceListener(bc, popupMenuHelper::addTableCellTaskFactory, popupMenuHelper::removeTableCellTaskFactory, TableCellTaskFactory.class);
        BrowserTableVisualLexicon lexicon = new BrowserTableVisualLexicon();
        CyTableViewFactoryProvider tableViewFactoryFactory = (CyTableViewFactoryProvider)this.getService(bc, CyTableViewFactoryProvider.class);
        CyTableViewFactory tableViewFactory = tableViewFactoryFactory.createTableViewFactory((VisualLexicon)lexicon, "org.cytoscape.view.table.renderer");
        TableViewRendererImpl renderer = new TableViewRendererImpl(registrar, tableViewFactory, lexicon, popupMenuHelper);
        this.registerService(bc, renderer, TableViewRenderer.class);
        this.registerService(bc, tableViewFactory, CyTableViewFactory.class);
        Object factory = renderer.getRenderingEngineFactory("");
        Properties props = new Properties();
        props.setProperty("id", "org.cytoscape.view.table.renderer");
        this.registerService(bc, factory, RenderingEngineFactory.class, props);
        factory = new EquationEditorDialogFactory(registrar);
        this.registerService(bc, factory, EquationEditorDialogFactory.class);
        Font iconFont = null;
        try {
            iconFont = Font.createFont(0, ((Object)((Object)this)).getClass().getResourceAsStream("/fonts/jsMath-cmti10.ttf"));
            iconFont = iconFont.deriveFont(18.0f);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading font", e);
        }
        TextIcon icon = new TextIcon("f(x)", iconFont, 32, 31);
        String iconId = "cy::FN_BUILDER";
        iconManager.addIcon(iconId, (Icon)icon);
        EquationEditorTaskFactory factory2 = new EquationEditorTaskFactory(registrar);
        Properties props2 = new Properties();
        props2.setProperty("task", "equationEditor");
        props2.setProperty("largeIconID", iconId);
        props2.setProperty("tooltip", "Function Builder...");
        props2.setProperty("inNodeTableToolBar", "true");
        props2.setProperty("inEdgeTableToolBar", "true");
        props2.setProperty("inNetworkTableToolBar", "true");
        props2.setProperty("inUnassignedTableToolBar", "true");
        props2.setProperty("toolBarGravity", "0.005");
        props2.setProperty("insertToolbarSeparatorBefore", "true");
        props2.setProperty("insertToolbarSeparatorAfter", "true");
        this.registerService(bc, factory2, TableTaskFactory.class, props2);
    }
}

