/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.internal;

import java.util.Properties;
import javax.swing.KeyStroke;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.io.webservice.NetworkImportWebServiceClient;
import org.cytoscape.io.webservice.TableImportWebServiceClient;
import org.cytoscape.io.webservice.WebServiceClient;
import org.cytoscape.io.webservice.swing.WebServiceGUI;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.webservice.internal.task.ShowImportDialogAction;
import org.cytoscape.webservice.internal.ui.WebServiceGUIImpl;
import org.cytoscape.webservice.internal.ui.WebServiceImportDialog;
import org.osgi.framework.BundleContext;

public class CyActivator
extends AbstractCyActivator {
    public void start(BundleContext bc) {
        CyServiceRegistrar serviceRegistrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        WebServiceImportDialog<NetworkImportWebServiceClient> unifiedNetworkImportDialog = new WebServiceImportDialog<NetworkImportWebServiceClient>(NetworkImportWebServiceClient.class, "Import Network from Public Databases", serviceRegistrar);
        WebServiceImportDialog<TableImportWebServiceClient> unifiedTableImportDialog = new WebServiceImportDialog<TableImportWebServiceClient>(TableImportWebServiceClient.class, "Import Table from Public Databases", serviceRegistrar);
        WebServiceGUIImpl webServiceGui = new WebServiceGUIImpl();
        webServiceGui.addClient(NetworkImportWebServiceClient.class, unifiedNetworkImportDialog);
        webServiceGui.addClient(TableImportWebServiceClient.class, unifiedTableImportDialog);
        KeyStroke networkImportShortcut = KeyStroke.getKeyStroke(76, 512);
        KeyStroke tableImportShortcut = KeyStroke.getKeyStroke(84, 512);
        ShowImportDialogAction showImportNetworkFromWebServiceDialogAction = new ShowImportDialogAction(unifiedNetworkImportDialog, "File.Import[23]", 0.5f, "Network from Public Databases...", networkImportShortcut, "Import a network from a curated database", serviceRegistrar);
        ShowImportDialogAction showImportTableFromWebServiceDialogAction = new ShowImportDialogAction(unifiedTableImportDialog, "File.Import[23]", 7.0f, "Table from Public Databases...", tableImportShortcut, serviceRegistrar);
        Properties props = new Properties();
        props.setProperty("id", "showImportNetworkFromWebServiceDialogAction");
        this.registerService(bc, (Object)showImportNetworkFromWebServiceDialogAction, CyAction.class, props);
        this.registerService(bc, (Object)showImportTableFromWebServiceDialogAction, CyAction.class, new Properties());
        this.registerService(bc, webServiceGui, WebServiceGUI.class, new Properties());
        this.registerServiceListener(bc, unifiedNetworkImportDialog::addClient, unifiedNetworkImportDialog::removeClient, WebServiceClient.class);
        this.registerServiceListener(bc, unifiedTableImportDialog::addClient, unifiedTableImportDialog::removeClient, WebServiceClient.class);
    }
}

