/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.layout.internal.algorithms;

import java.util.Set;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.layout.AbstractLayoutTask;
import org.cytoscape.view.layout.internal.algorithms.GridNodeLayoutContext;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.UndoSupport;

public class GridNodeLayoutTask
extends AbstractLayoutTask {
    private final double nodeVerticalSpacing;
    private final double nodeHorizontalSpacing;

    public GridNodeLayoutTask(String name, CyNetworkView networkView, Set<View<CyNode>> nodesToLayOut, GridNodeLayoutContext context, String attrName, UndoSupport undoSupport) {
        super(name, networkView, nodesToLayOut, attrName, undoSupport);
        this.nodeVerticalSpacing = context.nodeVerticalSpacing;
        this.nodeHorizontalSpacing = context.nodeHorizontalSpacing;
        this.recenter = false;
    }

    protected final void doLayout(TaskMonitor taskMonitor) {
        double currX = 0.0;
        double currY = 0.0;
        double initialX = 0.0;
        double initialY = 0.0;
        int nodeCount = this.nodesToLayOut.size();
        int columns = (int)Math.sqrt(nodeCount);
        for (View nView : this.nodesToLayOut) {
            initialX += (Double)nView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION) / (double)nodeCount;
            initialY += (Double)nView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION) / (double)nodeCount;
        }
        currX = initialX -= this.nodeHorizontalSpacing * (double)(columns - 1) / 2.0;
        currY = initialY -= this.nodeVerticalSpacing * (double)(columns - 1) / 2.0;
        int count = 0;
        for (View nView : this.nodesToLayOut) {
            nView.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)currX);
            nView.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)currY);
            if (++count == columns) {
                count = 0;
                currX = initialX;
                currY += this.nodeVerticalSpacing;
                continue;
            }
            currX += this.nodeHorizontalSpacing;
        }
    }
}

