/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.intr;

import java.io.Serializable;
import org.cytoscape.util.intr.IntEnumerator;

public final class IntHash
implements Serializable {
    private static final long serialVersionUID = 1213745949547L;
    private static final int[] PRIMES = new int[]{11, 23, 53, 113, 251, 509, 1019, 2039, 4079, 8179, 16369, 32749, 65521, 131063, 262133, 524269, 1048571, 0x1FFFF7, 0x3FFFEF, 8388587, 0xFFFFDF, 33554393, 67108837, 134217689, 0xFFFFFC7, 0x1FFFFFDF, 0x3FFFFFDD, Integer.MAX_VALUE};
    private static final int INITIAL_SIZE = PRIMES[0];
    private static final double THRESHOLD_FACTOR = 0.77;
    private int[] m_arr = new int[INITIAL_SIZE];
    private int m_elements;
    private int m_size;
    private int m_thresholdSize;
    private int[] m_dump = null;

    public IntHash() {
        this.empty();
    }

    public final void empty() {
        this.m_elements = 0;
        this.m_size = INITIAL_SIZE;
        this.m_thresholdSize = (int)(0.77 * (double)this.m_size);
        for (int i = 0; i < this.m_size; ++i) {
            this.m_arr[i] = -1;
        }
    }

    public final int size() {
        return this.m_elements;
    }

    public final int put(int value) {
        int index;
        if (this.m_elements == this.m_thresholdSize) {
            this.incrSize();
        }
        int incr = 0;
        try {
            index = value % ((~value >>> 31) * this.m_size);
            while (this.m_arr[index] >= 0 && this.m_arr[index] != value) {
                if (incr == 0) {
                    incr = 1 + value % (this.m_size - 1);
                }
                index = (index + incr) % this.m_size;
            }
        }
        catch (ArithmeticException exc) {
            throw new IllegalArgumentException("value is negative");
        }
        int returnVal = this.m_arr[index];
        this.m_arr[index] = value;
        this.m_elements += returnVal >>> 31;
        return returnVal;
    }

    public final int get(int value) {
        int index;
        int incr = 0;
        try {
            index = value % ((~value >>> 31) * this.m_size);
            while (this.m_arr[index] >= 0 && this.m_arr[index] != value) {
                if (incr == 0) {
                    incr = 1 + value % (this.m_size - 1);
                }
                index = (index + incr) % this.m_size;
            }
        }
        catch (ArithmeticException exc) {
            throw new IllegalArgumentException("value is negative");
        }
        return this.m_arr[index];
    }

    public final IntEnumerator elements() {
        final int[] array = this.m_arr;
        final int numElements = this.m_elements;
        return new IntEnumerator(){
            int elements;
            int index;
            {
                this.elements = numElements;
                this.index = -1;
            }

            @Override
            public int numRemaining() {
                return this.elements;
            }

            @Override
            public int nextInt() {
                while (array[++this.index] < 0) {
                }
                --this.elements;
                return array[this.index];
            }
        };
    }

    private final void incrSize() {
        int newSize;
        try {
            int primesInx = 0;
            while (this.m_size != PRIMES[primesInx++]) {
            }
            newSize = PRIMES[primesInx];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalStateException("too many elements in this hashtable");
        }
        if (this.m_arr.length < newSize) {
            this.m_dump = this.m_arr;
            this.m_arr = new int[newSize];
        } else {
            System.arraycopy(this.m_arr, 0, this.m_dump, 0, this.m_size);
        }
        for (int i = 0; i < newSize; ++i) {
            this.m_arr[i] = -1;
        }
        this.m_size = newSize;
        this.m_thresholdSize = (int)(0.77 * (double)this.m_size);
        int oldIndex = -1;
        for (int i = 0; i < this.m_elements; ++i) {
            while (this.m_dump[++oldIndex] < 0) {
            }
            int incr = 0;
            int newIndex = this.m_dump[oldIndex] % this.m_size;
            while (this.m_arr[newIndex] >= 0) {
                if (incr == 0) {
                    incr = 1 + this.m_dump[oldIndex] % (this.m_size - 1);
                }
                newIndex = (newIndex + incr) % this.m_size;
            }
            this.m_arr[newIndex] = this.m_dump[oldIndex];
        }
    }
}

