/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.intr;

import java.io.Serializable;
import org.cytoscape.util.intr.IntEnumerator;

public final class IntBTree
implements Serializable {
    private static final long serialVersionUID = 1213745949101434L;
    public static final int DEFAULT_MAX_BRANCHES = 27;
    private final int m_maxBranches;
    private final int m_minBranches;
    private Node m_root;

    public IntBTree() {
        this(27);
    }

    public IntBTree(int maxBranches) {
        this.m_maxBranches = maxBranches;
        this.m_minBranches = Math.max(2, (int)((double)(this.m_maxBranches + 1) * 0.4));
        this.m_root = new Node(this.m_maxBranches, true);
    }

    public final void empty() {
        this.m_root = new Node(this.m_maxBranches, true);
    }

    public final int size() {
        return IntBTree.isLeafNode(this.m_root) ? this.m_root.sliceCount : this.m_root.data.deepCount;
    }

    private static final boolean isLeafNode(Node n) {
        return n.data == null;
    }

    public final void insert(int x) {
        Node newSibling = IntBTree.insert(this.m_root, x, this.m_maxBranches);
        if (newSibling != null) {
            int newDeepCount;
            int newSplitVal;
            if (IntBTree.isLeafNode(newSibling)) {
                newSplitVal = newSibling.values[0];
                newDeepCount = this.m_root.sliceCount + newSibling.sliceCount;
            } else {
                newSplitVal = this.m_root.data.splitVals[this.m_root.sliceCount - 1];
                newDeepCount = this.m_root.data.deepCount + newSibling.data.deepCount;
            }
            Node newRoot = new Node(this.m_maxBranches, false);
            newRoot.sliceCount = 2;
            newRoot.data.deepCount = newDeepCount;
            newRoot.data.splitVals[0] = newSplitVal;
            newRoot.data.children[0] = this.m_root;
            newRoot.data.children[1] = newSibling;
            this.m_root = newRoot;
        }
    }

    private static final Node insert(Node n, int x, int maxBranches) {
        Node oldChild;
        Node newChild;
        if (IntBTree.isLeafNode(n)) {
            if (n.sliceCount < maxBranches) {
                int i = -1;
                while (++i < n.sliceCount && x > n.values[i]) {
                }
                int j = n.sliceCount;
                while (j > i) {
                    n.values[j--] = n.values[j];
                }
                n.values[i] = x;
                ++n.sliceCount;
                return null;
            }
            Node newLeafSibling = new Node(maxBranches, true);
            int combinedCount = maxBranches + 1;
            n.sliceCount = combinedCount >> 1;
            newLeafSibling.sliceCount = combinedCount - n.sliceCount;
            IntBTree.split(x, n.values, newLeafSibling.values, newLeafSibling.sliceCount);
            return newLeafSibling;
        }
        int foundPath = 0;
        for (int i = n.sliceCount - 2; i >= 0; --i) {
            if (x < n.data.splitVals[i]) continue;
            foundPath = i + 1;
            break;
        }
        if ((newChild = IntBTree.insert(oldChild = n.data.children[foundPath], x, maxBranches)) == null) {
            ++n.data.deepCount;
            return null;
        }
        int newSplit = IntBTree.isLeafNode(newChild) ? newChild.values[0] : oldChild.data.splitVals[oldChild.sliceCount - 1];
        if (n.sliceCount < maxBranches) {
            int j = n.sliceCount - 1;
            while (j > foundPath) {
                n.data.children[j + 1] = n.data.children[j];
                n.data.splitVals[j--] = n.data.splitVals[j];
            }
            ++n.sliceCount;
            ++n.data.deepCount;
            n.data.children[foundPath + 1] = newChild;
            n.data.splitVals[foundPath] = newSplit;
            return null;
        }
        Node newInternalSibling = new Node(maxBranches, false);
        int combinedCount = maxBranches + 1;
        n.sliceCount = combinedCount >> 1;
        newInternalSibling.sliceCount = combinedCount - n.sliceCount;
        IntBTree.split(newChild, foundPath, n.data.children, newInternalSibling.data.children, newInternalSibling.sliceCount);
        IntBTree.split(newSplit, n.data.splitVals, newInternalSibling.data.splitVals, newInternalSibling.sliceCount - 1);
        n.data.deepCount = 0;
        if (IntBTree.isLeafNode(newChild)) {
            int i;
            for (i = 0; i < n.sliceCount; ++i) {
                n.data.deepCount += n.data.children[i].sliceCount;
            }
            for (i = 0; i < newInternalSibling.sliceCount; ++i) {
                newInternalSibling.data.deepCount += newInternalSibling.data.children[i].sliceCount;
            }
        } else {
            int i;
            for (i = 0; i < n.sliceCount; ++i) {
                n.data.deepCount += n.data.children[i].data.deepCount;
            }
            for (i = 0; i < newInternalSibling.sliceCount; ++i) {
                newInternalSibling.data.deepCount += newInternalSibling.data.children[i].data.deepCount;
            }
        }
        return newInternalSibling;
    }

    private static final void split(int newVal, int[] origBuff, int[] overflowBuff, int overflowCount) {
        int[] currentArr = overflowBuff;
        int currentInx = overflowCount;
        boolean found = false;
        for (int i = origBuff.length - 1; i >= 0; --i) {
            if (!found && newVal >= origBuff[i]) {
                currentArr[--currentInx] = newVal;
                found = true;
                if (currentArr == origBuff) break;
                ++i;
            } else {
                currentArr[--currentInx] = origBuff[i];
            }
            if (currentInx != 0) continue;
            if (found) break;
            currentArr = origBuff;
            currentInx = origBuff.length - overflowCount + 1;
        }
        if (!found) {
            currentArr[0] = newVal;
        }
    }

    private static final void split(Node newNode, int newInx, Node[] origNodes, Node[] overflowNodes, int overflowCount) {
        int i;
        Node[] currentNodes = overflowNodes;
        int currentInx = overflowCount;
        for (i = origNodes.length - 1; i >= 0; --i) {
            if (newNode != null && i == newInx) {
                currentNodes[--currentInx] = newNode;
                newNode = null;
                if (currentNodes == origNodes) break;
                ++i;
            } else {
                currentNodes[--currentInx] = origNodes[i];
            }
            if (currentInx != 0) continue;
            if (newNode == null) break;
            currentNodes = origNodes;
            currentInx = origNodes.length - overflowCount + 1;
        }
        for (i = origNodes.length - overflowCount + 1; i < origNodes.length; ++i) {
            origNodes[i] = null;
        }
    }

    public final boolean delete(int x) {
        boolean returnThis = IntBTree.delete(this.m_root, x, this.m_minBranches);
        if (!IntBTree.isLeafNode(this.m_root) && this.m_root.sliceCount == 1) {
            this.m_root = this.m_root.data.children[0];
        }
        return returnThis;
    }

    private static final boolean delete(Node n, int x, int minBranches) {
        if (IntBTree.isLeafNode(n)) {
            int foundInx = -1;
            for (int i = 0; i < n.sliceCount; ++i) {
                if (x > n.values[i]) continue;
                if (x != n.values[i]) break;
                foundInx = i;
                break;
            }
            if (foundInx < 0) {
                return false;
            }
            IntBTree.fillHole(foundInx, n.values, --n.sliceCount);
            return true;
        }
        int deletedPath = -1;
        for (int i = n.sliceCount - 2; i >= -1; --i) {
            int currentMin;
            int n2 = currentMin = i < 0 ? Integer.MIN_VALUE : n.data.splitVals[i];
            if (currentMin > x) continue;
            if (IntBTree.delete(n.data.children[i + 1], x, minBranches)) {
                --n.data.deepCount;
                deletedPath = i + 1;
                break;
            }
            if (currentMin < x) break;
        }
        if (deletedPath < 0) {
            return false;
        }
        Node affectedChild = n.data.children[deletedPath];
        if (affectedChild.sliceCount < minBranches) {
            Node rightChild;
            Node leftChild = deletedPath > 0 ? n.data.children[deletedPath - 1] : null;
            Node node = rightChild = deletedPath + 1 < n.sliceCount ? n.data.children[deletedPath + 1] : null;
            if (leftChild != null && leftChild.sliceCount > minBranches) {
                n.data.splitVals[deletedPath - 1] = IntBTree.distributeFromLeft(leftChild, affectedChild, n.data.splitVals[deletedPath - 1], minBranches);
            } else if (rightChild != null && rightChild.sliceCount > minBranches) {
                n.data.splitVals[deletedPath] = IntBTree.distributeFromRight(rightChild, affectedChild, n.data.splitVals[deletedPath], minBranches);
            } else {
                int holeInx;
                if (leftChild != null) {
                    holeInx = deletedPath - 1;
                    IntBTree.mergeSiblings(leftChild, affectedChild, n.data.splitVals[holeInx]);
                } else {
                    holeInx = deletedPath;
                    IntBTree.mergeSiblings(affectedChild, rightChild, n.data.splitVals[holeInx]);
                }
                IntBTree.fillHole(holeInx + 1, n.data.children, --n.sliceCount);
                IntBTree.fillHole(holeInx, n.data.splitVals, n.sliceCount - 1);
            }
        }
        return true;
    }

    private static final int distributeFromLeft(Node leftSibling, Node thisSibling, int oldSplitVal, int minBranches) {
        int i;
        int distributeNum = (1 + leftSibling.sliceCount - minBranches) / 2;
        if (IntBTree.isLeafNode(leftSibling)) {
            int i2 = thisSibling.sliceCount;
            int o = i2 + distributeNum;
            while (i2 > 0) {
                thisSibling.values[--o] = thisSibling.values[--i2];
            }
            i2 = leftSibling.sliceCount - distributeNum;
            o = 0;
            while (o < distributeNum) {
                thisSibling.values[o++] = leftSibling.values[i2++];
            }
            leftSibling.sliceCount -= distributeNum;
            thisSibling.sliceCount += distributeNum;
            return thisSibling.values[0];
        }
        int returnThis = leftSibling.data.splitVals[leftSibling.sliceCount - distributeNum - 1];
        int i3 = thisSibling.sliceCount;
        int o = i3 + distributeNum;
        while (i3 > 0) {
            thisSibling.data.children[--o] = thisSibling.data.children[--i3];
        }
        i3 = leftSibling.sliceCount - distributeNum;
        o = 0;
        while (o < distributeNum) {
            thisSibling.data.children[o++] = leftSibling.data.children[i3++];
        }
        boolean leafChildren = IntBTree.isLeafNode(leftSibling.data.children[0]);
        int deepCountDiff = 0;
        for (i = leftSibling.sliceCount - distributeNum; i < leftSibling.sliceCount; ++i) {
            deepCountDiff += leafChildren ? leftSibling.data.children[i].sliceCount : leftSibling.data.children[i].data.deepCount;
            leftSibling.data.children[i] = null;
        }
        i = thisSibling.sliceCount - 1;
        int o2 = i + distributeNum;
        while (i > 0) {
            thisSibling.data.splitVals[--o2] = thisSibling.data.splitVals[--i];
        }
        thisSibling.data.splitVals[distributeNum - 1] = oldSplitVal;
        i = leftSibling.sliceCount - distributeNum;
        o2 = 0;
        while (o2 < distributeNum - 1) {
            thisSibling.data.splitVals[o2++] = leftSibling.data.splitVals[i++];
        }
        leftSibling.sliceCount -= distributeNum;
        thisSibling.sliceCount += distributeNum;
        leftSibling.data.deepCount -= deepCountDiff;
        thisSibling.data.deepCount += deepCountDiff;
        return returnThis;
    }

    private static final int distributeFromRight(Node rightSibling, Node thisSibling, int oldSplitVal, int minBranches) {
        int distributeNum = (1 + rightSibling.sliceCount - minBranches) / 2;
        if (IntBTree.isLeafNode(rightSibling)) {
            int i = 0;
            int o = thisSibling.sliceCount;
            while (i < distributeNum) {
                thisSibling.values[o++] = rightSibling.values[i++];
            }
            i = 0;
            o = distributeNum;
            while (o < rightSibling.sliceCount) {
                rightSibling.values[i++] = rightSibling.values[o++];
            }
            rightSibling.sliceCount -= distributeNum;
            thisSibling.sliceCount += distributeNum;
            return rightSibling.values[0];
        }
        int returnThis = rightSibling.data.splitVals[distributeNum - 1];
        boolean leafChildren = IntBTree.isLeafNode(rightSibling.data.children[0]);
        int deepCountDiff = 0;
        int i = 0;
        int o = thisSibling.sliceCount;
        while (i < distributeNum) {
            deepCountDiff += leafChildren ? rightSibling.data.children[i].sliceCount : rightSibling.data.children[i].data.deepCount;
            thisSibling.data.children[o++] = rightSibling.data.children[i++];
        }
        i = distributeNum;
        o = 0;
        while (i < rightSibling.sliceCount) {
            rightSibling.data.children[o++] = rightSibling.data.children[i++];
        }
        for (i = rightSibling.sliceCount - distributeNum; i < rightSibling.sliceCount; ++i) {
            rightSibling.data.children[i] = null;
        }
        thisSibling.data.splitVals[thisSibling.sliceCount - 1] = oldSplitVal;
        i = 0;
        o = thisSibling.sliceCount;
        while (i < distributeNum - 1) {
            thisSibling.data.splitVals[o++] = rightSibling.data.splitVals[i++];
        }
        i = distributeNum;
        o = 0;
        while (i < rightSibling.sliceCount - 1) {
            rightSibling.data.splitVals[o++] = rightSibling.data.splitVals[i++];
        }
        rightSibling.sliceCount -= distributeNum;
        thisSibling.sliceCount += distributeNum;
        rightSibling.data.deepCount -= deepCountDiff;
        thisSibling.data.deepCount += deepCountDiff;
        return returnThis;
    }

    private static final void mergeSiblings(Node leftSibling, Node rightSibling, int splitValue) {
        if (IntBTree.isLeafNode(leftSibling)) {
            int i = 0;
            int o = leftSibling.sliceCount;
            while (i < rightSibling.sliceCount) {
                leftSibling.values[o++] = rightSibling.values[i++];
            }
            leftSibling.sliceCount += rightSibling.sliceCount;
            rightSibling.sliceCount = 0;
        } else {
            int i = 0;
            int o = leftSibling.sliceCount;
            while (i < rightSibling.sliceCount - 1) {
                leftSibling.data.splitVals[o++] = rightSibling.data.splitVals[i++];
            }
            leftSibling.data.splitVals[leftSibling.sliceCount - 1] = splitValue;
            i = 0;
            o = leftSibling.sliceCount;
            while (i < rightSibling.sliceCount) {
                leftSibling.data.children[o++] = rightSibling.data.children[i++];
            }
            for (i = 0; i < rightSibling.sliceCount; ++i) {
                rightSibling.data.children[i] = null;
            }
            leftSibling.sliceCount += rightSibling.sliceCount;
            rightSibling.sliceCount = 0;
            leftSibling.data.deepCount += rightSibling.data.deepCount;
            rightSibling.data.deepCount = 0;
        }
    }

    private static final void fillHole(int holeInx, int[] arr, int newLen) {
        int i = holeInx;
        while (i < newLen) {
            arr[i++] = arr[i];
        }
    }

    private static final void fillHole(int holeInx, Node[] arr, int newLen) {
        int i = holeInx;
        while (i < newLen) {
            arr[i++] = arr[i];
        }
        arr[i] = null;
    }

    public final int count(int x) {
        return IntBTree.count(this.m_root, x, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private static final int count(Node n, int x, int minBound, int maxBound) {
        int count = 0;
        if (minBound == maxBound) {
            count += IntBTree.isLeafNode(n) ? n.sliceCount : n.data.deepCount;
        } else if (IntBTree.isLeafNode(n)) {
            for (int i = 0; i < n.sliceCount; ++i) {
                if (x > n.values[i]) continue;
                if (x == n.values[i]) {
                    ++count;
                    continue;
                }
                break;
            }
        } else {
            int currentMax = maxBound;
            for (int i = n.sliceCount - 2; i >= -1; --i) {
                int currentMin;
                int n2 = currentMin = i < 0 ? minBound : n.data.splitVals[i];
                if (currentMin <= x) {
                    count += IntBTree.count(n.data.children[i + 1], x, currentMin, currentMax);
                    if (currentMin < x) break;
                }
                currentMax = currentMin;
            }
        }
        return count;
    }

    public final IntEnumerator searchRange(int xMin, int xMax, boolean reverseOrder) {
        if (xMin > xMax) {
            throw new IllegalArgumentException("xMin is greater than xMax");
        }
        NodeStack nodeStack = new NodeStack();
        int totalCount = IntBTree.searchRange(this.m_root, nodeStack, xMin, xMax, Integer.MIN_VALUE, Integer.MAX_VALUE, reverseOrder);
        if (reverseOrder) {
            return new DescendingEnumerator(totalCount, nodeStack, xMax);
        }
        return new AscendingEnumerator(totalCount, nodeStack, xMin);
    }

    private static final int searchRange(Node n, NodeStack nodeStack, int xMin, int xMax, int minBound, int maxBound, boolean reverseOrder) {
        int count;
        block10: {
            block12: {
                block11: {
                    count = 0;
                    if (minBound < xMin || maxBound > xMax) break block11;
                    count += IntBTree.isLeafNode(n) ? n.sliceCount : n.data.deepCount;
                    nodeStack.push(n);
                    break block10;
                }
                if (!IntBTree.isLeafNode(n)) break block12;
                for (int i = 0; i < n.sliceCount && xMin > n.values[i]; ++i) {
                }
                for (int j = i; j < n.sliceCount && n.values[j] <= xMax; ++j) {
                    ++count;
                }
                if (count <= 0) break block10;
                nodeStack.push(n);
                break block10;
            }
            if (reverseOrder) {
                int currentMin = minBound;
                int maxInx = n.sliceCount - 1;
                for (int i = 0; i < n.sliceCount; ++i) {
                    int currentMax;
                    int n2 = currentMax = i == maxInx ? maxBound : n.data.splitVals[i];
                    if (currentMax >= xMin) {
                        count += IntBTree.searchRange(n.data.children[i], nodeStack, xMin, xMax, currentMin, currentMax, reverseOrder);
                        if (currentMax > xMax) break;
                    }
                    currentMin = currentMax;
                }
            } else {
                int currentMax = maxBound;
                for (int i = n.sliceCount - 2; i >= -1; --i) {
                    int currentMin;
                    int n3 = currentMin = i < 0 ? minBound : n.data.splitVals[i];
                    if (currentMin <= xMax) {
                        count += IntBTree.searchRange(n.data.children[i + 1], nodeStack, xMin, xMax, currentMin, currentMax, reverseOrder);
                        if (currentMin < xMin) break;
                    }
                    currentMax = currentMin;
                }
            }
        }
        return count;
    }

    private static final class DescendingEnumerator
    implements IntEnumerator {
        private int wholeLeafNodes = 0;
        private int count;
        private final NodeStack stack;
        private final int xMax;
        private Node currentLeafNode;
        private int currentNodeInx;

        private DescendingEnumerator(int totalCount, NodeStack nodeStack, int xMax) {
            this.count = totalCount;
            this.stack = nodeStack;
            this.xMax = xMax;
            this.computeNextLeafNode();
        }

        @Override
        public final int numRemaining() {
            return this.count;
        }

        @Override
        public final int nextInt() {
            int returnThis = 0;
            if (this.wholeLeafNodes != 0) {
                returnThis = this.currentLeafNode.values[this.currentNodeInx];
            } else {
                while (this.currentNodeInx >= 0) {
                    if (this.currentLeafNode.values[this.currentNodeInx] <= this.xMax) {
                        returnThis = this.currentLeafNode.values[this.currentNodeInx];
                        break;
                    }
                    --this.currentNodeInx;
                }
            }
            if (--this.currentNodeInx < 0) {
                if (this.wholeLeafNodes > 0) {
                    --this.wholeLeafNodes;
                }
                this.computeNextLeafNode();
            }
            --this.count;
            return returnThis;
        }

        private final void computeNextLeafNode() {
            if (this.stack.currentSize == 0) {
                this.currentLeafNode = null;
                return;
            }
            while (true) {
                Node next;
                if (IntBTree.isLeafNode(next = this.stack.pop())) {
                    this.currentLeafNode = next;
                    this.currentNodeInx = this.currentLeafNode.sliceCount - 1;
                    return;
                }
                for (int i = 0; i < next.sliceCount; ++i) {
                    this.stack.push(next.data.children[i]);
                }
                if (!IntBTree.isLeafNode(next.data.children[0])) continue;
                this.wholeLeafNodes += next.sliceCount;
            }
        }
    }

    private static final class AscendingEnumerator
    implements IntEnumerator {
        private int wholeLeafNodes = 0;
        private int count;
        private final NodeStack stack;
        private final int xMin;
        private Node currentLeafNode;
        private int currentNodeInx;

        private AscendingEnumerator(int totalCount, NodeStack nodeStack, int xMin) {
            this.count = totalCount;
            this.stack = nodeStack;
            this.xMin = xMin;
            this.computeNextLeafNode();
        }

        @Override
        public final int numRemaining() {
            return this.count;
        }

        @Override
        public final int nextInt() {
            int returnThis = 0;
            if (this.wholeLeafNodes != 0) {
                returnThis = this.currentLeafNode.values[this.currentNodeInx];
            } else {
                while (this.currentNodeInx < this.currentLeafNode.sliceCount) {
                    if (this.currentLeafNode.values[this.currentNodeInx] >= this.xMin) {
                        returnThis = this.currentLeafNode.values[this.currentNodeInx];
                        break;
                    }
                    ++this.currentNodeInx;
                }
            }
            if (++this.currentNodeInx == this.currentLeafNode.sliceCount) {
                if (this.wholeLeafNodes > 0) {
                    --this.wholeLeafNodes;
                }
                this.computeNextLeafNode();
            }
            --this.count;
            return returnThis;
        }

        private final void computeNextLeafNode() {
            if (this.stack.currentSize == 0) {
                this.currentLeafNode = null;
                return;
            }
            while (true) {
                Node next;
                if (IntBTree.isLeafNode(next = this.stack.pop())) {
                    this.currentLeafNode = next;
                    this.currentNodeInx = 0;
                    return;
                }
                int i = next.sliceCount;
                while (i > 0) {
                    this.stack.push(next.data.children[--i]);
                }
                if (!IntBTree.isLeafNode(next.data.children[0])) continue;
                this.wholeLeafNodes += next.sliceCount;
            }
        }
    }

    private static final class NodeStack {
        private Node[] stack = new Node[3];
        private int currentSize = 0;

        private NodeStack() {
        }

        private final void push(Node value) {
            try {
                this.stack[this.currentSize++] = value;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                --this.currentSize;
                int newStackSize = (int)Math.min(Integer.MAX_VALUE, (long)this.stack.length * 2L + 1L);
                if (newStackSize == this.stack.length) {
                    throw new IllegalStateException("cannot allocate large enough array");
                }
                Node[] newStack = new Node[newStackSize];
                System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
                this.stack = newStack;
                this.stack[this.currentSize++] = value;
            }
        }

        private final Node pop() {
            try {
                return this.stack[--this.currentSize];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                ++this.currentSize;
                throw e;
            }
        }
    }

    private static final class InternalNodeData
    implements Serializable {
        private static final long serialVersionUID = 121374594986257L;
        private int deepCount;
        private final int[] splitVals;
        private final Node[] children;

        private InternalNodeData(int maxBranches) {
            this.splitVals = new int[maxBranches - 1];
            this.children = new Node[maxBranches];
        }
    }

    private static final class Node
    implements Serializable {
        private static final long serialVersionUID = 121374594970366L;
        private int sliceCount = 0;
        private final int[] values;
        private final InternalNodeData data;

        private Node(int maxBranches, boolean leafNode) {
            if (leafNode) {
                this.values = new int[maxBranches];
                this.data = null;
            } else {
                this.values = null;
                this.data = new InternalNodeData(maxBranches);
            }
        }
    }
}

