/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.intr;

import java.io.Serializable;

public final class IntArray
implements Serializable {
    private static final long serialVersionUID = 121374594932593L;
    private static final int INITIAL_CAPACITY = 0;
    private int[] m_arr = new int[0];

    public final int getIntAtIndex(int index) {
        if (index >= this.m_arr.length && index != Integer.MAX_VALUE) {
            return 0;
        }
        return this.m_arr[index];
    }

    public final void setIntAtIndex(int value, int index) {
        if (index >= this.m_arr.length && value == 0 && index != Integer.MAX_VALUE) {
            return;
        }
        try {
            this.m_arr[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (index < 0 || index == Integer.MAX_VALUE) {
                throw e;
            }
            int newArrSize = (int)Math.min(Integer.MAX_VALUE, Math.max((long)this.m_arr.length * 2L + 1L, (long)index + 1L + 0L));
            int[] newArr = new int[newArrSize];
            System.arraycopy(this.m_arr, 0, newArr, 0, this.m_arr.length);
            this.m_arr = newArr;
            this.m_arr[index] = value;
        }
    }
}

