/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.intr;

import org.cytoscape.util.intr.IntIterator;

public final class ArrayIntIterator
implements IntIterator {
    private final int[] m_elements;
    private int m_index;
    private final int m_end;

    public ArrayIntIterator(int[] elements, int beginIndex, int length) {
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex is less than zero");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is less than zero");
        }
        if ((long)beginIndex + (long)length > (long)elements.length) {
            throw new IllegalArgumentException("combination of beginIndex and length exceed length of array");
        }
        this.m_elements = elements;
        this.m_index = beginIndex;
        this.m_end = beginIndex + length;
    }

    @Override
    public final boolean hasNext() {
        return this.m_index < this.m_end;
    }

    @Override
    public final int nextInt() {
        return this.m_elements[this.m_index++];
    }
}

