/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.graph.render.stateful;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import org.cytoscape.graph.render.stateful.LabelInfo;

public class LabelLineInfo {
    private static char[] charBuff = new char[20];
    private final LabelInfo parent;
    private final String text;
    private final double width;
    private final double height;
    private Shape shape;
    private GlyphVector glyphVector;

    public LabelLineInfo(LabelInfo parent, String text, double width, double height) {
        this.parent = parent;
        this.text = text;
        this.width = width;
        this.height = height;
    }

    private GlyphVector createGlyphVector() {
        if (this.text.length() > charBuff.length) {
            charBuff = new char[Math.max(charBuff.length * 2, this.text.length())];
        }
        this.text.getChars(0, this.text.length(), charBuff, 0);
        return this.parent.getFont().layoutGlyphVector(this.parent.getFontRenderContext(), charBuff, 0, this.text.length(), 4);
    }

    public GlyphVector getGlyphVector() {
        if (this.glyphVector == null) {
            this.glyphVector = this.createGlyphVector();
        }
        return this.glyphVector;
    }

    public Shape getShape() {
        if (this.shape == null) {
            GlyphVector glyphVector = this.getGlyphVector();
            this.shape = glyphVector.getOutline();
        }
        return this.shape;
    }

    public Font getFont() {
        return this.parent.getFont();
    }

    public String getText() {
        return this.text;
    }

    public String getLine() {
        return this.text;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public String toString() {
        return "'" + this.text + "'  w:" + this.width + " h:" + this.height;
    }
}

