/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.graph.render.stateful;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.graph.render.stateful.LabelLineInfo;

public class LabelInfo {
    private double maxLineWidth;
    private double totalHeight;
    private final double labelWidth;
    private final FontRenderContext frc;
    private final Font font;
    private final boolean textAsShape;
    private final List<LabelLineInfo> measuredLines;

    public LabelInfo(String rawLine, Font font, FontRenderContext frc, boolean textAsShape, double labelWidth) {
        this.font = font;
        this.frc = frc;
        this.textAsShape = textAsShape;
        this.labelWidth = labelWidth;
        this.measuredLines = new ArrayList<LabelLineInfo>();
        String[] lines = rawLine.split("\n");
        this.calculateRawBounds(lines);
        this.createMeasuredLines(lines);
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    private void calculateRawBounds(String[] lines) {
        this.maxLineWidth = 0.0;
        this.totalHeight = 0.0;
        for (String line : lines) {
            Rectangle2D bounds = this.calcBounds(line);
            this.updateBounds(bounds.getWidth(), bounds.getHeight());
        }
    }

    private void updateBounds(double newWidth, double newHeight) {
        this.maxLineWidth = Math.max(this.maxLineWidth, newWidth);
        this.totalHeight += newHeight;
    }

    private Rectangle2D calcBounds(String s) {
        if (this.textAsShape) {
            char[] charBuff = s.toCharArray();
            GlyphVector glyphV = this.font.layoutGlyphVector(this.frc, charBuff, 0, charBuff.length, 4);
            return glyphV.getLogicalBounds();
        }
        return this.font.getStringBounds(s, this.frc);
    }

    private void createMeasuredLines(String[] lines) {
        if (lines.length == 1 && this.labelWidth > this.maxLineWidth) {
            this.measuredLines.add(new LabelLineInfo(this, lines[0], this.maxLineWidth, this.totalHeight));
            return;
        }
        this.totalHeight = 0.0;
        this.maxLineWidth = 0.0;
        for (String line : lines) {
            String[] words;
            double currentWidth = 0.0;
            double wordWidth = 0.0;
            double wordHeight = 0.0;
            StringBuilder currentLine = new StringBuilder();
            for (String w : words = line.split(" ")) {
                String word = w + " ";
                Rectangle2D bounds = this.calcBounds(word);
                wordWidth = bounds.getWidth();
                wordHeight = bounds.getHeight();
                if (currentWidth + wordWidth >= this.labelWidth) {
                    if (currentWidth > 0.0) {
                        this.measuredLines.add(new LabelLineInfo(this, currentLine.toString(), currentWidth, wordHeight));
                        this.updateBounds(currentWidth, wordHeight);
                        currentLine.delete(0, currentLine.length());
                    }
                    if (wordWidth >= this.labelWidth) {
                        this.measuredLines.add(new LabelLineInfo(this, word, wordWidth, wordHeight));
                        this.updateBounds(wordWidth, wordHeight);
                        currentWidth = 0.0;
                        continue;
                    }
                    currentLine.append(word);
                    currentWidth = wordWidth;
                    continue;
                }
                currentLine.append(word);
                currentWidth += wordWidth;
            }
            if (!(currentWidth > 0.0)) continue;
            this.measuredLines.add(new LabelLineInfo(this, currentLine.toString(), currentWidth, wordHeight));
            this.updateBounds(currentWidth, wordHeight);
        }
    }

    public double getMaxLineWidth() {
        return this.maxLineWidth;
    }

    public double getTotalHeight() {
        return this.totalHeight;
    }

    public List<LabelLineInfo> getMeasuredLines() {
        return this.measuredLines;
    }
}

