/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.internal.util;

import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.FocusManager;
import javax.swing.SwingUtilities;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.presentation.property.values.Position;
import org.slf4j.Logger;

public final class ViewUtil {
    public static String toString(Rectangle2D r) {
        return String.format("(x:%.3f, y:%.3f, w:%.3f, h:%.3f)", r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public static void invokeOnEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void invokeOnEDTAndWait(Runnable runnable) {
        ViewUtil.invokeOnEDTAndWait(runnable, null);
    }

    public static void invokeOnEDTAndWait(Runnable runnable, Logger logger) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                if (logger != null) {
                    logger.error("Unexpected error", (Throwable)e);
                }
                e.printStackTrace();
            }
        }
    }

    public static boolean isLeftMouse(MouseEvent e) {
        boolean b;
        boolean bl = b = (e.getModifiersEx() & 0x400) != 0;
        if (LookAndFeelUtil.isMac()) {
            return !e.isControlDown() && b;
        }
        return b;
    }

    public static boolean isLeftClick(MouseEvent e) {
        boolean b;
        boolean bl = b = e.getButton() == 1;
        if (LookAndFeelUtil.isMac()) {
            return !e.isControlDown() && b;
        }
        return b;
    }

    public static boolean isRightClick(MouseEvent e) {
        boolean b;
        boolean bl = b = e.getButton() == 3;
        if (!b && LookAndFeelUtil.isMac()) {
            return e.isControlDown() && !e.isMetaDown() && e.getButton() == 1;
        }
        return b;
    }

    public static boolean isMiddleClick(MouseEvent e) {
        return e.getButton() == 2;
    }

    public static boolean isSingleClick(MouseEvent e) {
        return e.getClickCount() == 1;
    }

    public static boolean isDoubleClick(MouseEvent e) {
        return e.getClickCount() == 2;
    }

    public static boolean isSingleLeftClick(MouseEvent e) {
        return ViewUtil.isLeftClick(e) && ViewUtil.isSingleClick(e);
    }

    public static boolean isSingleRightClick(MouseEvent e) {
        return ViewUtil.isRightClick(e) && ViewUtil.isSingleClick(e);
    }

    public static boolean isDoubleLeftClick(MouseEvent e) {
        return ViewUtil.isLeftClick(e) && ViewUtil.isDoubleClick(e);
    }

    public static boolean isDragSelectionKeyDown(InputEvent e) {
        return e.isShiftDown() || ViewUtil.isControlOrMetaDown(e);
    }

    public static boolean isAdditiveSelect(InputEvent e) {
        return e.isShiftDown() || ViewUtil.isControlOrMetaDown(e);
    }

    public static boolean isControlOrMetaDown(InputEvent e) {
        boolean isMac = LookAndFeelUtil.isMac();
        return isMac && e.isMetaDown() || !isMac && e.isControlDown();
    }

    public static Window getActiveWindow(DRenderingEngine re) {
        Window window = SwingUtilities.getWindowAncestor(re.getComponent());
        if (window == null) {
            window = FocusManager.getCurrentManager().getActiveWindow();
        }
        return window;
    }

    public static Cursor getResizeCursor(Position anchor) {
        switch (anchor) {
            case NORTH_EAST: {
                return Cursor.getPredefinedCursor(7);
            }
            case NORTH: {
                return Cursor.getPredefinedCursor(8);
            }
            case NORTH_WEST: {
                return Cursor.getPredefinedCursor(6);
            }
            case WEST: {
                return Cursor.getPredefinedCursor(10);
            }
            case SOUTH_WEST: {
                return Cursor.getPredefinedCursor(4);
            }
            case SOUTH: {
                return Cursor.getPredefinedCursor(9);
            }
            case SOUTH_EAST: {
                return Cursor.getPredefinedCursor(5);
            }
            case EAST: {
                return Cursor.getPredefinedCursor(11);
            }
        }
        return null;
    }

    private ViewUtil() {
    }
}

